// SPDX-License-Identifier: GPL-2.0+
//
// Copyright (C) 2015-2017 Socionext Inc.
//   Author: Masahiro Yamada <yamada.masahiro@socionext.com>

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/mod_devicetable.h>
#include <linux/pinctrl/pinctrl.h>
#include <linux/platform_device.h>

#include "pinctrl-uniphier.h"

static const struct pinctrl_pin_desc uniphier_ld6b_pins[] = {
	UNIPHIER_PINCTRL_PIN(0, "ED0", UNIPHIER_PIN_IECTRL_NONE,
			     0, UNIPHIER_PIN_DRV_1BIT,
			     0, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(1, "ED1", UNIPHIER_PIN_IECTRL_NONE,
			     1, UNIPHIER_PIN_DRV_1BIT,
			     1, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(2, "ED2", UNIPHIER_PIN_IECTRL_NONE,
			     2, UNIPHIER_PIN_DRV_1BIT,
			     2, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(3, "ED3", UNIPHIER_PIN_IECTRL_NONE,
			     3, UNIPHIER_PIN_DRV_1BIT,
			     3, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(4, "ED4", UNIPHIER_PIN_IECTRL_NONE,
			     4, UNIPHIER_PIN_DRV_1BIT,
			     4, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(5, "ED5", UNIPHIER_PIN_IECTRL_NONE,
			     5, UNIPHIER_PIN_DRV_1BIT,
			     5, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(6, "ED6", UNIPHIER_PIN_IECTRL_NONE,
			     6, UNIPHIER_PIN_DRV_1BIT,
			     6, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(7, "ED7", UNIPHIER_PIN_IECTRL_NONE,
			     7, UNIPHIER_PIN_DRV_1BIT,
			     7, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(8, "XERWE0", UNIPHIER_PIN_IECTRL_NONE,
			     8, UNIPHIER_PIN_DRV_1BIT,
			     8, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(9, "XERWE1", UNIPHIER_PIN_IECTRL_NONE,
			     9, UNIPHIER_PIN_DRV_1BIT,
			     9, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(10, "ERXW", UNIPHIER_PIN_IECTRL_NONE,
			     10, UNIPHIER_PIN_DRV_1BIT,
			     10, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(11, "ES0", UNIPHIER_PIN_IECTRL_NONE,
			     11, UNIPHIER_PIN_DRV_1BIT,
			     11, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(12, "ES1", UNIPHIER_PIN_IECTRL_NONE,
			     12, UNIPHIER_PIN_DRV_1BIT,
			     12, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(13, "ES2", UNIPHIER_PIN_IECTRL_NONE,
			     13, UNIPHIER_PIN_DRV_1BIT,
			     13, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(14, "XECS1", UNIPHIER_PIN_IECTRL_NONE,
			     14, UNIPHIER_PIN_DRV_1BIT,
			     14, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(15, "PCA00", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     15, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(16, "PCA01", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     16, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(17, "PCA02", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     17, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(18, "PCA03", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     18, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(19, "PCA04", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     19, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(20, "PCA05", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     20, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(21, "PCA06", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     21, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(22, "PCA07", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     22, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(23, "PCA08", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     23, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(24, "PCA09", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     24, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(25, "PCA10", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     25, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(26, "PCA11", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     26, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(27, "PCA12", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     27, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(28, "PCA13", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     28, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(29, "PCA14", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     29, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(30, "XNFRE", UNIPHIER_PIN_IECTRL_NONE,
			     30, UNIPHIER_PIN_DRV_1BIT,
			     30, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(31, "XNFWE", UNIPHIER_PIN_IECTRL_NONE,
			     31, UNIPHIER_PIN_DRV_1BIT,
			     31, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(32, "NFALE", UNIPHIER_PIN_IECTRL_NONE,
			     32, UNIPHIER_PIN_DRV_1BIT,
			     32, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(33, "NFCLE", UNIPHIER_PIN_IECTRL_NONE,
			     33, UNIPHIER_PIN_DRV_1BIT,
			     33, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(34, "XNFWP", UNIPHIER_PIN_IECTRL_NONE,
			     34, UNIPHIER_PIN_DRV_1BIT,
			     34, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(35, "XNFCE0", UNIPHIER_PIN_IECTRL_NONE,
			     35, UNIPHIER_PIN_DRV_1BIT,
			     35, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(36, "NFRYBY0", UNIPHIER_PIN_IECTRL_NONE,
			     36, UNIPHIER_PIN_DRV_1BIT,
			     36, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(37, "XNFCE1", UNIPHIER_PIN_IECTRL_NONE,
			     37, UNIPHIER_PIN_DRV_1BIT,
			     37, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(38, "NFRYBY1", UNIPHIER_PIN_IECTRL_NONE,
			     38, UNIPHIER_PIN_DRV_1BIT,
			     38, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(39, "NFD0", UNIPHIER_PIN_IECTRL_NONE,
			     39, UNIPHIER_PIN_DRV_1BIT,
			     39, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(40, "NFD1", UNIPHIER_PIN_IECTRL_NONE,
			     40, UNIPHIER_PIN_DRV_1BIT,
			     40, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(41, "NFD2", UNIPHIER_PIN_IECTRL_NONE,
			     41, UNIPHIER_PIN_DRV_1BIT,
			     41, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(42, "NFD3", UNIPHIER_PIN_IECTRL_NONE,
			     42, UNIPHIER_PIN_DRV_1BIT,
			     42, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(43, "NFD4", UNIPHIER_PIN_IECTRL_NONE,
			     43, UNIPHIER_PIN_DRV_1BIT,
			     43, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(44, "NFD5", UNIPHIER_PIN_IECTRL_NONE,
			     44, UNIPHIER_PIN_DRV_1BIT,
			     44, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(45, "NFD6", UNIPHIER_PIN_IECTRL_NONE,
			     45, UNIPHIER_PIN_DRV_1BIT,
			     45, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(46, "NFD7", UNIPHIER_PIN_IECTRL_NONE,
			     46, UNIPHIER_PIN_DRV_1BIT,
			     46, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(47, "SDCLK", UNIPHIER_PIN_IECTRL_NONE,
			     0, UNIPHIER_PIN_DRV_2BIT,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(48, "SDCMD", UNIPHIER_PIN_IECTRL_NONE,
			     1, UNIPHIER_PIN_DRV_2BIT,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(49, "SDDAT0", UNIPHIER_PIN_IECTRL_NONE,
			     2, UNIPHIER_PIN_DRV_2BIT,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(50, "SDDAT1", UNIPHIER_PIN_IECTRL_NONE,
			     3, UNIPHIER_PIN_DRV_2BIT,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(51, "SDDAT2", UNIPHIER_PIN_IECTRL_NONE,
			     4, UNIPHIER_PIN_DRV_2BIT,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(52, "SDDAT3", UNIPHIER_PIN_IECTRL_NONE,
			     5, UNIPHIER_PIN_DRV_2BIT,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(53, "SDCD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     53, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(54, "SDWP", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     54, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(55, "SDVOLC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     55, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(56, "USB0VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     56, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(57, "USB0OD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     57, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(58, "USB1VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     58, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(59, "USB1OD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     59, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(60, "USB2VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     60, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(61, "USB2OD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     61, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(62, "USB3VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     62, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(63, "USB3OD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     63, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(64, "HS0BCLKOUT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     64, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(65, "HS0SYNCOUT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     65, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(66, "HS0VALOUT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     66, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(67, "HS0DOUT0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     67, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(68, "HS0DOUT1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     68, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(69, "HS0DOUT2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     69, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(70, "HS0DOUT3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     70, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(71, "HS0DOUT4", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     71, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(72, "HS0DOUT5", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     72, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(73, "HS0DOUT6", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     73, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(74, "HS0DOUT7", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     74, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(75, "HS1BCLKIN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     75, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(76, "HS1SYNCIN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     76, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(77, "HS1VALIN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     77, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(78, "HS1DIN0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     78, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(79, "HS1DIN1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     79, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(80, "HS1DIN2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     80, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(81, "HS1DIN3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     81, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(82, "HS1DIN4", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     82, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(83, "HS1DIN5", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     83, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(84, "HS1DIN6", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     84, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(85, "HS1DIN7", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     85, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(86, "HS2BCLKIN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     86, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(87, "HS2SYNCIN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     87, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(88, "HS2VALIN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     88, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(89, "HS2DIN0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     89, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(90, "HS2DIN1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     90, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(91, "HS2DIN2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     91, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(92, "HS2DIN3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     92, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(93, "HS2DIN4", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     93, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(94, "HS2DIN5", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     94, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(95, "HS2DIN6", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     95, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(96, "HS2DIN7", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     96, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(97, "AO1IEC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     97, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(98, "AO1DACCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     98, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(99, "AO1BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     99, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(100, "AO1LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     100, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(101, "AO1D0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     101, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(102, "AO1D1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     102, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(103, "AO1D2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     103, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(104, "AO1D3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     104, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(105, "AO2DACCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     105, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(106, "AO2BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     106, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(107, "AO2LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     107, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(108, "AO2D0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     108, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(109, "SDA0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     109, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(110, "SCL0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     110, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(111, "SDA1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     111, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(112, "SCL1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     112, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(113, "SBO0", 0,
			     113, UNIPHIER_PIN_DRV_1BIT,
			     113, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(114, "SBI0", 0,
			     114, UNIPHIER_PIN_DRV_1BIT,
			     114, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(115, "TXD1", 0,
			     115, UNIPHIER_PIN_DRV_1BIT,
			     115, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(116, "RXD1", 0,
			     116, UNIPHIER_PIN_DRV_1BIT,
			     116, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(117, "PWSRA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     117, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(118, "XIRQ0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     118, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(119, "XIRQ1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     119, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(120, "XIRQ2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     120, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(121, "XIRQ3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     121, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(122, "XIRQ4", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     122, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(123, "XIRQ5", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     123, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(124, "XIRQ6", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     124, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(125, "XIRQ7", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     125, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(126, "XIRQ8", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     126, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(127, "PORT00", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     127, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(128, "PORT01", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     128, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(129, "PORT02", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     129, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(130, "PORT03", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     130, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(131, "PORT04", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     131, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(132, "PORT05", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     132, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(133, "PORT06", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     133, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(134, "PORT07", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     134, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(135, "PORT10", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     135, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(136, "PORT11", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     136, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(137, "PORT12", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     137, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(138, "PORT13", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     138, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(139, "PORT14", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     139, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(140, "PORT15", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     140, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(141, "PORT16", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     141, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(142, "LPST", UNIPHIER_PIN_IECTRL_NONE,
			     142, UNIPHIER_PIN_DRV_1BIT,
			     142, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(143, "MDC", 0,
			     143, UNIPHIER_PIN_DRV_1BIT,
			     143, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(144, "MDIO", 0,
			     144, UNIPHIER_PIN_DRV_1BIT,
			     144, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(145, "MDIO_INTL", 0,
			     145, UNIPHIER_PIN_DRV_1BIT,
			     145, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(146, "PHYRSTL", 0,
			     146, UNIPHIER_PIN_DRV_1BIT,
			     146, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(147, "RGMII_RXCLK", 0,
			     147, UNIPHIER_PIN_DRV_1BIT,
			     147, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(148, "RGMII_RXD0", 0,
			     148, UNIPHIER_PIN_DRV_1BIT,
			     148, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(149, "RGMII_RXD1", 0,
			     149, UNIPHIER_PIN_DRV_1BIT,
			     149, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(150, "RGMII_RXD2", 0,
			     150, UNIPHIER_PIN_DRV_1BIT,
			     150, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(151, "RGMII_RXD3", 0,
			     151, UNIPHIER_PIN_DRV_1BIT,
			     151, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(152, "RGMII_RXCTL", 0,
			     152, UNIPHIER_PIN_DRV_1BIT,
			     152, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(153, "RGMII_TXCLK", 0,
			     153, UNIPHIER_PIN_DRV_1BIT,
			     153, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(154, "RGMII_TXD0", 0,
			     154, UNIPHIER_PIN_DRV_1BIT,
			     154, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(155, "RGMII_TXD1", 0,
			     155, UNIPHIER_PIN_DRV_1BIT,
			     155, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(156, "RGMII_TXD2", 0,
			     156, UNIPHIER_PIN_DRV_1BIT,
			     156, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(157, "RGMII_TXD3", 0,
			     157, UNIPHIER_PIN_DRV_1BIT,
			     157, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(158, "RGMII_TXCTL", 0,
			     158, UNIPHIER_PIN_DRV_1BIT,
			     158, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(159, "A_D_PCD00OUT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     159, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(160, "A_D_PCD01OUT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     160, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(161, "A_D_PCD02OUT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     161, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(162, "A_D_PCD03OUT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     162, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(163, "A_D_PCD04OUT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     163, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(164, "A_D_PCD05OUT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     164, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(165, "A_D_PCD06OUT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     165, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(166, "A_D_PCD07OUT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     166, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(167, "A_D_PCD00IN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     167, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(168, "A_D_PCD01IN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     168, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(169, "A_D_PCD02IN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     169, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(170, "A_D_PCD03IN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     170, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(171, "A_D_PCD04IN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     171, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(172, "A_D_PCD05IN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     172, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(173, "A_D_PCD06IN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     173, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(174, "A_D_PCD07IN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     174, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(175, "A_D_PCDNOE", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     175, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(176, "A_D_PC0READY", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     176, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(177, "A_D_PC0CD1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     177, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(178, "A_D_PC0CD2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     178, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(179, "A_D_PC0WAIT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     179, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(180, "A_D_PC0RESET", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     180, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(181, "A_D_PC0CE1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     181, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(182, "A_D_PC0WE", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     182, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(183, "A_D_PC0OE", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     183, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(184, "A_D_PC0IOWR", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     184, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(185, "A_D_PC0IORD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     185, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(186, "A_D_PC0NOE", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     186, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(187, "A_D_HS0BCLKIN", 0,
			     187, UNIPHIER_PIN_DRV_1BIT,
			     187, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(188, "A_D_HS0SYNCIN", 0,
			     188, UNIPHIER_PIN_DRV_1BIT,
			     188, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(189, "A_D_HS0VALIN", 0,
			     189, UNIPHIER_PIN_DRV_1BIT,
			     189, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(190, "A_D_HS0DIN0", 0,
			     190, UNIPHIER_PIN_DRV_1BIT,
			     190, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(191, "A_D_HS0DIN1", 0,
			     191, UNIPHIER_PIN_DRV_1BIT,
			     191, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(192, "A_D_HS0DIN2", 0,
			     192, UNIPHIER_PIN_DRV_1BIT,
			     192, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(193, "A_D_HS0DIN3", 0,
			     193, UNIPHIER_PIN_DRV_1BIT,
			     193, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(194, "A_D_HS0DIN4", 0,
			     194, UNIPHIER_PIN_DRV_1BIT,
			     194, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(195, "A_D_HS0DIN5", 0,
			     195, UNIPHIER_PIN_DRV_1BIT,
			     195, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(196, "A_D_HS0DIN6", 0,
			     196, UNIPHIER_PIN_DRV_1BIT,
			     196, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(197, "A_D_HS0DIN7", 0,
			     197, UNIPHIER_PIN_DRV_1BIT,
			     197, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(198, "A_D_AO1ARC", 0,
			     198, UNIPHIER_PIN_DRV_1BIT,
			     198, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(199, "A_D_SPIXRST", UNIPHIER_PIN_IECTRL_NONE,
			     199, UNIPHIER_PIN_DRV_1BIT,
			     199, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(200, "A_D_SPISCLK0", UNIPHIER_PIN_IECTRL_NONE,
			     200, UNIPHIER_PIN_DRV_1BIT,
			     200, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(201, "A_D_SPITXD0", UNIPHIER_PIN_IECTRL_NONE,
			     201, UNIPHIER_PIN_DRV_1BIT,
			     201, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(202, "A_D_SPIRXD0", UNIPHIER_PIN_IECTRL_NONE,
			     202, UNIPHIER_PIN_DRV_1BIT,
			     202, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(203, "A_D_DMDCLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     203, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(204, "A_D_DMDPSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     204, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(205, "A_D_DMDVAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     205, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(206, "A_D_DMDDATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     206, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(207, "A_D_HDMIRXXIRQ", 0,
			     207, UNIPHIER_PIN_DRV_1BIT,
			     207, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(208, "A_D_VBIXIRQ", 0,
			     208, UNIPHIER_PIN_DRV_1BIT,
			     208, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(209, "A_D_HDMITXXIRQ", 0,
			     209, UNIPHIER_PIN_DRV_1BIT,
			     209, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(210, "A_D_DMDIRQ", UNIPHIER_PIN_IECTRL_NONE,
			     210, UNIPHIER_PIN_DRV_1BIT,
			     210, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(211, "A_D_SPICIRQ", UNIPHIER_PIN_IECTRL_NONE,
			     211, UNIPHIER_PIN_DRV_1BIT,
			     211, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(212, "A_D_SPIBIRQ", UNIPHIER_PIN_IECTRL_NONE,
			     212, UNIPHIER_PIN_DRV_1BIT,
			     212, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(213, "A_D_BESDAOUT", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     213, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(214, "A_D_BESDAIN", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     214, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(215, "A_D_BESCLOUT", UNIPHIER_PIN_IECTRL_NONE,
			     215, UNIPHIER_PIN_DRV_1BIT,
			     215, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(216, "A_D_VDACCLKOUT", 0,
			     216, UNIPHIER_PIN_DRV_1BIT,
			     216, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(217, "A_D_VDACDOUT5", 0,
			     217, UNIPHIER_PIN_DRV_1BIT,
			     217, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(218, "A_D_VDACDOUT6", 0,
			     218, UNIPHIER_PIN_DRV_1BIT,
			     218, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(219, "A_D_VDACDOUT7", 0,
			     219, UNIPHIER_PIN_DRV_1BIT,
			     219, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(220, "A_D_VDACDOUT8", 0,
			     220, UNIPHIER_PIN_DRV_1BIT,
			     220, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(221, "A_D_VDACDOUT9", 0,
			     221, UNIPHIER_PIN_DRV_1BIT,
			     221, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(222, "A_D_SIFBCKIN", 0,
			     222, UNIPHIER_PIN_DRV_1BIT,
			     222, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(223, "A_D_SIFLRCKIN", 0,
			     223, UNIPHIER_PIN_DRV_1BIT,
			     223, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(224, "A_D_SIFDIN", 0,
			     224, UNIPHIER_PIN_DRV_1BIT,
			     224, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(225, "A_D_LIBCKOUT", 0,
			     225, UNIPHIER_PIN_DRV_1BIT,
			     225, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(226, "A_D_LILRCKOUT", 0,
			     226, UNIPHIER_PIN_DRV_1BIT,
			     226, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(227, "A_D_LIDIN", 0,
			     227, UNIPHIER_PIN_DRV_1BIT,
			     227, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(228, "A_D_LODOUT", 0,
			     228, UNIPHIER_PIN_DRV_1BIT,
			     228, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(229, "A_D_HPDOUT", 0,
			     229, UNIPHIER_PIN_DRV_1BIT,
			     229, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(230, "A_D_MCLK", 0,
			     230, UNIPHIER_PIN_DRV_1BIT,
			     230, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(231, "A_D_A2PLLREFOUT", 0,
			     231, UNIPHIER_PIN_DRV_1BIT,
			     231, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(232, "A_D_HDMI3DSDAOUT", 0,
			     232, UNIPHIER_PIN_DRV_1BIT,
			     232, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(233, "A_D_HDMI3DSDAIN", 0,
			     233, UNIPHIER_PIN_DRV_1BIT,
			     233, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(234, "A_D_HDMI3DSCLIN", 0,
			     234, UNIPHIER_PIN_DRV_1BIT,
			     234, UNIPHIER_PIN_PULL_DOWN),
};

static const unsigned adinter_pins[] = {
	159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172,
	173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186,
	187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200,
	201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214,
	215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
	229, 230, 231, 232, 233, 234,
};
static const int adinter_muxvals[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0,
};
static const unsigned emmc_pins[] = {36, 37, 38, 39, 40, 41, 42};
static const int emmc_muxvals[] = {1, 1, 1, 1, 1, 1, 1};
static const unsigned emmc_dat8_pins[] = {43, 44, 45, 46};
static const int emmc_dat8_muxvals[] = {1, 1, 1, 1};
static const unsigned ether_rgmii_pins[] = {143, 144, 145, 146, 147, 148, 149,
					    150, 151, 152, 153, 154, 155, 156,
					    157, 158};
static const int ether_rgmii_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					  0, 0, 0, 0};
static const unsigned ether_rmii_pins[] = {143, 144, 145, 146, 147, 148, 149,
					   150, 152, 154, 155, 158};
static const int ether_rmii_muxvals[] = {0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1};
static const unsigned i2c0_pins[] = {109, 110};
static const int i2c0_muxvals[] = {0, 0};
static const unsigned i2c1_pins[] = {111, 112};
static const int i2c1_muxvals[] = {0, 0};
static const unsigned i2c2_pins[] = {115, 116};
static const int i2c2_muxvals[] = {1, 1};
static const unsigned i2c3_pins[] = {118, 119};
static const int i2c3_muxvals[] = {1, 1};
static const unsigned nand_pins[] = {30, 31, 32, 33, 34, 35, 36, 39, 40, 41,
				     42, 43, 44, 45, 46};
static const int nand_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const unsigned nand_cs1_pins[] = {37, 38};
static const int nand_cs1_muxvals[] = {0, 0};
static const unsigned sd_pins[] = {47, 48, 49, 50, 51, 52, 53, 54, 55};
static const int sd_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};
static const unsigned spi0_pins[] = {199, 200, 201, 202};
static const int spi0_muxvals[] = {8, 8, 8, 8};
static const unsigned spi1_pins[] = {93, 94, 95, 96};
static const int spi1_muxvals[] = {1, 1, 1, 1};
static const unsigned system_bus_pins[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
					   11, 12, 13};
static const int system_bus_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					 0};
static const unsigned system_bus_cs1_pins[] = {14};
static const int system_bus_cs1_muxvals[] = {0};
static const unsigned system_bus_cs2_pins[] = {37};
static const int system_bus_cs2_muxvals[] = {6};
static const unsigned system_bus_cs3_pins[] = {38};
static const int system_bus_cs3_muxvals[] = {6};
static const unsigned system_bus_cs4_pins[] = {115};
static const int system_bus_cs4_muxvals[] = {6};
static const unsigned system_bus_cs5_pins[] = {55};
static const int system_bus_cs5_muxvals[] = {6};
static const unsigned uart0_pins[] = {135, 136};
static const int uart0_muxvals[] = {3, 3};
static const unsigned uart0_ctsrts_pins[] = {137, 138, 139, 140, 141, 124};
static const int uart0_ctsrts_muxvals[] = {3, 3, 3, 3, 3, 3};
static const unsigned uart0b_pins[] = {11, 12};
static const int uart0b_muxvals[] = {2, 2};
static const unsigned uart1_pins[] = {115, 116};
static const int uart1_muxvals[] = {0, 0};
static const unsigned uart1b_pins[] = {113, 114};
static const int uart1b_muxvals[] = {1, 1};
static const unsigned uart2_pins[] = {113, 114};
static const int uart2_muxvals[] = {2, 2};
static const unsigned uart2b_pins[] = {86, 87};
static const int uart2b_muxvals[] = {1, 1};
static const unsigned usb0_pins[] = {56, 57};
static const int usb0_muxvals[] = {0, 0};
static const unsigned usb1_pins[] = {58, 59};
static const int usb1_muxvals[] = {0, 0};
static const unsigned usb2_pins[] = {60, 61};
static const int usb2_muxvals[] = {0, 0};
static const unsigned usb3_pins[] = {62, 63};
static const int usb3_muxvals[] = {0, 0};
static const unsigned int gpio_range0_pins[] = {
	127, 128, 129, 130, 131, 132, 133, 134,		/* PORT0x */
	135, 136, 137, 138, 139, 140, 141, 142,		/* PORT1x */
	0, 1, 2, 3, 4, 5, 6, 7,				/* PORT2x */
	8, 9, 10, 11, 12, 13, 14, 15,			/* PORT3x */
	16, 17, 18, 19, 21, 22, 23, 24,			/* PORT4x */
	25, 30, 31, 32, 33, 34, 35, 36,			/* PORT5x */
	37, 38, 39, 40, 41, 42, 43, 44,			/* PORT6x */
	45, 46, 47, 48, 49, 50, 51, 52,			/* PORT7x */
	53, 54, 55, 56, 57, 58, 59, 60,			/* PORT8x */
	61, 62, 63, 64, 65, 66, 67, 68,			/* PORT9x */
	69, 70, 71, 76, 77, 78, 79, 80,			/* PORT10x */
};
static const unsigned int gpio_range1_pins[] = {
	81, 82, 83, 84, 85, 86, 87, 88,			/* PORT12x */
	89, 90, 95, 96, 97, 98, 99, 100,		/* PORT13x */
	101, 102, 103, 104, 105, 106, 107, 108,		/* PORT14x */
	118, 119, 120, 121, 122, 123, 124, 125,		/* XIRQ0-7 */
	126, 72, 73, 92, 177, 93, 94, 176,		/* XIRQ8-15 */
	74, 91, 27, 28, 29, 75, 20, 26,			/* XIRQ16-23 */
	109, 110, 111, 112, 113, 114, 115, 116,		/* PORT18x */
	117, 143, 144, 145, 146, 147, 148, 149,		/* PORT19x */
	150, 151, 152, 153, 154, 155, 156, 157,		/* PORT20x */
	158, 159, 160, 161, 162, 163, 164, 165,		/* PORT21x */
	166, 178, 179, 180, 181, 182, 183, 184,		/* PORT22x */
	185, 187, 188, 189, 190, 191, 192, 193,		/* PORT23x */
	194, 195, 196, 197, 198, 199, 200, 201,		/* PORT24x */
	202, 203, 204, 205, 206, 207, 208, 209,		/* PORT25x */
	210, 211, 212, 213, 214, 215, 216, 217,		/* PORT26x */
	218, 219, 220, 221, 223, 224, 225, 226,		/* PORT27x */
	227, 228, 229, 230, 231, 232, 233, 234,		/* PORT28x */
};

static const struct uniphier_pinctrl_group uniphier_ld6b_groups[] = {
	UNIPHIER_PINCTRL_GROUP(adinter),
	UNIPHIER_PINCTRL_GROUP(emmc),
	UNIPHIER_PINCTRL_GROUP(emmc_dat8),
	UNIPHIER_PINCTRL_GROUP(ether_rgmii),
	UNIPHIER_PINCTRL_GROUP(ether_rmii),
	UNIPHIER_PINCTRL_GROUP(i2c0),
	UNIPHIER_PINCTRL_GROUP(i2c1),
	UNIPHIER_PINCTRL_GROUP(i2c2),
	UNIPHIER_PINCTRL_GROUP(i2c3),
	UNIPHIER_PINCTRL_GROUP(nand),
	UNIPHIER_PINCTRL_GROUP(nand_cs1),
	UNIPHIER_PINCTRL_GROUP(sd),
	UNIPHIER_PINCTRL_GROUP(spi0),
	UNIPHIER_PINCTRL_GROUP(spi1),
	UNIPHIER_PINCTRL_GROUP(system_bus),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs1),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs2),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs3),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs4),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs5),
	UNIPHIER_PINCTRL_GROUP(uart0),
	UNIPHIER_PINCTRL_GROUP(uart0_ctsrts),
	UNIPHIER_PINCTRL_GROUP(uart0b),
	UNIPHIER_PINCTRL_GROUP(uart1),
	UNIPHIER_PINCTRL_GROUP(uart1b),
	UNIPHIER_PINCTRL_GROUP(uart2),
	UNIPHIER_PINCTRL_GROUP(uart2b),
	UNIPHIER_PINCTRL_GROUP(usb0),
	UNIPHIER_PINCTRL_GROUP(usb1),
	UNIPHIER_PINCTRL_GROUP(usb2),
	UNIPHIER_PINCTRL_GROUP(usb3),
	UNIPHIER_PINCTRL_GROUP_GPIO(gpio_range0),
	UNIPHIER_PINCTRL_GROUP_GPIO(gpio_range1),
};

static const char * const adinter_groups[] = {"adinter"};
static const char * const emmc_groups[] = {"emmc", "emmc_dat8"};
static const char * const ether_rgmii_groups[] = {"ether_rgmii"};
static const char * const ether_rmii_groups[] = {"ether_rmii"};
static const char * const i2c0_groups[] = {"i2c0"};
static const char * const i2c1_groups[] = {"i2c1"};
static const char * const i2c2_groups[] = {"i2c2"};
static const char * const i2c3_groups[] = {"i2c3"};
static const char * const nand_groups[] = {"nand", "nand_cs1"};
static const char * const sd_groups[] = {"sd"};
static const char * const spi0_groups[] = {"spi0"};
static const char * const spi1_groups[] = {"spi1"};
static const char * const system_bus_groups[] = {"system_bus",
						 "system_bus_cs1",
						 "system_bus_cs2",
						 "system_bus_cs3",
						 "system_bus_cs4",
						 "system_bus_cs5"};
static const char * const uart0_groups[] = {"uart0", "uart0_ctsrts", "uart0b"};
static const char * const uart1_groups[] = {"uart1", "uart1b"};
static const char * const uart2_groups[] = {"uart2", "uart2b"};
static const char * const usb0_groups[] = {"usb0"};
static const char * const usb1_groups[] = {"usb1"};
static const char * const usb2_groups[] = {"usb2"};
static const char * const usb3_groups[] = {"usb3"};

static const struct uniphier_pinmux_function uniphier_ld6b_functions[] = {
	UNIPHIER_PINMUX_FUNCTION(adinter), /* Achip-Dchip interconnect */
	UNIPHIER_PINMUX_FUNCTION(emmc),
	UNIPHIER_PINMUX_FUNCTION(ether_rgmii),
	UNIPHIER_PINMUX_FUNCTION(ether_rmii),
	UNIPHIER_PINMUX_FUNCTION(i2c0),
	UNIPHIER_PINMUX_FUNCTION(i2c1),
	UNIPHIER_PINMUX_FUNCTION(i2c2),
	UNIPHIER_PINMUX_FUNCTION(i2c3),
	UNIPHIER_PINMUX_FUNCTION(nand),
	UNIPHIER_PINMUX_FUNCTION(sd),
	UNIPHIER_PINMUX_FUNCTION(spi0),
	UNIPHIER_PINMUX_FUNCTION(spi1),
	UNIPHIER_PINMUX_FUNCTION(system_bus),
	UNIPHIER_PINMUX_FUNCTION(uart0),
	UNIPHIER_PINMUX_FUNCTION(uart1),
	UNIPHIER_PINMUX_FUNCTION(uart2),
	UNIPHIER_PINMUX_FUNCTION(usb0),
	UNIPHIER_PINMUX_FUNCTION(usb1),
	UNIPHIER_PINMUX_FUNCTION(usb2),
	UNIPHIER_PINMUX_FUNCTION(usb3),
};

static int uniphier_ld6b_get_gpio_muxval(unsigned int pin,
					 unsigned int gpio_offset)
{
	if (gpio_offset >= 120 && gpio_offset <= 143)	/* XIRQx */
		/* 15 will do because XIRQ0-23 are aliases of PORT150-177. */
		return 14;

	return 15;
}

static const struct uniphier_pinctrl_socdata uniphier_ld6b_pindata = {
	.pins = uniphier_ld6b_pins,
	.npins = ARRAY_SIZE(uniphier_ld6b_pins),
	.groups = uniphier_ld6b_groups,
	.groups_count = ARRAY_SIZE(uniphier_ld6b_groups),
	.functions = uniphier_ld6b_functions,
	.functions_count = ARRAY_SIZE(uniphier_ld6b_functions),
	.get_gpio_muxval = uniphier_ld6b_get_gpio_muxval,
	.caps = 0,
};

static int uniphier_ld6b_pinctrl_probe(struct platform_device *pdev)
{
	return uniphier_pinctrl_probe(pdev, &uniphier_ld6b_pindata);
}

static const struct of_device_id uniphier_ld6b_pinctrl_match[] = {
	{ .compatible = "socionext,uniphier-ld6b-pinctrl" },
	{ /* sentinel */ }
};

static struct platform_driver uniphier_ld6b_pinctrl_driver = {
	.probe = uniphier_ld6b_pinctrl_probe,
	.driver = {
		.name = "uniphier-ld6b-pinctrl",
		.of_match_table = uniphier_ld6b_pinctrl_match,
		.pm = &uniphier_pinctrl_pm_ops,
	},
};
builtin_platform_driver(uniphier_ld6b_pinctrl_driver);
