/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.java.sql;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.harmony.sql.tests.java.sql.DriverManagerTest;
import org.apache.harmony.sql.tests.java.sql.TestHelper_ClassLoader;
import tests.support.Support_Exec;

/*
 * Exception performing whole class analysis ignored.
 */
public class DriverManagerTest
extends TestCase {
    static final String DRIVER1 = "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver1";
    static final String DRIVER2 = "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver2";
    static final String DRIVER3 = "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver3";
    static final String DRIVER4 = "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver4";
    static final String DRIVER5 = "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver5";
    static final String INVALIDDRIVER1 = "abc.klm.Foo";
    static String[] driverNames = new String[]{"org.apache.harmony.sql.tests.java.sql.TestHelper_Driver1", "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver2", "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver4", "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver5"};
    static int numberLoaded;
    static String baseURL1;
    static String baseURL4;
    static final String JDBC_PROPERTY = "jdbc.drivers";
    static TestHelper_ClassLoader testClassLoader;
    static String validConnectionURL;
    static String invalidConnectionURL1;
    static String invalidConnectionURL2;
    static String invalidConnectionURL3;
    static String[] invalidConnectionURLs;
    static String validURL1;
    static String validURL2;
    static String invalidURL1;
    static String invalidURL2;
    static String[] validURLs;
    static String[] invalidURLs;
    static String exceptionMsg1;
    static int timeout1;
    static String testMessage;
    static int validTimeout1;
    static int validTimeout2;
    static int[] validTimeouts;
    static int invalidTimeout1;
    static ByteArrayOutputStream outputStream2;
    static PrintStream testPrintStream;
    static ByteArrayOutputStream outputStream;
    static PrintWriter testPrintWriter;
    static boolean driversLoaded;

    static {
        baseURL1 = "jdbc:mikes1";
        baseURL4 = "jdbc:mikes4";
        testClassLoader = new TestHelper_ClassLoader();
        validConnectionURL = "jdbc:mikes1:data1";
        invalidConnectionURL1 = "jdbc:mikes1:data2";
        invalidConnectionURL2 = "xyz1:abc3:456q";
        invalidConnectionURL3 = null;
        invalidConnectionURLs = new String[]{invalidConnectionURL2, invalidConnectionURL3};
        validURL1 = "jdbc:mikes1";
        validURL2 = "jdbc:mikes2";
        invalidURL1 = "xyz:acb";
        invalidURL2 = null;
        validURLs = new String[]{validURL1, validURL2};
        invalidURLs = new String[]{invalidURL1, invalidURL2};
        exceptionMsg1 = "No suitable driver";
        timeout1 = 25;
        testMessage = "DriverManagerTest: test message for print stream";
        validTimeout1 = 15;
        validTimeout2 = 0;
        validTimeouts = new int[]{validTimeout1, validTimeout2};
        invalidTimeout1 = -10;
        outputStream2 = new ByteArrayOutputStream();
        testPrintStream = new PrintStream(outputStream2);
        outputStream = new ByteArrayOutputStream();
        testPrintWriter = new PrintWriter(outputStream);
        driversLoaded = false;
    }

    public void setUp() {
        numberLoaded = DriverManagerTest.loadDrivers();
    }

    public void testDeregisterDriver() throws SQLException {
        Driver aDriver = DriverManager.getDriver(baseURL4);
        DriverManager.deregisterDriver(aDriver);
        DriverManagerTest.assertFalse((String)"testDeregisterDriver: Driver was not deregistered.", (boolean)DriverManagerTest.isDriverLoaded((Driver)aDriver));
        DriverManager.registerDriver(aDriver);
        DriverManagerTest.assertTrue((String)"testDeregisterDriver: Driver did not reload.", (boolean)DriverManagerTest.isDriverLoaded((Driver)aDriver));
        DriverManager.deregisterDriver(null);
        aDriver = DriverManager.getDriver(baseURL1);
        try {
            Class<?> driverClass = Class.forName("org.apache.harmony.sql.tests.java.sql.TestHelper_DriverManager", true, (ClassLoader)testClassLoader);
            Class[] methodClasses = new Class[]{Class.forName("java.sql.Driver")};
            Method theMethod = driverClass.getDeclaredMethod("setDriver", methodClasses);
            Object[] args = new Object[]{aDriver};
            theMethod.invoke(null, args);
        }
        catch (Exception e) {
            System.out.println("testDeregisterDriver: Got exception allocating TestHelper");
            e.printStackTrace();
            return;
        }
        DriverManagerTest.assertTrue((String)"testDeregisterDriver: Driver was incorrectly deregistered.", (boolean)DriverManagerTest.isDriverLoaded((Driver)aDriver));
    }

    static void printClassLoader(Object theObject) {
        Class<?> theClass = theObject.getClass();
        ClassLoader theClassLoader = theClass.getClassLoader();
        System.out.println("ClassLoader is: " + theClassLoader.toString() + " for object: " + theObject.toString());
    }

    static boolean isDriverLoaded(Driver theDriver) {
        Enumeration<Driver> driverList = DriverManager.getDrivers();
        while (driverList.hasMoreElements()) {
            if (driverList.nextElement() != theDriver) continue;
            return true;
        }
        return false;
    }

    public void testGetConnectionString() throws SQLException {
        Connection theConnection = null;
        theConnection = DriverManager.getConnection(validConnectionURL);
        DriverManagerTest.assertNotNull((Object)theConnection);
        DriverManagerTest.assertNotNull((Object)DriverManager.getConnection(invalidConnectionURL1));
        String[] stringArray = invalidConnectionURLs;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String element = stringArray[n];
            try {
                theConnection = DriverManager.getConnection(element);
                DriverManagerTest.fail((String)"Should throw SQLException");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void test_getConnection_LStringLProperties() {
        try {
            DriverManager.getConnection("fff", new Properties());
            DriverManagerTest.fail((String)"Should throw SQLException.");
        }
        catch (SQLException e) {
            DriverManagerTest.assertEquals((String)"08001", (String)e.getSQLState());
        }
        try {
            DriverManager.getConnection(null, new Properties());
            DriverManagerTest.fail((String)"Should throw SQLException.");
        }
        catch (SQLException e) {
            DriverManagerTest.assertEquals((String)"08001", (String)e.getSQLState());
        }
    }

    public void testGetConnectionStringProperties() throws SQLException {
        String validURL1 = "jdbc:mikes1:data2";
        String validuser1 = "theuser";
        String validpassword1 = "thepassword";
        String invalidURL1 = "xyz:abc1:foo";
        String invalidURL2 = "jdbc:mikes1:crazyone";
        String invalidURL3 = "";
        String invaliduser1 = "jonny nouser";
        String invalidpassword1 = "whizz";
        Object nullProps = null;
        Properties validProps = new Properties();
        validProps.setProperty("user", validuser1);
        validProps.setProperty("password", validpassword1);
        Properties invalidProps1 = new Properties();
        invalidProps1.setProperty("user", invaliduser1);
        invalidProps1.setProperty("password", invalidpassword1);
        String[] stringArray = new String[4];
        stringArray[1] = invalidURL1;
        stringArray[2] = invalidURL2;
        stringArray[3] = invalidURL3;
        String[] invalidURLs = stringArray;
        Properties[] invalidProps = new Properties[]{nullProps, invalidProps1};
        Connection theConnection = null;
        theConnection = DriverManager.getConnection(validURL1, validProps);
        DriverManagerTest.assertNotNull((Object)theConnection);
        int i = 0;
        while (i < invalidURLs.length) {
            theConnection = null;
            try {
                theConnection = DriverManager.getConnection(invalidURLs[i], validProps);
                DriverManagerTest.fail((String)"Should throw SQLException");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++i;
        }
        Properties[] propertiesArray = invalidProps;
        int n = 0;
        int n2 = propertiesArray.length;
        while (n < n2) {
            Properties invalidProp = propertiesArray[n];
            DriverManagerTest.assertNotNull((Object)DriverManager.getConnection(validURL1, invalidProp));
            ++n;
        }
    }

    public void testGetConnectionStringStringString() throws SQLException {
        String[] theData;
        String validURL1 = "jdbc:mikes1:data2";
        String validuser1 = "theuser";
        String validpassword1 = "thepassword";
        String invalidURL1 = "xyz:abc1:foo";
        String invaliduser1 = "jonny nouser";
        String invalidpassword1 = "whizz";
        String[] stringArray = new String[3];
        stringArray[1] = validuser1;
        stringArray[2] = validpassword1;
        String[] invalid1 = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = validURL1;
        stringArray2[2] = validpassword1;
        String[] invalid2 = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = validURL1;
        stringArray3[1] = validuser1;
        String[] invalid3 = stringArray3;
        String[] invalid4 = new String[]{invalidURL1, validuser1, validpassword1};
        String[] invalid5 = new String[]{validURL1, invaliduser1, invalidpassword1};
        String[] invalid6 = new String[]{validURL1, validuser1, invalidpassword1};
        String[][] invalids1 = new String[][]{invalid1, invalid4};
        String[][] invalids2 = new String[][]{invalid2, invalid3, invalid5, invalid6};
        Connection theConnection = null;
        theConnection = DriverManager.getConnection(validURL1, validuser1, validpassword1);
        DriverManagerTest.assertNotNull((Object)theConnection);
        String[][] stringArrayArray = invalids1;
        int n = 0;
        int n2 = stringArrayArray.length;
        while (n < n2) {
            theData = stringArrayArray[n];
            theConnection = null;
            try {
                theConnection = DriverManager.getConnection(theData[0], theData[1], theData[2]);
                DriverManagerTest.fail((String)"Should throw SQLException.");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++n;
        }
        stringArrayArray = invalids2;
        n = 0;
        n2 = stringArrayArray.length;
        while (n < n2) {
            theData = stringArrayArray[n];
            DriverManagerTest.assertNotNull((Object)DriverManager.getConnection(theData[0], theData[1], theData[2]));
            ++n;
        }
    }

    public void testGetDriver() throws SQLException {
        String[] stringArray = validURLs;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String element = stringArray[n];
            Driver validDriver = DriverManager.getDriver(element);
            DriverManagerTest.assertNotNull((Object)validDriver);
            ++n;
        }
    }

    public void testGetDrivers() {
        Enumeration<Driver> driverList = DriverManager.getDrivers();
        int i = 0;
        while (driverList.hasMoreElements()) {
            Driver theDriver = driverList.nextElement();
            DriverManagerTest.assertNotNull((Object)theDriver);
            ++i;
        }
        DriverManagerTest.assertTrue((String)"testGetDrivers: Don't see all the loaded drivers - ", (i >= numberLoaded ? 1 : 0) != 0);
    }

    public void testGetLoginTimeout() {
        DriverManager.setLoginTimeout(timeout1);
        DriverManagerTest.assertEquals((int)timeout1, (int)DriverManager.getLoginTimeout());
    }

    public void testGetLogStream() {
        DriverManagerTest.assertNull((Object)DriverManager.getLogStream());
        DriverManager.setLogStream(testPrintStream);
        DriverManagerTest.assertTrue((DriverManager.getLogStream() == testPrintStream ? 1 : 0) != 0);
        DriverManager.setLogStream(null);
    }

    public void testGetLogWriter() {
        DriverManagerTest.assertNull((Object)DriverManager.getLogWriter());
        DriverManager.setLogWriter(testPrintWriter);
        DriverManagerTest.assertTrue((DriverManager.getLogWriter() == testPrintWriter ? 1 : 0) != 0);
        DriverManager.setLogWriter(null);
    }

    public void testPrintln() {
        DriverManager.println(testMessage);
        DriverManager.setLogWriter(testPrintWriter);
        DriverManager.println(testMessage);
        String theOutput = outputStream.toString();
        DriverManagerTest.assertTrue((boolean)theOutput.startsWith(testMessage));
        DriverManager.setLogWriter(null);
        DriverManager.setLogStream(testPrintStream);
        DriverManager.println(testMessage);
        theOutput = outputStream2.toString();
        DriverManagerTest.assertTrue((boolean)theOutput.startsWith(testMessage));
        DriverManager.setLogStream(null);
    }

    public void testRegisterDriver() throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        String EXTRA_DRIVER_NAME = "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver3";
        try {
            DriverManager.registerDriver(null);
            DriverManagerTest.fail((String)"Should throw NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Driver theDriver = null;
        Class<?> driverClass = Class.forName(EXTRA_DRIVER_NAME);
        theDriver = (Driver)driverClass.newInstance();
        DriverManager.registerDriver(theDriver);
        DriverManagerTest.assertTrue((String)"testRegisterDriver: driver not in loaded set", (boolean)DriverManagerTest.isDriverLoaded((Driver)theDriver));
    }

    public void testSetLoginTimeout() {
        int[] nArray = validTimeouts;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int element = nArray[n];
            DriverManager.setLoginTimeout(element);
            DriverManagerTest.assertEquals((int)element, (int)DriverManager.getLoginTimeout());
            ++n;
        }
        DriverManager.setLoginTimeout(invalidTimeout1);
        DriverManagerTest.assertEquals((int)invalidTimeout1, (int)DriverManager.getLoginTimeout());
    }

    public void testSetLogStream() {
        DriverManager.setLogStream(testPrintStream);
        DriverManagerTest.assertSame((Object)testPrintStream, (Object)DriverManager.getLogStream());
        DriverManager.setLogStream(null);
        DriverManagerTest.assertNull((Object)DriverManager.getLogStream());
        TestSecurityManager theSecManager = new TestSecurityManager(this);
        System.setSecurityManager((SecurityManager)theSecManager);
        theSecManager.setLogAccess(false);
        try {
            DriverManager.setLogStream(testPrintStream);
            DriverManagerTest.fail((String)"Should throw SecurityException.");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        theSecManager.setLogAccess(true);
        DriverManager.setLogStream(testPrintStream);
        System.setSecurityManager(null);
    }

    public void testSetLogWriter() {
        DriverManager.setLogWriter(testPrintWriter);
        DriverManagerTest.assertSame((Object)testPrintWriter, (Object)DriverManager.getLogWriter());
        DriverManager.setLogWriter(null);
        DriverManagerTest.assertNull((String)"testDriverManager: Log writer not null:", (Object)DriverManager.getLogWriter());
        TestSecurityManager theSecManager = new TestSecurityManager(this);
        System.setSecurityManager((SecurityManager)theSecManager);
        theSecManager.setLogAccess(false);
        try {
            DriverManager.setLogWriter(testPrintWriter);
            DriverManagerTest.fail((String)"Should throw SecurityException.");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        theSecManager.setLogAccess(true);
        DriverManager.setLogWriter(testPrintWriter);
        System.setSecurityManager(null);
    }

    private static int loadDrivers() {
        if (driversLoaded) {
            return numberLoaded;
        }
        int numberLoaded = 0;
        String[] stringArray = driverNames;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String element = stringArray[n];
            try {
                Class<?> driverClass = Class.forName(element);
                DriverManagerTest.assertNotNull(driverClass);
                ++numberLoaded;
            }
            catch (ClassNotFoundException e) {
                System.out.println("DriverManagerTest: failed to load Driver: " + element);
            }
            ++n;
        }
        driversLoaded = true;
        return numberLoaded;
    }

    public void test_registerDriver_MultiTimes() throws SQLException {
        int register_count = 10;
        int deregister_count = 1;
        DummyDriver dummy = new DummyDriver(null, null);
        DriverManager.registerDriver((Driver)new BadDummyDriver(null));
        int i = 0;
        while (i < register_count) {
            DriverManager.registerDriver((Driver)dummy);
            ++i;
        }
        DriverManager.registerDriver((Driver)new BadDummyDriver(null));
        i = 0;
        while (i < deregister_count) {
            DriverManager.deregisterDriver((Driver)dummy);
            ++i;
        }
        Driver d = DriverManager.getDriver("jdbc:dummy_protocol:dummy_subname");
        DriverManagerTest.assertNotNull((Object)d);
    }

    public void test_initClass() throws Exception {
        String[] arg = new String[]{"org/apache/harmony/sql/tests/java/sql/TestMainForDriver"};
        String result = Support_Exec.execJava((String[])arg, null, (boolean)true);
        DriverManagerTest.assertEquals((String)"", (String)result);
    }
}

