#if   !defined(__MEDIATOR_HPP)
#define __MEDIATOR

/*
   CoreLinux++ 
   Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ITERATOR_HPP)
#include <Iterator.hpp>
#endif

#if   !defined(__EVENT_HPP)
#include <Event.hpp>
#endif

namespace corelinux
{
   DECLARE_CLASS( Colleague );
   DECLARE_CLASS( Mediator );

   /**
   Mediator declares an interface for communicating with Colleague objects.
   */

   class Mediator
   {
   public:

      //
      // Constructors and destructor
      //

                        /// Default constructor

                        Mediator( void );

                        /// Copy constructor

                        Mediator( MediatorCref );

                        /// Virtual destructor

      virtual           ~Mediator( void );

      //
      // Operator overloads
      //

               /// Assignment operator

               MediatorRef operator=( MediatorCref );

               /// Equality operator

               bool operator==( MediatorCref ) const;

      //
      // The working part
      //

      virtual  void  action( Event<Identifier>* ) 
         throw ( NullPointerException );

   protected:

      //
      // Mutators
      //

               /**
               colleagueCreated requires a implementation for
               derivations that need to gather information
               from the Colleague to distribute action events
               @param Colleague pointer
               */

      virtual  void  colleagueCreated( ColleaguePtr ) = 0;

      //
      // Factory methods
      //

               /**
               When action is called on the Mediator, it
               will ask the implementation for the Colleagues
               that are interested in the event identified by
               the identifier
               @param IdentifierCref key to interested parties
               @return Iterator over Colleague pointer
               */

      virtual  Iterator<ColleaguePtr>  *createIterator( Event<Identifier>* ) = 0;

               /**
               Called when action is through with the colleague iteration
               @param Iterator over Colleague pointer
               */

      virtual  void  destroyIterator( Iterator<ColleaguePtr> * ) = 0;

   private:

   };
}

#endif // if !defined(__MEDIATOR_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/07 03:41:47 $
   $Locker:  $
*/

