/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

/**
 * A common interface for classes that support namespaces.
 * A namespace in this case consists of a {@link #getName name} made up
 * of a {@link #getPrefix prefix} and {@link #getLocalName localName}.  For
 * example in the case of this element:
 * <p>
 *       &lt;foo:bar foo:xmlns='http://example.net/foospace' /&gt;
 * </p>
 * The element local name is <code>bar</code>, the prefix is
 * <code>foo</code> and the <code>Name</code> itself is <code>foo:bar</code>.
 * The namespace is defined to belonging to the {@link #getNamespaceURI URI} at
 * <code>http://example.net/foospace</code>.  Strictly speaking, a real
 * namespace can be defined by its <code>URI</code> alone.  This interface
 * may (should?) have been called <code>NameNamespace</code>.
 *
 * @author Elias Ross
 * @version 1.0
 * @see UriMap
 */
public interface Namespace
{
	/**
	 * Returns the namespace URI, or <code>null</code> if this
	 * name belongs to the default namespace.
	 */
	String getNamespaceURI();

	/**
	 * Returns the prefix in use, or <code>null</code> if this
	 * name belongs to the default namespace.
	 */
	String getPrefix();

	/**
	 * Returns the local name, the name without its prefix.  Returns
	 * <code>null</code> if this name belongs to the default namespace.
	 */
	String getLocalName();

	/**
	 * Returns the full name, including the colon.
	 */
	String getName();
}
