/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.model.Run;
import com.google.caliper.runner.ResultProcessor;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

final class OutputFileDumper
implements ResultProcessor {
    private String outputFileOrDir;
    private String benchmarkName;
    private static final String FILE_NAME_DATE_FORMAT = "yyyy-MM-dd'T'HH-mm-ssZ";

    OutputFileDumper(String outputFileOrDir, String benchmarkName) {
        this.outputFileOrDir = outputFileOrDir;
        this.benchmarkName = benchmarkName;
    }

    @Override
    public void handleResults(Run results) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Files.write((CharSequence)gson.toJson((Object)results), (File)this.getOutputFile(), (Charset)Charsets.UTF_8);
        }
        catch (IOException ioe) {
            System.err.println("ERROR: Unable to write json output: " + ioe.getMessage());
        }
    }

    private File getOutputFile() {
        if (this.outputFileOrDir == null) {
            File dir = new File("caliper-results");
            dir.mkdirs();
            return new File(dir, this.createFileName(this.benchmarkName));
        }
        File fileOrDir = new File(this.outputFileOrDir);
        if (fileOrDir.exists() && fileOrDir.isDirectory()) {
            return new File(fileOrDir, this.createFileName(this.benchmarkName));
        }
        File parent = fileOrDir.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        return fileOrDir;
    }

    private String createFileName(String benchmarkName) {
        String timestamp = this.createTimestamp();
        return String.format("%s.%s.json", benchmarkName, timestamp);
    }

    private String createTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(FILE_NAME_DATE_FORMAT, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat.setLenient(true);
        return dateFormat.format(new Date());
    }
}

