/**************************************************************************\
 ibtk (Insomnia's Basic ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef IWINDOW_H
#define IWINDOW_H

#define IBTK_DEFAULT     0
#define IBTK_STEP        1

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include <sys/time.h>

#include "idodad.h"
#include "pclaim.h"

class IWindow  {
private:
  Display *Disp;
  Window Win, Root, Icon;
  Pixmap WinBuf;
  GC gc, cgc;
  Atom closeatom;
  XFontStruct *fs;
  unsigned int wbgcol, bgcol, lbgcol, dbgcol, fgcol, pcol, scol;
  int mapped;
  PositionClaim *claim, *lclaim;
  IDoDad *pdd, *fdd;
  int quit;
  int DispFD;
  struct timeval *DispatchTime;
  void (*DispatchHook)(void);
  void RevRedraw(PositionClaim *it);
  void RevRedraw(PositionClaim *it, int x, int y, int xs, int ys);
  void Dispatch(XEvent ev);
  void Init(char *name, int xs, int ys, int xpos, int ypos, char *bg,
            Window* iwin, int xsi, int ysi);
  void LoadConfig();
  IWindow *parent;
  void (*activitycallback)(IWindow *);
  void (*exposecallback)(IWindow *);
  void (*resizecallback)(IWindow *, int, int);
  void (*repositioncallback)(IWindow *, int, int);
  void (*unhandledcallback)(IWindow *, XEvent *);
  void (*clickcallback)(IWindow *, int, int, int);
  void (*dblclickcallback)(IWindow *, int, int, int);
  void (*dragcallback)(IWindow *, int, int, int);
  void (*releasecallback)(IWindow *, int, int, int);
  void (*keymappingcallback)(IWindow *, XEvent *);
  int xsize, ysize, xpos, ypos, depth;
  int bufxs, bufys;
  int useicon, appearance;
  int xsizei, ysizei, xposi, yposi;
  Time clicktime;
  unsigned int doubleclicktime;

public:
  ~IWindow();
  unsigned int greencol, yellowcol, redcol;
  IWindow(char *bg = NULL);
  IWindow(int xs, int ys, char *bg = NULL);
  IWindow(int xs, int ys, int xpos, int ypos, char *bg = NULL);
  IWindow(char *name, char *bg = NULL,
          Window *iwin = NULL, int xsi = 96, int ysi = 72);
  IWindow(char *name, int xs, int ys, char *bg = NULL);
  IWindow(char *name, int xs, int ys, int xpos, int ypos, char *bg = NULL);
  void SetTitle(char *tit);
  Window GetWindow()  { return Win; };
  Window GetWindowBuffer()  { return WinBuf; };
  Window GetRootWindow()  { return Root; };
  Display *GetDisplay()  { return Disp; };
  GC GetGC()  { return gc; };
  GC GetClipGC()  { return cgc; };
  void RebuildClip();
  XFontStruct *GetFontStruct() { return fs; };
  Font GetFont() { return fs->fid; };
  void RegisterHook(void (*hookfn)(), struct timeval *waittime);
  void DispatchEvents();
  void DispatchCurrentEvents();
  void DispatchAutomaticEvents();
  int HasQuit() { return quit; };
  unsigned int GetSelectColor()  { return scol; };
  unsigned int GetPaperColor()  { return pcol; };
  unsigned int GetFGColor()  { return fgcol; };
  unsigned int GetWinBGColor()  { return wbgcol; };
  unsigned int GetBGColor()  { return bgcol; };
  unsigned int GetLBGColor()  { return lbgcol; };
  unsigned int GetDBGColor()  { return dbgcol; };
  void AddClaim(IDoDad *it, int x1, int y1, int x2, int y2);
  void RemoveClaim(IDoDad *it);
  void TakeFocus(IDoDad *it);
  IDoDad *GetFocus() { return fdd; };
  IDoDad *GetClaim(int x, int y);
  void Close();
  unsigned int GetRGBColor(int r, int g, int b);
  void Redraw();
  void Redraw(int, int, int, int);
  void Rebuild();
  void Rebuild(int, int, int, int);
  void SetParent(IWindow *p) { parent = p; };
  void SetActivityCallback(void (*cb)(IWindow *));
  void SetExposeCallback(void (*cb)(IWindow *));
  void SetResizeCallback(void (*cb)(IWindow *, int, int));
  void SetRepositionCallback(void (*cb)(IWindow *, int, int));
  void SetUnhandledCallback(void (*cb)(IWindow *, XEvent *));
  void SetClickCallback(void (*cb)(IWindow *, int, int, int));
  void SetDblClickCallback(void (*cb)(IWindow *, int, int, int));
  void SetDragCallback(void (*cb)(IWindow *, int, int, int));
  void SetReleaseCallback(void (*cb)(IWindow *, int, int, int));
  void SetKeyMappingCallback(void (*cb)(IWindow *, XEvent *));
  void Resize(int, int);
  void SetBufSize(int, int);
  void Map(int, int);
  void Map();
  void Clear();
  void Activity() { if(activitycallback) (*activitycallback)(this); };
  int XPos() { return (mapped) ? xpos : xposi; };
  int YPos() { return (mapped) ? ypos : yposi; };
  int XSize() { return (mapped) ? xsize : xsizei; };
  int YSize() { return (mapped) ? ysize : ysizei; };
  int XDeskSize();
  int YDeskSize();
  int Depth() { return depth; };
  void EnableIcon() { if(Icon) useicon=1; };
  void DisableIcon() { useicon=0; };
  int Appearance() { return appearance; };
  };

#endif
