/* Written by Geoff Oakham.  No license--this file is in public domain. */
/* $Id: simple.c,v 1.4 2004/11/24 18:14:30 oakhamg Exp $ */

static char const rcsid[] = "$Id: simple.c,v 1.4 2004/11/24 18:14:30 oakhamg Exp $";

#include <stdio.h>
#include <string.h>
#include <usb.h>

#include <limits.h>

#include "ifp.h"

/* Sample program that uses the ifp library.  Here's some sample output:

Detected: model IFP-599T, firmware 1.32, battery =[####], delta 1.8.6.22
       0 d VOICE
       0 d RECORD
 1988608 f iRiver, Catch the digital flow!.mp3
       0 d bnl
       0 d debug
 4493047 f Muppets - It's not easy.mp3
       0 d moby
       0 d quality_test
       0 d overtures
 5010116 f 04 Whispering wind.ogg
 3038563 f 06- Toy Box -Toyride2001- Dumm-Diggy-Dumm.mp3
 3006380 f rstar.mp3
 3985516 f askatchewan Pirate.mp3
 9790693 f Crazy.ogg
 ... [output clipped]

 *
 */

int simple_dump_dir(void * context, int type, const char * name, int filesize) {
    printf("%8d %c %s\n", filesize, type == 2 ? 'd' : 'f', name);

    return 0;
}

int do_something(struct ifp_device * dev) {
	int i = 0;
	char buf[255];

	i = ifp_device_info(dev, buf, sizeof(buf));
	if (i) {
		printf("device info failed, i=%d.\n", i);
		return i;
	}
	printf("Detected: %s\n", buf);

	i = ifp_list_dirs(dev, "\\", simple_dump_dir, NULL);
	if (i) {
		printf("list dirs failed, i=%d.\n", i);
		return i;
	}

	return i;
}

int main(int argc, char **argv)
{
	struct usb_device *dev = NULL;
	usb_dev_handle *dh;
	struct ifp_device ifpdev;
	int i=0, e=0;
	    
	usb_init();

	dh = ifp_find_device();
	if (dh == NULL) {
		fprintf(stderr, "A suitable iRiver iFP device couldn't be found; "
		    "perhaps it's unplugged or turned off.\n");
		goto out_0;
	}

	dev = usb_device(dh);
	/* "must be called" written in the libusb documentation */
	if (usb_claim_interface(dh, dev->config->interface->altsetting->
		bInterfaceNumber))
	{
		fprintf(stderr, "Device is busy.  (I was unable to claim its"
			" interface.)\n");
		goto out_1;
	}

	i = ifp_init(&ifpdev, dh);
	if (i) {
		printf("Device isn't responding.. try jiggling the handle. "
			"(error %d)\n",i);
		goto out_2;
	}
    
	i = do_something(&ifpdev);
	if (i) {
		printf("list dirs failed, i=%d.\n", i);
		goto out_3;
	}

out_3:
	e = ifp_finalize(&ifpdev);
	if (e) { fprintf(stderr, "warning: finalize failed, i=%d\n",e); i=i?i:e; }

out_2:
	usb_release_interface(dh,
		dev->config->interface->altsetting->bInterfaceNumber);
out_1:

	e = ifp_release_device(dh);
        if (e) { fprintf(stderr, "warning: release_device failed, i=%d\n",e); i=i?i:e; }
out_0:
	return i ? 1 : 0;
}

