/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.DNSName;
import sun.security.x509.EDIPartyName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralSubtree;
import sun.security.x509.IPAddressName;
import sun.security.x509.OIDName;
import sun.security.x509.OtherName;
import sun.security.x509.RFC822Name;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;

public class GeneralSubtrees
implements Cloneable {
    private final List trees;
    private static final int NAME_DIFF_TYPE = -1;
    private static final int NAME_MATCH = 0;
    private static final int NAME_NARROWS = 1;
    private static final int NAME_WIDENS = 2;
    private static final int NAME_SAME_TYPE = 3;

    public GeneralSubtrees() {
        this.trees = new ArrayList();
    }

    private GeneralSubtrees(GeneralSubtrees generalSubtrees) {
        ArrayList arrayList = (ArrayList)generalSubtrees.trees;
        this.trees = (List)arrayList.clone();
    }

    public GeneralSubtrees(DerValue derValue) throws IOException {
        this();
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding of GeneralSubtrees.");
        }
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            GeneralSubtree generalSubtree = new GeneralSubtree(derValue2);
            this.add(generalSubtree);
        }
    }

    public GeneralSubtree get(int n) {
        return (GeneralSubtree)this.trees.get(n);
    }

    public void remove(int n) {
        this.trees.remove(n);
    }

    public void add(GeneralSubtree generalSubtree) {
        if (generalSubtree == null) {
            throw new NullPointerException();
        }
        this.trees.add(generalSubtree);
    }

    public boolean contains(GeneralSubtree generalSubtree) {
        if (generalSubtree == null) {
            throw new NullPointerException();
        }
        return this.trees.contains(generalSubtree);
    }

    public int size() {
        return this.trees.size();
    }

    public Iterator iterator() {
        return this.trees.iterator();
    }

    public Object clone() {
        return new GeneralSubtrees(this);
    }

    public String toString() {
        String string = "   GeneralSubtrees:\n" + this.trees.toString() + "\n";
        return string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.get(i).encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeneralSubtrees)) {
            return false;
        }
        GeneralSubtrees generalSubtrees = (GeneralSubtrees)object;
        return ((Object)this.trees).equals(generalSubtrees.trees);
    }

    public int hashCode() {
        return ((Object)this.trees).hashCode();
    }

    private GeneralNameInterface getGeneralNameInterface(int n) {
        return GeneralSubtrees.getGeneralNameInterface(this.get(n));
    }

    private static GeneralNameInterface getGeneralNameInterface(GeneralSubtree generalSubtree) {
        GeneralName generalName = generalSubtree.getName();
        GeneralNameInterface generalNameInterface = generalName.getName();
        return generalNameInterface;
    }

    private void minimize() {
        for (int i = 0; i < this.size(); ++i) {
            boolean bl;
            block9: {
                GeneralNameInterface generalNameInterface = this.getGeneralNameInterface(i);
                bl = false;
                block8: for (int j = i + 1; j < this.size(); ++j) {
                    GeneralNameInterface generalNameInterface2 = this.getGeneralNameInterface(j);
                    switch (generalNameInterface.constrains(generalNameInterface2)) {
                        case -1: {
                            continue block8;
                        }
                        case 0: {
                            bl = true;
                            break block9;
                        }
                        case 1: {
                            this.remove(j);
                            --j;
                            continue block8;
                        }
                        case 2: {
                            bl = true;
                            break block9;
                        }
                        case 3: {
                            continue block8;
                        }
                    }
                }
            }
            if (!bl) continue;
            this.remove(i);
            --i;
        }
    }

    private GeneralSubtree createWidestSubtree(GeneralNameInterface generalNameInterface) {
        try {
            GeneralName generalName;
            switch (generalNameInterface.getType()) {
                case 0: {
                    ObjectIdentifier objectIdentifier = ((OtherName)generalNameInterface).getOID();
                    generalName = new GeneralName(new OtherName(objectIdentifier, null));
                    break;
                }
                case 1: {
                    generalName = new GeneralName(new RFC822Name(""));
                    break;
                }
                case 2: {
                    generalName = new GeneralName(new DNSName(""));
                    break;
                }
                case 4: {
                    generalName = new GeneralName(new X500Name(""));
                    break;
                }
                case 5: {
                    generalName = new GeneralName(new EDIPartyName(""));
                    break;
                }
                case 6: {
                    generalName = new GeneralName(new URIName(""));
                    break;
                }
                case 7: {
                    generalName = new GeneralName(new IPAddressName((byte[])null));
                    break;
                }
                case 8: {
                    generalName = new GeneralName(new OIDName(new ObjectIdentifier((int[])null)));
                    break;
                }
                default: {
                    throw new IOException("Unsupported GeneralNameInterface type: " + generalNameInterface.getType());
                }
            }
            return new GeneralSubtree(generalName, 0, -1);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected error: " + iOException, iOException);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public GeneralSubtrees intersect(GeneralSubtrees generalSubtrees) {
        Object object;
        int n;
        boolean bl;
        Object object2;
        if (generalSubtrees == null) {
            throw new NullPointerException("other GeneralSubtrees must not be null");
        }
        GeneralSubtrees generalSubtrees2 = new GeneralSubtrees();
        GeneralSubtrees generalSubtrees3 = null;
        if (this.size() == 0) {
            this.union(generalSubtrees);
            return null;
        }
        this.minimize();
        generalSubtrees.minimize();
        int n2 = 0;
        block9: while (true) {
            GeneralNameInterface generalNameInterface;
            if (n2 >= this.size()) {
                if (generalSubtrees2.size() > 0) {
                    this.union(generalSubtrees2);
                }
                break;
            }
            object2 = this.getGeneralNameInterface(n2);
            boolean bl2 = false;
            bl = false;
            block10: for (n = 0; n < generalSubtrees.size(); ++n) {
                object = generalSubtrees.get(n);
                generalNameInterface = GeneralSubtrees.getGeneralNameInterface((GeneralSubtree)object);
                switch (object2.constrains(generalNameInterface)) {
                    case 1: {
                        this.remove(n2);
                        --n2;
                        generalSubtrees2.add((GeneralSubtree)object);
                        bl = false;
                        break block10;
                    }
                    case 3: {
                        bl = true;
                        break;
                    }
                    case 0: 
                    case 2: {
                        bl = false;
                        break block10;
                    }
                }
            }
            boolean bl3 = true;
            while (true) {
                int n3;
                block27: {
                    block28: {
                        block25: {
                            block26: {
                                block24: {
                                    if (!bl3 || (bl3 = false)) break block24;
                                    if (!bl) break block25;
                                    n = 0;
                                    n3 = 0;
                                }
                                if (n3 >= this.size()) break block26;
                                generalNameInterface = this.getGeneralNameInterface(n3);
                                if (generalNameInterface.getType() != object2.getType()) break block27;
                                break block28;
                            }
                            if (n == 0) {
                                GeneralSubtree generalSubtree;
                                if (generalSubtrees3 == null) {
                                    generalSubtrees3 = new GeneralSubtrees();
                                }
                                if (!generalSubtrees3.contains(generalSubtree = this.createWidestSubtree((GeneralNameInterface)object2))) {
                                    generalSubtrees3.add(generalSubtree);
                                }
                            }
                            this.remove(n2);
                            --n2;
                        }
                        ++n2;
                        continue block9;
                    }
                    for (int i = 0; i < generalSubtrees.size(); ++i) {
                        GeneralNameInterface generalNameInterface2 = generalSubtrees.getGeneralNameInterface(i);
                        int n4 = generalNameInterface.constrains(generalNameInterface2);
                        if (n4 != 0 && n4 != 2 && n4 != 1) continue;
                        n = 1;
                        break;
                    }
                }
                ++n3;
            }
            break;
        }
        n2 = 0;
        while (n2 < generalSubtrees.size()) {
            object2 = generalSubtrees.get(n2);
            GeneralNameInterface generalNameInterface = GeneralSubtrees.getGeneralNameInterface((GeneralSubtree)object2);
            bl = false;
            block14: for (n = 0; n < this.size(); ++n) {
                object = this.getGeneralNameInterface(n);
                switch (object.constrains(generalNameInterface)) {
                    case -1: {
                        bl = true;
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        bl = false;
                        break block14;
                    }
                }
            }
            if (bl) {
                this.add((GeneralSubtree)object2);
            }
            ++n2;
        }
        return generalSubtrees3;
    }

    public void union(GeneralSubtrees generalSubtrees) {
        if (generalSubtrees != null) {
            int n = generalSubtrees.size();
            for (int i = 0; i < n; ++i) {
                this.add(generalSubtrees.get(i));
            }
            this.minimize();
        }
    }

    public void reduce(GeneralSubtrees generalSubtrees) {
        if (generalSubtrees == null) {
            return;
        }
        int n = generalSubtrees.size();
        for (int i = 0; i < n; ++i) {
            GeneralNameInterface generalNameInterface = generalSubtrees.getGeneralNameInterface(i);
            block7: for (int j = 0; j < this.size(); ++j) {
                GeneralNameInterface generalNameInterface2 = this.getGeneralNameInterface(j);
                switch (generalNameInterface.constrains(generalNameInterface2)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        this.remove(j);
                        --j;
                        continue block7;
                    }
                    case 1: {
                        this.remove(j);
                        --j;
                        continue block7;
                    }
                    case 2: {
                        continue block7;
                    }
                }
            }
        }
    }
}

