/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.docker.ui.node;

import java.util.List;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.docker.api.ExposedPort;
import org.netbeans.modules.docker.api.PortMapping;
import org.openide.util.NbBundle;

/**
 *
 * @author dsergeyev
 */
public class ViewPortBindingsPanel extends javax.swing.JPanel {

    /**
     * Creates new form ViewPortBindingsPanel
     */
    public ViewPortBindingsPanel(List<PortMapping> bindings) {
        initComponents();
        setModel(bindings);
    }
    
    @NbBundle.Messages({
        "LBL_Type=Type",
        "LBL_Port=Port",
        "LBL_HostPort=Host Port",
        "LBL_HostAddress=Host Address"
    })
    private void setModel(List<PortMapping> mappings) {
        int rowNumber = mappings.size();
        mappingsTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [rowNumber][],
            new String [] {
                Bundle.LBL_Type(), Bundle.LBL_Port(), Bundle.LBL_HostPort(), Bundle.LBL_HostAddress()
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.Integer.class, java.lang.Integer.class, java.lang.String.class
            };

            @Override
            public Class getColumnClass(int columnIndex) {
                return types[columnIndex];
            }
            
            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        DefaultTableCellRenderer integerRenderer = (DefaultTableCellRenderer) mappingsTable.getDefaultRenderer(Integer.class);
        integerRenderer.setHorizontalAlignment(JLabel.CENTER);
        DefaultTableCellRenderer stringRenderer = (DefaultTableCellRenderer) mappingsTable.getDefaultRenderer(String.class);
        stringRenderer.setHorizontalAlignment(JLabel.CENTER);
        int row = 0;
        TableModel model = mappingsTable.getModel();
        for (PortMapping mapping : mappings) {
            String type = mapping.getType().equals(ExposedPort.Type.TCP) ? "tcp" : "udp";
            model.setValueAt(type, row, 0);
            model.setValueAt(mapping.getPort(), row, 1);
            model.setValueAt(mapping.getHostPort(), row, 2);
            model.setValueAt(mapping.getHostAddress(), row, 3);
            row++;
        }
        mappingsTable.setRowSelectionAllowed(false);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        mappingsTable = new javax.swing.JTable();

        jScrollPane1.setViewportView(mappingsTable);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 171, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable mappingsTable;
    // End of variables declaration//GEN-END:variables
}
