/* hashKey.h
 */
#ifndef OSL_HASH_KEY_H
#define OSL_HASH_KEY_H

#include "osl/config.h"
#ifdef OSL_LONG_HASH_KEY
#  include "osl/hash/boardKey.h"
#else
#  include "osl/hash/boardKey128.h"
#endif
#include "osl/piece.h"
#include "osl/move.h"
#include "osl/pieceStand.h"
#include "osl/state/simpleState.h"
#include "osl/misc/carray.h"

namespace osl
{
  namespace hash
  {
#ifdef OSL_LONG_HASH_KEY
#  if OSL_WORDSIZE == 64
    typedef HashKey64 HashKeyBase;
    typedef BoardKey64 BoardKey;
#  elif OSL_WORDSIZE == 32
    typedef HashKey32 HashKeyBase;
    typedef BoardKey32 BoardKey;
#  endif
#else
    typedef HashKey128 HashKeyBase;
    typedef BoardKey96 BoardKey;
#endif
    class HashKey : public HashKeyBase
    {
    public:
      HashKey() :HashKeyBase(){}
      HashKey(const SimpleState&);
#ifndef OSL_LONG_HASH_KEY
      HashKey(uint64_t h0, uint32_t h1, uint32_t s)
	: HashKeyBase(h0, h1, s)
      {
      }
#endif
      const HashKey newHashWithMove(Move move) const;
      const HashKey newMakeMove(Move) const;
      const HashKey newUnmakeMove(Move) const;

      void dumpContents(std::ostream& os) const;
      void dumpContentsCerr() const;
      static const HashKey readFromDump(const std::string&);
      static const HashKey readFromDump(std::istream&);
    };
    std::ostream& operator<<(std::ostream& os,const HashKey& h);

    class HashGenTable
    {
#ifdef OSL_LONG_HASH_KEY
      CArray2d<HashKey,Square::SIZE,PTYPEO_SIZE> key;
#else
      static const CArray2d<HashKey128Layout,Square::SIZE,PTYPEO_SIZE> key;
#endif
    public:
      HashGenTable();
#ifdef OSL_LONG_HASH_KEY
      void addHashKey(HashKey& hk,Square sq,PtypeO ptypeo) const{
	assert(sq.isValid() && isValidPtypeO(ptypeo));
	hk+=key[sq.index()][ptypeo-PTYPEO_MIN];
      }
      void subHashKey(HashKey& hk,Square sq,PtypeO ptypeo) const{
	assert(sq.isValid() && isValidPtypeO(ptypeo));
	hk-=key[sq.index()][ptypeo-PTYPEO_MIN];
#else
      static void addHashKey(HashKey& hk,Square sq,PtypeO ptypeo) {
	assert(sq.isValid() && isValidPtypeO(ptypeo));
	hk += HashKey128(key[sq.index()][ptypeo-PTYPEO_MIN]);
      }
      static void subHashKey(HashKey& hk,Square sq,PtypeO ptypeo) {
	assert(sq.isValid() && isValidPtypeO(ptypeo));
	hk -= HashKey128(key[sq.index()][ptypeo-PTYPEO_MIN]);
#endif
      }
    };
    extern const HashGenTable Hash_Gen_Table;

  } // namespace hash
  using hash::HashKey;
  using hash::BoardKey;

  namespace stl
  {
    template <typename T> struct hash;
    template <>
    struct hash<osl::hash::HashKey>{
      unsigned long operator()(const HashKey& h) const{
	return h.signature();
      }
    };
    template<>
    struct hash<osl::hash::BoardKey>
    {
      unsigned long operator()(const BoardKey& h) const
      {
	return h.signature();
      }
    };
  } // namespace stl
#ifdef USE_TBB_HASH
  struct TBBHashCompare
  {
    size_t hash(HashKey const& key) const {
      return (size_t)(key.signature());
    }
    bool equal(HashKey const& key1, HashKey const& key2) const {
      return key1==key2;
    }
  };
  struct TBBSignatureCompare
  {
    size_t hash(hash::BoardKey const& key) const {
      return (size_t)key.signature();
    }
    bool equal(hash::BoardKey const& key1, hash::BoardKey const& key2) const {
      return key1==key2;
    }
  };
#endif
} // namespace osl

#endif /* OSL_HASH_KEY_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
