#include "osl/search/bigramKillerMove.h"
#include "osl/record/csaString.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::search;

class BigramKillerMoveTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(BigramKillerMoveTest);
  CPPUNIT_TEST(testAdust);
  CPPUNIT_TEST_SUITE_END();
public:
  void testAdust();
};

CPPUNIT_TEST_SUITE_REGISTRATION(BigramKillerMoveTest);

void BigramKillerMoveTest::testAdust()
{
  BigramKillerMove bigrams;
  const Move m68b(Square(2,8),Square(6,8),ROOK,PTYPE_EMPTY,false,BLACK);
  const Move m26w(Square(2,3),Square(2,6),ROOK,GOLD,false,WHITE);
  // 先手の飛車が動いたら，後手が26の金を取る
  bigrams.setMove(m68b, m26w);
  CPPUNIT_ASSERT_EQUAL(m26w, bigrams[m68b][0]);

  MoveVector moves;
  NumEffectState state(CsaString(
			 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
			 "P2 *  *  *  *  *  *  * -KA * \n"
			 "P3-FU-FU-FU-FU-FU-FU-FU-HI-FU\n"
			 "P4 *  *  *  *  *  *  *  * -TO\n"
			 "P5 *  *  *  *  *  *  *  *  * \n"
			 "P6 *  *  *  *  *  *  * +KI * \n"
			 "P7+FU+FU+FU+FU+FU+FU+FU * +FU\n"
			 "P8 * +KA * +HI *  *  *  *  * \n"
			 "P9+KY+KE+GI+KI+OU * +GI+KE+KY\n"
			 "P+00FU\n"
			 "-\n").getInitialState());
  bigrams.getMove(state, m68b, moves);
  CPPUNIT_ASSERT_EQUAL((size_t)1, moves.size());
  CPPUNIT_ASSERT_EQUAL(m26w, *moves.begin());

  moves.clear();
  
  // 後手の飛車に歩を叩いてもkiller move が対応
  NumEffectState state2(CsaString(
			 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
			 "P2 *  *  *  *  *  *  * -KA * \n"
			 "P3-FU-FU-FU-FU-FU-FU-FU * -FU\n"
			 "P4 *  *  *  *  *  *  * -HI-TO\n"
			 "P5 *  *  *  *  *  *  *  *  * \n"
			 "P6 *  *  *  *  *  *  * +KI * \n"
			 "P7+FU+FU+FU+FU+FU+FU+FU * +FU\n"
			 "P8 * +KA * +HI *  *  *  *  * \n"
			 "P9+KY+KE+GI+KI+OU * +GI+KE+KY\n"
			 "P-00FU\n"
			 "-\n").getInitialState());
  bigrams.getMove(state2, m68b, moves);
  CPPUNIT_ASSERT_EQUAL((size_t)1, moves.size());
  const Move m26w_from24(Square(2,4),Square(2,6),ROOK,GOLD,false,WHITE);
  CPPUNIT_ASSERT_EQUAL(m26w_from24, *moves.begin());

  moves.clear();
  
  // 後手の飛車が辺なところにいれば無視
  NumEffectState state3(CsaString(
			 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
			 "P2 *  *  *  *  *  *  * -KA * \n"
			 "P3-FU-FU-FU-FU-FU-FU-FU * -FU\n"
			 "P4 *  *  * -HI *  *  *  * -TO\n"
			 "P5 *  *  *  *  *  *  *  *  * \n"
			 "P6 *  *  *  *  *  *  * +KI * \n"
			 "P7+FU+FU+FU+FU+FU+FU+FU * +FU\n"
			 "P8 * +KA * +HI *  *  *  *  * \n"
			 "P9+KY+KE+GI+KI+OU * +GI+KE+KY\n"
			 "P-00FU\n"
			 "-\n").getInitialState());
  bigrams.getMove(state3, m68b, moves);
  CPPUNIT_ASSERT(moves.empty());
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
