//
// $Id: FrequencyDataTestData.cpp 1195 2009-08-14 22:12:04Z chambm $
//
//
// Original author: Darren Kessner <darren@proteowizard.org>
//
// Copyright 2007 Spielberg Family Center for Applied Proteomics
//   Cedars Sinai Medical Center, Los Angeles, California  90048
//
// Licensed under the Apache License, Version 2.0 (the "License"); 
// you may not use this file except in compliance with the License. 
// You may obtain a copy of the License at 
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software 
// distributed under the License is distributed on an "AS IS" BASIS, 
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
// See the License for the specific language governing permissions and 
// limitations under the License.
//


#include "FrequencyDataTestData.hpp"


RawMassDatum sampleMassData_[] = 
{
    {676.3781485, 6908.006348},
    {676.3753787, 8325.94043},
    {676.372609, 8524.166016},
    {676.3698393, 8201.929688},
    {676.3670696, 6866.17041},
    {676.3642999, 4521.778809},
    {676.3615303, 2167.997314},
    {676.3587607, 788.0887451},
    {676.3559911, 202.7794037},
    {676.3532215, 2121.27002},
    {676.350452, 5040.513184},
    {676.3476825, 7682.216797},
    {676.344913, 8698.469727},
    {676.3421435, 7576.531738},
    {676.339374, 5292.755859},
    {676.3366046, 3796.708984},
    {676.3338352, 3446.091309},
    {676.3310658, 2804.714355},
    {676.3282964, 1735.031738},
    {676.3255271, 1361.59021},
    {676.3227578, 1742.776855},
    {676.3199885, 1854.268677},
    {676.3172192, 1694.57959},
    {676.31445, 1452.604736},
    {676.3116807, 1474.278198},
    {676.3089115, 2217.81958},
    {676.3061423, 2846.165039},
    {676.3033732, 2625.031982},
    {676.300604, 1761.301636},
    {676.2978349, 967.4257202},
    {676.2950658, 611.4064941},
    {676.2922968, 1074.055664},
    {676.2895277, 2059.4021},
    {676.2867587, 3028.92749},
    {676.2839897, 3732.032959},
    {676.2812207, 4093.032227},
    {676.2784518, 4153.280273},
    {676.2756828, 3885.000732},
    {676.2729139, 3354.821045},
    {676.270145, 3042.557373},
    {676.2673762, 3064.000732},
    {676.2646073, 2794.801758},
    {676.2618385, 2022.390991},
    {676.2590697, 1221.84021},
    {676.2563009, 923.5252075},
    {676.2535322, 789.9469604},
    {676.2507635, 788.1323853},
    {676.2479948, 969.4432373},
    {676.2452261, 853.1880493},
    {676.2424574, 931.2061768},
    {676.2396888, 1494.341675},
    {676.2369202, 1783.229126},
    {676.2341516, 1529.899658},
    {676.231383, 920.2738037},
    {676.2286144, 525.0412598},
    {676.2258459, 916.4795532},
    {676.2230774, 1917.24292},
    {676.2203089, 2726.755615},
    {676.2175405, 2889.875244},
    {676.214772, 2522.675293},
    {676.2120036, 1908.580811},
    {676.2092352, 1410.317261},
    {676.2064669, 1563.266602},
    {676.2036985, 1828.568726},
    {676.2009302, 1467.953003},
    {676.1981619, 813.2462769},
    {676.1953936, 1585.572754},
    {676.1926254, 2824.083008},
    {676.1898572, 3436.904541},
    {676.187089, 2888.573975},
    {676.1843208, 1380.599121},
    {676.1815526, 296.726532},
    {676.1787845, 1166.725708},
    {676.1760164, 1529.677246},
    {676.1732483, 2034.930298},
    {676.1704802, 2749.771729},
    {676.1677121, 3121.559082},
    {676.1649441, 2718.746582},
    {676.1621761, 1702.927734},
    {676.1594081, 850.8549194},
    {676.1566402, 533.7766724},
    {676.1538722, 597.4779663},
    {676.1511043, 1237.397095},
    {676.1483364, 1337.354736},
    {676.1455686, 728.7314453},
    {676.1428007, 684.5762939},
    {676.1400329, 1207.466187},
    {676.1372651, 1490.667603},
    {676.1344973, 2079.553955},
    {676.1317296, 3254.888184},
    {676.1289618, 4364.762695},
    {676.1261941, 4582.788086},
    {676.1234264, 3705.047363},
    {676.1206588, 2311.991455},
    {676.1178911, 1283.987061},
    {676.1151235, 1339.348877},
    {676.1123559, 1981.695557},
    {676.1095883, 2285.52832},
    {676.1068208, 2000.625366},
    {676.1040533, 1632.976196},
    {676.1012858, 1475.346436},
    {676.0985183, 1122.883545},
    {676.0957508, 608.8710938},
    {676.0929834, 376.2699585},
    {676.090216, 1237.255249},
    {676.0874486, 1957.260986},
    {676.0846812, 1853.558716},
    {676.0819139, 960.873291},
    {676.0791465, 113.1415253},
    {676.0763792, 852.039917},
    {676.073612, 1297.272705},
    {676.0708447, 1622.380127},
    {676.0680775, 1711.844116},
    {676.0653103, 1617.052124},
    {676.0625431, 1538.884399},
    {676.0597759, 1375.489014},
    {676.0570088, 1480.498291},
    {676.0542416, 2391.318604},
    {676.0514745, 3169.324707},
    {676.0487075, 2879.539551},
    {676.0459404, 1577.928833},
    {676.0431734, 1717.146484},
    {676.0404064, 2861.393066},
    {676.0376394, 2838.506836},
    {676.0348724, 1808.579834},
    {676.0321055, 1075.865234},
    {676.0293386, 1946.747925},
    {676.0265717, 2594.352783},
    {676.0238048, 2304.370361},
    {676.021038, 1305.956177},
    {676.0182711, 484.813324},
    {676.0155043, 811.4865112},
    {676.0127376, 1125.836182},
    {676.0099708, 1722.810669},
    {676.0072041, 2699.725586},
    {676.0044374, 3589.418457},
    {676.0016707, 4057.317139},
    {675.998904, 4005.996338},
    {675.9961374, 3577.808105},
    {675.9933707, 3095.560303},
    {675.9906041, 2665.915527},
    {675.9878376, 2118.81665},
    {675.985071, 1600.550415},
    {675.9823045, 1646.337769},
    {675.979538, 1987.083984},
    {675.9767715, 2085.007324},
    {675.974005, 2007.703857},
    {675.9712386, 2000.571167},
    {675.9684722, 2088.513672},
    {675.9657058, 2105.298096},
    {675.9629394, 1957.5354},
    {675.960173, 1874.454346},
    {675.9574067, 2076.026855},
    {675.9546404, 2350.240723},
    {675.9518741, 2313.373291},
    {675.9491079, 1973.003662},
    {675.9463416, 1736.789795},
    {675.9435754, 1776.846558},
    {675.9408092, 1660.791504},
    {675.9380431, 1091.845093},
    {675.9352769, 1331.780396},
    {675.9325108, 2516.737793},
    {675.9297447, 3238.097656},
    {675.9269786, 3216.818848},
    {675.9242126, 2709.942871},
    {675.9214465, 2135.876465},
    {675.9186805, 1709.116821},
    {675.9159145, 1485.066528},
    {675.9131486, 1862.881958},
    {675.9103826, 2354.456787},
    {675.9076167, 2358.757813},
    {675.9048508, 1957.477905},
    {675.9020849, 1449.99292},
    {675.8993191, 1307.253662},
    {675.8965532, 2130.765869},
    {675.8937874, 3092.213623},
    {675.8910217, 3445.633545},
    {675.8882559, 1919.283813},
    {675.8854902, 3934.444092},
    {675.8827244, 15922.22363},
    {675.8799587, 31954.54102},
    {675.8771931, 42402.26953},
    {675.8744274, 38299.97266},
    {675.8716618, 21793.875},
    {675.8688962, 8429.955078},
    {675.8661306, 9877.270508},
    {675.8633651, 7313.313965},
    {675.8605995, 2986.85498},
    {675.857834, 1778.993164},
    {675.8550685, 990.4505005},
    {675.8523031, 954.7762451},
    {675.8495376, 1378.780884},
    {675.8467722, 1576.723389},
    {675.8440068, 1830.042358},
    {675.8412414, 2732.257813},
    {675.8384761, 2810.94165},
    {675.8357107, 1943.007568},
    {675.8329454, 1218.158203},
    {675.8301801, 1089.638672},
    {675.8274149, 1193.17981},
    {675.8246496, 1452.96582},
    {675.8218844, 1506.507568},
    {675.8191192, 1090.441284},
    {675.816354, 560.348938},
    {675.8135889, 1000.985657},
    {675.8108238, 1563.696289},
    {675.8080587, 1814.017456},
    {675.8052936, 1844.746094},
    {675.8025285, 1821.392944},
    {675.7997635, 1725.908569},
    {675.7969985, 1317.565063},
    {675.7942335, 650.6932373},
    {675.7914685, 1155.004883},
    {675.7887036, 2365.357666},
    {675.7859386, 3581.433594},
    {675.7831737, 4302.118164},
    {675.7804089, 3992.665039},
    {675.777644, 2944.106201},
    {675.7748792, 1963.202271},
    {675.7721144, 1315.855469},
    {675.7693496, 1071.823486},
    {675.7665848, 1158.229492},
    {675.7638201, 1166.97876},
    {675.7610553, 1438.192261},
    {675.7582906, 1837.428833},
    {675.755526, 1568.014893},
    {675.7527613, 1159.437744},
    {675.7499967, 1635.091797},
    {675.7472321, 2363.089111},
    {675.7444675, 3271.952637},
    {675.7417029, 3964.725586},
    {675.7389384, 3765.501953},
    {675.7361739, 2440.819824},
    {675.7334094, 468.3238525},
    {675.7306449, 1287.771362},
    {675.7278805, 2075.784912},
    {675.725116, 1721.250732},
    {675.7223516, 842.2559814},
    {675.7195873, 442.2115479},
    {675.7168229, 758.901123},
    {675.7140586, 1476.26709},
    {675.7112942, 1596.448608},
    {675.70853, 1163.667603},
    {675.7057657, 1968.845825},
    {675.7030014, 2925.639648},
    {675.7002372, 2589.946045},
    {675.697473, 1135.681885},
    {675.6947088, 467.8063965},
    {675.6919447, 897.4993896},
    {675.6891806, 722.1495361},
    {675.6864164, 1670.047852},
    {675.6836524, 2909.208496},
    {675.6808883, 3586.191895},
    {675.6781243, 3593.170654},
    {675.6753602, 3377.664307},
    {675.6725962, 3277.290283},
    {675.6698323, 3157.245117},
    {675.6670683, 2777.567871},
    {675.6643044, 2005.026855},
    {675.6615405, 987.5808105},
    {675.6587766, 1046.320923},
    {675.6560127, 1949.147339},
    {675.6532489, 2050.642578},
    {675.6504851, 1373.130737},
    {675.6477213, 1709.638306},
    {675.6449575, 2695.37207},
    {675.6421938, 3248.082031},
    {675.63943, 3513.311035},
    {675.6366663, 3500.711182},
    {675.6339027, 2896.30835},
    {675.631139, 1665.753662},
    {675.6283754, 452.9361877},
    {675.6256118, 796.1696777},
    {675.6228482, 1223.351807},
    {675.6200846, 1604.991577},
    {675.6173211, 2122.63501},
    {675.6145575, 2711.922607},
    {675.611794, 2711.219971},
    {675.6090306, 1550.381592},
    {675.6062671, 413.7042236},
    {675.6035037, 1796.509399},
    {675.6007403, 2526.391602},
    {675.5979769, 3281.082275},
    {675.5952135, 4194.502441},
    {675.5924502, 4731.30127},
    {675.5896869, 4669.61377},
    {675.5869236, 4068.651855},
    {675.5841603, 3134.30127},
    {675.581397, 2198.210205},
    {675.5786338, 1366.322388},
    {675.5758706, 1266.662476},
    {675.5731074, 2608.709961},
    {675.5703443, 3447.631348},
    {675.5675811, 2790.967041},
    {675.564818, 1202.448242},
    {675.5620549, 973.6413574},
    {675.5592918, 1328.671631},
    {675.5565288, 1301.22522},
    {675.5537658, 1369.235596},
    {675.5510028, 1283.686768},
    {675.5482398, 802.4091187},
    {675.5454768, 566.8187256},
    {675.5427139, 1150.43396},
    {675.539951, 1434.704834},
    {675.5371881, 1279.977661},
    {675.5344252, 1459.455933},
    {675.5316624, 2083.875},
    {675.5288996, 2524.698242},
    {675.5261368, 2696.900391},
    {675.523374, 2517.855713},
    {675.5206112, 1834.391724},
    {675.5178485, 1193.908691},
    {675.5150858, 1415.326416},
    {675.5123231, 1512.798462},
    {675.5095605, 1399.47998},
    {675.5067978, 1745.74353},
    {675.5040352, 2569.477539},
    {675.5012726, 3493.688721},
    {675.49851, 4068.449951},
    {675.4957475, 3748.615967},
    {675.492985, 2407.814453},
    {675.4902224, 1133.511597},
    {675.48746, 1517.33252},
    {675.4846975, 1968.585083},
    {675.4819351, 2102.836426},
    {675.4791727, 1821.713745},
    {675.4764103, 1533.25354},
    {675.4736479, 1882.138306},
    {675.4708855, 2475.824463},
    {675.4681232, 3034.681885},
    {675.4653609, 3480.579346},
    {675.4625986, 3259.221924},
    {675.4598364, 2144.9375},
    {675.4570742, 1008.018921},
    {675.4543119, 884.3475342},
    {675.4515498, 1110.799561},
    {675.4487876, 2046.993896},
    {675.4460254, 3076.978516},
    {675.4432633, 3223.894775},
    {675.4405012, 2316.321289},
    {675.4377392, 882.9598389},
    {675.4349771, 1145.708862},
    {675.4322151, 2190.633057},
    {675.4294531, 2623.345703},
    {675.4266911, 2535.549316},
    {675.4239291, 2074.421143},
    {675.4211672, 1650.293945},
    {675.4184053, 1295.122681},
    {675.4156434, 1031.173828},
    {675.4128815, 1500.885742},
    {675.4101196, 1255.178589},
    {675.4073578, 578.6574097},
    {675.404596, 1336.253174},
    {675.4018342, 2097.073975},
    {675.3990725, 3746.538574},
    {675.3963107, 4194.332031},
    {675.393549, 2988.430664},
    {675.3907873, 3087.300781},
    {675.3880257, 2596.1521},
    {675.385264, 3775.312256},
    {675.3825024, 28447.92188},
    {675.3797408, 73531.86719},
    {675.3769792, 116067.2422},
    {675.3742177, 125616.0391},
    {675.3714561, 96175.76563},
    {675.3686946, 54535.55078},
    {675.3659331, 29965.24414},
    {675.3631717, 16566.83203},
    {675.3604102, 4437.322266},
    {675.3576488, 1659.719238},
    {675.3548874, 1533.13855},
    {675.352126, 1267.342407},
    {675.3493647, 2085.241211},
    {675.3466033, 1133.588379},
    {675.343842, 537.0843506},
    {675.3410807, 1779.976563},
    {675.3383195, 2672.36792},
    {675.3355582, 2968.611816},
    {675.332797, 2848.094482},
    {675.3300358, 2259.621338},
    {675.3272747, 857.9924927},
    {675.3245135, 1707.045044},
    {675.3217524, 3239.967041},
    {675.3189913, 3750.874023},
    {675.3162302, 3781.594727},
    {675.3134691, 3866.938965},
    {675.3107081, 3775.527344},
    {675.3079471, 3376.024414},
    {675.3051861, 3132.815674},
    {675.3024251, 3222.619873},
    {675.2996642, 3054.687256},
    {675.2969033, 2256.658447},
    {675.2941424, 1332.876099},
    {675.2913815, 696.0239258},
    {675.2886206, 102.2348022},
    {675.2858598, 515.824646},
    {675.283099, 927.5770264},
    {675.2803382, 1086.114502},
    {675.2775774, 1103.259766},
    {675.2748167, 957.9190674},
    {675.272056, 876.5166626},
    {675.2692953, 828.4721069},
    {675.2665346, 618.425293},
    {675.2637739, 449.1333923},
    {675.2610133, 634.9506226},
    {675.2582527, 781.8742676},
    {675.2554921, 841.5576172},
    {675.2527315, 708.112854},
    {675.249971, 573.0977173},
    {675.2472105, 2094.992188},
    {675.24445, 3529.406738},
    {675.2416895, 4095.324951},
    {675.2389291, 3941.611328},
    {675.2361686, 3439.070313},
    {675.2334082, 2887.061523},
    {675.2306479, 2938.27002},
    {675.2278875, 3219.418945},
    {675.2251272, 2799.475586},
    {675.2223668, 1712.228882},
    {675.2196066, 436.2648315},
    {675.2168463, 709.4594727},
    {675.214086, 1284.770874},
    {675.2113258, 1452.133667},
    {675.2085656, 1447.319946},
    {675.2058054, 1155.190918},
    {675.2030453, 676.6842041},
    {675.2002851, 1319.274414},
    {675.197525, 1539.662842},
    {675.1947649, 441.7297363},
    {675.1920049, 1308.745605},
    {675.1892448, 2233.919189},
    {675.1864848, 1928.362549},
    {675.1837248, 1345.46521},
    {675.1809648, 1348.704346},
    {675.1782049, 1615.440552},
    {675.175445, 1973.635986},
    {675.1726851, 2237.685791},
    {675.1699252, 2274.393066},
    {675.1671653, 2072.248291},
    {675.1644055, 1635.945068},
    {675.1616456, 1060.800659},
    {675.1588858, 1033.893677},
    {675.1561261, 1527.780884},
    {675.1533663, 1791.394409},
    {675.1506066, 1715.693115},
    {675.1478469, 1337.357422},
    {675.1450872, 649.0513306},
    {675.1423276, 496.4603271},
    {675.1395679, 1248.529175},
    {675.1368083, 1527.616455},
    {675.1340487, 1370.387695},
    {675.1312891, 998.8162231},
    {675.1285296, 435.3985901},
    {675.1257701, 230.8042145},
    {675.1230106, 707.5698242},
    {675.1202511, 1081.781494},
    {675.1174916, 1640.292114},
    {675.1147322, 1980.82666},
    {675.1119728, 1458.744751},
    {675.1092134, 309.8274841},
    {675.106454, 1083.613647},
    {675.1036947, 1823.574829},
    {675.1009354, 2460.578125},
    {675.0981761, 3171.237305},
    {675.0954168, 3543.184082},
    {675.0926575, 3091.75415},
    {675.0898983, 1768.549805},
    {675.0871391, 479.8030396},
    {675.0843799, 1509.191895},
    {675.0816207, 2412.253418},
    {675.0788616, 2843.667236},
    {675.0761025, 2902.78833},
    {675.0733434, 3076.933838},
    {675.0705843, 3509.866455},
    {675.0678253, 3518.695068},
    {675.0650662, 2602.770264},
    {675.0623072, 1383.766479},
    {675.0595482, 2061.293945},
    {675.0567893, 3118.94751},
    {675.0540303, 2789.432373},
    {675.0512714, 1287.244263},
    {675.0485125, 772.3991699},
    {675.0457537, 1072.069458},
    {675.0429948, 1222.008911},
    {675.040236, 1972.176636},
    {675.0374772, 2607.870605},
    {675.0347184, 2814.466553},
    {675.0319597, 2059.471436},
    {675.0292009, 279.0333862},
    {675.0264422, 2341.075928},
    {675.0236835, 3089.121582},
    {675.0209248, 2221.579102},
    {675.0181662, 1234.88623},
    {675.0154076, 1092.3125},
    {675.012649, 1077.821655},
    {675.0098904, 693.5176392},
    {675.0071318, 387.7669983},
    {675.0043733, 396.8587036},
    {675.0016148, 723.9761963},
    {674.9988563, 1051.822754},
    {674.9960979, 1451.745972},
    {674.9933394, 1544.654663},
    {674.990581, 1023.750671},
    {674.9878226, 988.1325073},
    {674.9850642, 1813.221069},
    {674.9823059, 1866.448608},
    {674.9795475, 1719.127319},
    {674.9767892, 2296.617676},
    {674.974031, 2565.015869},
    {674.9712727, 2471.682617},
    {674.9685144, 2074.21582},
    {674.9657562, 1297.69397},
    {674.962998, 1021.461365},
    {674.9602399, 1058.229492},
    {674.9574817, 1480.281738},
    {674.9547236, 2522.341797},
    {674.9519655, 3447.219482},
    {674.9492074, 3564.958252},
    {674.9464493, 3133.591553},
    {674.9436913, 2793.955811},
    {674.9409333, 2867.115723},
    {674.9381753, 3673.512451},
    {674.9354173, 3851.987793},
    {674.9326594, 3122.599609},
    {674.9299015, 2867.618164},
    {674.9271436, 2717.000977},
    {674.9243857, 1845.55481},
    {674.9216278, 1571.527954},
    {674.91887, 1478.94165},
    {674.9161122, 711.4684448},
    {674.9133544, 1001.711731},
    {674.9105966, 2181.034668},
    {674.9078389, 2994.979248},
    {674.9050812, 2867.082764},
    {674.9023235, 1711.101074},
    {674.8995658, 1368.897949},
    {674.8968081, 1386.59668},
    {674.8940505, 1179.960938},
    {674.8912929, 2325.220215},
    {674.8885353, 3447.293945},
    {674.8857778, 2117.488281},
    {674.8830202, 16993.85156},
    {674.8802627, 98342.50781},
    {674.8775052, 243059.2656},
    {674.8747477, 377339.75},
    {674.8719903, 406940.5938},
    {674.8692329, 310894.9688},
    {674.8664754, 163930.0625},
    {674.8637181, 59964.55859},
    {674.8609607, 23675.35547},
    {674.8582034, 10168.18066},
    {674.8554461, 5918.285645},
    {674.8526888, 4999.23291},
    {674.8499315, 2973.062988},
    {674.8471742, 5029.340332},
    {674.844417, 4486.730957},
    {674.8416598, 1455.366821},
    {674.8389026, 540.0476685},
    {674.8361455, 1274.473267},
    {674.8333883, 729.531311},
    {674.8306312, 767.3745728},
    {674.8278741, 1743.136108},
    {674.8251171, 2233.568359},
    {674.82236, 1434.608398},
    {674.819603, 1815.842651},
    {674.816846, 2192.672852},
    {674.814089, 1710.250122},
    {674.8113321, 1630.876587},
    {674.8085751, 1435.52478},
    {674.8058182, 491.1956787},
    {674.8030613, 958.8461304},
    {674.8003045, 1384.473267},
    {674.7975476, 1982.851318},
    {674.7947908, 2229.187744},
    {674.792034, 1331.755981},
    {674.7892772, 345.0233154},
    {674.7865205, 1087.534302},
    {674.7837638, 261.9281006},
    {674.7810071, 1267.17041},
    {674.7782504, 2017.687012},
    {674.7754937, 2018.028809},
    {674.7727371, 1322.156616},
    {674.7699805, 18.05745125},
    {674.7672239, 1621.014893},
    {674.7644673, 2541.158203},
    {674.7617107, 2543.519775},
    {674.7589542, 2290.499756},
    {674.7561977, 2170.130859},
    {674.7534412, 2569.070068},
    {674.7506848, 2952.661377},
    {674.7479283, 2941.827148},
    {674.7451719, 2531.496826},
    {674.7424155, 2130.289795},
    {674.7396592, 1931.687378},
    {674.7369028, 1317.456299},
    {674.7341465, 882.3710938},
    {674.7313902, 1081.266235},
    {674.7286339, 630.9973145},
    {674.7258777, 907.1119995},
    {674.7231214, 1721.054688},
    {674.7203652, 2294.809082},
    {674.717609, 2346.437256},
    {674.7148529, 2374.180908},
    {674.7120967, 2361.521973},
    {674.7093406, 1956.668579},
    {674.7065845, 822.624939},
    {674.7038284, 667.9483032},
    {674.7010724, 1559.463745},
    {674.6983163, 1987.799438},
    {674.6955603, 2082.274658},
    {674.6928043, 1623.520142},
    {674.6900484, 775.8206787},
    {674.6872924, 485.0063782},
    {674.6845365, 265.7205811},
    {674.6817806, 843.782959},
    {674.6790247, 1239.684448},
    {674.6762689, 1748.32373},
    {674.6735131, 2102.503662},
    {674.6707573, 2254.043213},
    {674.6680015, 4115.34668},
    {674.6652457, 5938.141113},
    {674.66249, 5936.261719},
    {674.6597343, 4583.389648},
    {674.6569786, 3024.423584},
    {674.6542229, 1476.929932},
    {674.6514672, 514.477478},
    {674.6487116, 1263.25647},
    {674.645956, 1297.599121},
    {674.6432004, 972.5446167},
    {674.6404449, 868.1560669},
    {674.6376893, 1179.534424},
    {674.6349338, 1492.49292},
    {674.6321783, 1636.060303},
    {674.6294229, 1489.988525},
    {674.6266674, 1321.480103},
    {674.623912, 917.8769531},
    {674.6211566, 591.8057251},
    {674.6184012, 1562.333862},
    {674.6156459, 2725.339355},
    {674.6128905, 3542.870605},
    {674.6101352, 3237.626709},
    {674.6073799, 1963.685059},
    {674.6046247, 948.4092407},
    {674.6018694, 754.2011108},
    {674.5991142, 769.739624},
    {674.596359, 1164.165527},
    {674.5936038, 2098.279785},
    {674.5908487, 2958.445557},
    {674.5880935, 3668.697754},
    {674.5853384, 4153.015625},
    {674.5825833, 4635.314453},
    {674.5798283, 5073.393555},
    {674.5770732, 4817.368164},
    {674.5743182, 3654.49585},
    {674.5715632, 2332.06958},
    {674.5688083, 1593.56311},
    {674.5660533, 1382.949219},
    {674.5632984, 1220.268066},
    {674.5605435, 770.4715576},
    {674.5577886, 833.562439},
    {674.5550337, 807.7918701},
    {674.5522789, 1478.803467},
    {674.5495241, 3074.471436},
    {674.5467693, 3869.310547},
    {674.5440145, 3652.764893},
    {674.5412598, 2917.725098},
    {674.538505, 2115.982178},
    {674.5357503, 1737.807739},
    {674.5329956, 1335.924194},
    {674.530241, 1136.352783},
    {674.5274864, 1406.706299},
    {674.5247317, 773.0444336},
    {674.5219771, 446.787262},
    {674.5192226, 1301.657715},
    {674.516468, 1994.447998},
    {674.5137135, 2362.033691},
    {674.510959, 2391.580322},
    {674.5082045, 1797.274536},
    {674.5054501, 567.8452759},
    {674.5026956, 811.9489746},
    {674.4999412, 1526.783203},
    {674.4971868, 1631.797363},
    {674.4944325, 2083.518555},
    {674.4916781, 3012.389893},
    {674.4889238, 3342.541748},
    {674.4861695, 2771.74707},
    {674.4834152, 2379.067139},
    {674.480661, 2752.13501},
    {674.4779068, 3565.534668},
    {674.4751525, 3989.14917},
    {674.4723984, 3104.87207},
    {674.4696442, 1314.490356},
    {674.4668901, 803.4127808},
    {674.4641359, 2336.768311},
    {674.4613818, 2973.858887},
    {674.4586278, 2018.856445},
    {674.4558737, 1096.974243},
    {674.4531197, 1139.965698},
    {674.4503657, 1163.758423},
    {674.4476117, 1225.935791},
    {674.4448577, 1268.814819},
    {674.4421038, 603.9320679},
    {674.4393499, 217.1664276},
    {674.436596, 1121.991089},
    {674.4338421, 2585.576172},
    {674.4310883, 3080.650391},
    {674.4283344, 2390.54834},
    {674.4255806, 1214.224243},
    {674.4228269, 566.7775879},
    {674.4200731, 811.6956787},
    {674.4173194, 913.7035522},
    {674.4145657, 1546.883301},
    {674.411812, 2253.363281},
    {674.4090583, 2530.631348},
    {674.4063046, 2404.542969},
    {674.403551, 3007.831299},
    {674.4007974, 1482.311401},
    {674.3980438, 1922.084106},
    {674.3952903, 1951.040771},
    {674.3925368, 1510.865601},
    {674.3897832, 2077.196533},
    {674.3870298, 3618.857178},
    {674.3842763, 5425.393555},
    {674.3815228, 15564.97363},
    {674.3787694, 116870.0469},
    {674.376016, 312874.4688},
    {674.3732626, 512659.7813},
    {674.3705093, 580827.25},
    {674.367756, 468018.5313},
    {674.3650027, 261761.0156},
    {674.3622494, 95720.50781},
    {674.3594961, 29205.36133},
    {674.3567429, 13922.30664},
    {674.3539896, 8309.356445},
    {674.3512364, 6197.816406},
    {674.3484833, 2457.318359},
    {674.3457301, 7294.287598},
    {674.342977, 8135.105957},
    {674.3402239, 4464.359863},
    {674.3374708, 2911.270264},
    {674.3347177, 4860.013184},
    {674.3319647, 5072.168945},
    {674.3292117, 4278.435059},
    {674.3264587, 3826.949951},
    {674.3237057, 2780.50415},
    {674.3209528, 2858.534912},
    {674.3181998, 3353.280273},
    {674.3154469, 1850.38916},
    {674.3126941, 198.342392},
    {674.3099412, 657.7745972},
    {674.3071884, 347.2738647},
    {674.3044355, 361.0331421},
    {674.3016828, 784.906189},
    {674.29893, 1836.144043},
    {674.2961772, 2666.059814},
    {674.2934245, 1952.458374},
    {674.2906718, 835.5542603},
    {674.2879191, 588.3599243},
    {674.2851665, 164.3770294},
    {674.2824138, 347.4847412},
    {674.2796612, 447.9833069},
    {674.2769086, 651},
    {674.2741561, 340.9006958},
    {674.2714035, 1115.292236},
    {674.268651, 2257.663086},
    {674.2658985, 2196.981445},
    {674.263146, 1484.213867},
    {674.2603936, 1667.801025},
    {674.2576411, 2162.061523},
    {674.2548887, 1886.047607},
    {674.2521363, 1296.561768},
    {674.249384, 879.8372192},
    {674.2466316, 685.8312988},
    {674.2438793, 1103.910889},
    {674.241127, 1264.370605},
    {674.2383747, 730.1365967},
    {674.2356225, 632.3787231},
    {674.2328703, 556.3587036},
    {674.2301181, 777.828125},
    {674.2273659, 2001.377563},
    {674.2246137, 3243.102539},
    {674.2218616, 3933.940918},
    {674.2191095, 3342.487305},
    {674.2163574, 1638.602417},
    {674.2136053, 558.2545776},
    {674.2108532, 1076.176636},
    {674.2081012, 1584.407715},
    {674.2053492, 2164.473877},
    {674.2025972, 2045.957764},
    {674.1998453, 1279.465454},
    {674.1970933, 1274.143921},
    {674.1943414, 1251.730469},
    {674.1915895, 846.6213379},
    {674.1888376, 893.8978271},
    {674.1860858, 752.5766602},
    {674.183334, 394.3918152},
    {674.1805822, 962.673645},
    {674.1778304, 1397.615967},
    {674.1750786, 1493.608276},
    {674.1723269, 1373.629761},
    {674.1695752, 1204.284668},
    {674.1668235, 1339.834717},
    {674.1640718, 1411.848389},
    {674.1613202, 1078.794189},
    {674.1585685, 689.6085815},
    {674.1558169, 630.2418823},
    {674.1530654, 1370.324463},
    {674.1503138, 2530.2146},
    {674.1475623, 3243.492188},
    {674.1448108, 3186.416504},
    {674.1420593, 2700.454834},
    {674.1393078, 1813.867188},
    {674.1365564, 851.7230835},
    {674.1338049, 861.3334961},
    {674.1310535, 1114.391724},
    {674.1283022, 1177.304199},
    {674.1255508, 1445.869141},
    {674.1227995, 2016.13147},
    {674.1200482, 2584.033203},
    {674.1172969, 3098.719971},
    {674.1145456, 3486.729492},
    {674.1117944, 3415.645996},
    {674.1090432, 2704.50708},
    {674.106292, 1798.821045},
    {674.1035408, 1181.923462},
    {674.1007896, 635.6556396},
    {674.0980385, 311.4511719},
    {674.0952874, 722.1294556},
    {674.0925363, 1432.299316},
    {674.0897853, 1731.50415},
    {674.0870342, 1448.115234},
    {674.0842832, 680.15979},
    {674.0815322, 664.9151611},
    {674.0787812, 1989.189087},
    {674.0760303, 2532.318115},
    {674.0732794, 1971.571777},
    {674.0705285, 1396.751587},
    {674.0677776, 1623.326904},
    {674.0650267, 1611.725952},
    {674.0622759, 1125.2146},
    {674.0595251, 373.2664185},
    {674.0567743, 633.1131592},
    {674.0540235, 1279.297363},
    {674.0512727, 1556.98877},
    {674.048522, 1641.555664},
    {674.0457713, 1820.20752},
    {674.0430206, 2083.088379},
    {674.04027, 2313.998047},
    {674.0375193, 2746.805664},
    {674.0347687, 3363.490723},
    {674.0320181, 3465.371826},
    {674.0292676, 2664.765381},
    {674.026517, 1349.442749},
    {674.0237665, 451.6225281},
    {674.021016, 903.6030884},
    {674.0182655, 1182.672729},
    {674.0155151, 1180.812378},
    {674.0127646, 1330.194214},
    {674.0100142, 1593.366699},
    {674.0072638, 1595.649414},
    {674.0045135, 1395.937378},
    {674.0017631, 1116.376343}
}; // sampleMassData_


const unsigned int sampleMassDataSize_ = sizeof(sampleMassData_)/sizeof(RawMassDatum);


const char* sampleFrequencyData_ = 
"<158981.770800;(-5439.968005,19698.313350)>\n"
"<158983.072900;(16855.795550,11971.275420)>\n"
"<158984.375000;(7579.862497,-8411.025030)>\n"
"<158985.677100;(1495.080128,-684.037850)>\n"
"<158986.979200;(-583.143160,-1294.620782)>\n"
"<158988.281200;(-3191.215007,-2123.965274)>\n"
"<158989.583300;(6288.097808,13471.747780)>\n"
"<158990.885400;(281.171354,-2368.558610)>\n"
"<158992.187500;(6727.998171,-637.150071)>\n"
"<158993.489600;(90.481062,-2645.529419)>\n"
"<158994.791700;(-1910.952406,462.415227)>\n"
"<158996.093800;(2059.954130,-556.405563)>\n"
"<158997.395800;(-853.281447,-976.494563)>\n"
"<158998.697900;(427.634375,-5805.819177)>\n"
"<159000.000000;(1995.541301,684.000628)>\n"
"<159001.302100;(371.037816,710.206471)>\n"
"<159002.604200;(230.993848,2576.541884)>\n"
"<159003.906200;(2991.913376,-3229.454358)>\n"
"<159005.208300;(10.089849,4874.712579)>\n"
"<159006.510400;(671.270338,-3402.210367)>\n"
"<159007.812500;(-4667.111008,394.130011)>\n"
"<159009.114600;(2042.160737,1476.737853)>\n"
"<159010.416700;(1027.787493,-224.256592)>\n"
"<159011.718800;(921.559699,1753.042683)>\n"
"<159013.020800;(-2079.934743,2446.940865)>\n"
"<159014.322900;(-2668.935351,950.226079)>\n"
"<159015.625000;(-391.739889,5028.884809)>\n"
"<159016.927100;(267.066230,3494.638846)>\n"
"<159018.229200;(643.189814,4288.823088)>\n"
"<159019.531200;(-1866.926347,-1788.491729)>\n"
"<159020.833300;(1787.937165,2285.628296)>\n"
"<159022.135400;(-1073.928213,2224.735823)>\n"
"<159023.437500;(588.943389,-2456.921213)>\n"
"<159024.739600;(3023.425549,-1034.720299)>\n"
"<159026.041700;(2176.762945,5880.419895)>\n"
"<159027.343800;(641.724507,-1220.473197)>\n"
"<159028.645800;(-444.786593,-2747.717675)>\n"
"<159029.947900;(-709.886620,340.651628)>\n"
"<159031.250000;(3528.362712,-3680.032188)>\n"
"<159032.552100;(-233.347710,1986.951261)>\n"
"<159033.854200;(-1867.005685,1201.270154)>\n"
"<159035.156200;(-2138.743297,2104.050522)>\n"
"<159036.458300;(1129.120536,-373.835411)>\n"
"<159037.760400;(1411.508988,-2314.103875)>\n"
"<159039.062500;(459.005526,342.158393)>\n"
"<159040.364600;(6649.260712,-1753.456769)>\n"
"<159041.666700;(-4340.430084,-256.547987)>\n"
"<159042.968800;(-395.890304,320.711706)>\n"
"<159044.270800;(-1369.574330,2257.823209)>\n"
"<159045.572900;(1465.305975,-2808.272431)>\n"
"<159046.875000;(3357.053714,93.570172)>\n"
"<159048.177100;(1569.162340,-1683.677327)>\n"
"<159049.479200;(1133.972086,-1496.256356)>\n"
"<159050.781200;(-3324.508009,1612.518525)>\n"
"<159052.083300;(-1561.238172,552.300996)>\n"
"<159053.385400;(497.701663,-663.419030)>\n"
"<159054.687500;(891.910214,3334.854884)>\n"
"<159055.989600;(-1779.677159,1211.342366)>\n"
"<159057.291700;(1656.064322,869.604477)>\n"
"<159058.593800;(2140.570945,5954.845552)>\n"
"<159059.895800;(1959.202585,-1749.406764)>\n"
"<159061.197900;(5719.167019,-4067.657528)>\n"
"<159062.500000;(2346.107840,2731.616492)>\n"
"<159063.802100;(-589.045973,2030.711877)>\n"
"<159065.104200;(3019.165763,-3643.967824)>\n"
"<159066.406200;(1875.484670,-1332.308318)>\n"
"<159067.708300;(-395.486642,-806.344388)>\n"
"<159069.010400;(639.592737,-3750.512656)>\n"
"<159070.312500;(3374.705947,4023.004262)>\n"
"<159071.614600;(-3720.138802,-1426.572017)>\n"
"<159072.916700;(2905.031755,-2311.905988)>\n"
"<159074.218800;(-723.991388,43.232600)>\n"
"<159075.520800;(2011.255325,2387.881853)>\n"
"<159076.822900;(-788.267597,-853.484402)>\n"
"<159078.125000;(2661.376320,1226.661472)>\n"
"<159079.427100;(728.053285,-2941.263977)>\n"
"<159080.729200;(1850.278674,102.167454)>\n"
"<159082.031200;(1370.047440,-5141.024415)>\n"
"<159083.333300;(865.889278,-1267.050352)>\n"
"<159084.635400;(4339.020751,-3524.042993)>\n"
"<159085.937500;(2367.898540,-2418.438207)>\n"
"<159087.239600;(-1774.361566,-6306.716212)>\n"
"<159088.541700;(3742.813018,-1302.626339)>\n"
"<159089.843800;(3464.434756,-5646.707620)>\n"
"<159091.145800;(4275.161007,-3577.038735)>\n"
"<159092.447900;(820.318085,-7627.831353)>\n"
"<159093.750000;(4975.180414,-5661.637546)>\n"
"<159095.052100;(5474.716606,-7742.121772)>\n"
"<159096.354200;(6110.160151,-1859.085474)>\n"
"<159097.656200;(10821.048330,-11266.123780)>\n"
"<159098.958300;(28641.276320,-30905.514880)>\n"
"<159100.260400;(-84678.853340,-40217.694600)>\n"
"<159101.562500;(-56285.994110,4998.112006)>\n"
"<159102.864600;(-18005.111730,17583.779360)>\n"
"<159104.166700;(-7501.423711,11341.664310)>\n"
"<159105.468800;(-6187.376492,8297.369033)>\n"
"<159106.770800;(-4992.361000,10888.878590)>\n"
"<159108.072900;(-8844.919803,10622.088070)>\n"
"<159109.375000;(-3937.349522,4689.713808)>\n"
"<159110.677100;(-3430.424072,6209.074338)>\n"
"<159111.979200;(-5541.112901,4662.864005)>\n"
"<159113.281200;(-2434.716269,6077.530887)>\n"
"<159114.583300;(-3145.571507,5518.571998)>\n"
"<159115.885400;(-1714.773982,1972.806516)>\n"
"<159117.187500;(-5581.757849,4031.096278)>\n"
"<159118.489600;(-2211.040419,6795.404906)>\n"
"<159119.791700;(-1203.705045,4841.569662)>\n"
"<159121.093800;(-4335.241713,1049.150308)>\n"
"<159122.395800;(4943.052879,5312.172365)>\n"
"<159123.697900;(-1440.849153,6557.797553)>\n"
"<159125.000000;(-640.387790,4691.759996)>\n"
"<159126.302100;(-3954.283811,4475.147649)>\n"
"<159127.604200;(-3690.752905,7641.730382)>\n"
"<159128.906200;(-1200.793208,4074.824688)>\n"
"<159130.208300;(-3462.686251,973.835413)>\n"
"<159131.510400;(3454.157540,85.662417)>\n"
"<159132.812500;(-4904.355428,4712.140154)>\n"
"<159134.114600;(-4188.123617,5752.255884)>\n"
"<159135.416700;(1760.812170,6184.060635)>\n"
"<159136.718800;(781.766563,6340.400148)>\n"
"<159138.020800;(1499.869462,6369.819641)>\n"
"<159139.322900;(-2942.217750,3860.610281)>\n"
"<159140.625000;(-6807.281153,6453.963792)>\n"
"<159141.927100;(-629.052799,3185.250377)>\n"
"<159143.229200;(1624.110304,2658.798529)>\n"
"<159144.531200;(147.687087,1255.038198)>\n"
"<159145.833300;(-6118.284961,4702.102864)>\n"
"<159147.135400;(1185.673543,3408.352342)>\n"
"<159148.437500;(-5252.093269,1350.906877)>\n"
"<159149.739600;(813.367279,735.779308)>\n"
"<159151.041700;(-1202.886100,1500.271293)>\n"
"<159152.343800;(-3037.066664,6633.504803)>\n"
"<159153.645800;(-4058.074852,3654.688066)>\n"
"<159154.947900;(1563.077856,1260.102095)>\n"
"<159156.250000;(-5887.581550,1610.692100)>\n"
"<159157.552100;(767.861333,1714.276245)>\n"
"<159158.854200;(870.064588,61.929656)>\n"
"<159160.156200;(-2578.993837,-1755.504983)>\n"
"<159161.458300;(-6210.994979,2935.083000)>\n"
"<159162.760400;(895.058631,5523.714674)>\n"
"<159164.062500;(1735.383535,6750.773795)>\n"
"<159165.364600;(-3627.940900,4553.592212)>\n"
"<159166.666700;(4086.802120,31.520526)>\n"
"<159167.968800;(-4072.988175,6367.422998)>\n"
"<159169.270800;(106.220232,2127.072071)>\n"
"<159170.572900;(-3300.432149,2859.806769)>\n"
"<159171.875000;(-8688.687337,-1228.448340)>\n"
"<159173.177100;(-1782.111055,752.812408)>\n"
"<159174.479200;(53.870446,3484.151425)>\n"
"<159175.781200;(-188.513038,1072.991758)>\n"
"<159177.083300;(-1583.972480,4180.451185)>\n"
"<159178.385400;(-2785.405137,4231.601326)>\n"
"<159179.687500;(656.560564,4150.241225)>\n"
"<159180.989600;(-487.628122,6740.784678)>\n"
"<159182.291700;(-767.033722,1256.392951)>\n"
"<159183.593800;(-4311.453629,6605.107654)>\n"
"<159184.895800;(-1871.469309,8137.431442)>\n"
"<159186.197900;(-1239.425311,4526.802799)>\n"
"<159187.500000;(-225.425146,6784.393319)>\n"
"<159188.802100;(-3432.968781,-161.261639)>\n"
"<159190.104200;(-1909.941585,8936.563229)>\n"
"<159191.406200;(-3430.958675,9239.555367)>\n"
"<159192.708300;(1010.657817,9537.311164)>\n"
"<159194.010400;(-1658.679193,5498.717861)>\n"
"<159195.312500;(-4773.350496,7992.304522)>\n"
"<159196.614600;(-4021.448387,1709.859543)>\n"
"<159197.916700;(-3107.202019,9788.097869)>\n"
"<159199.218800;(-4228.733507,9815.415781)>\n"
"<159200.520800;(-2651.270427,12357.926990)>\n"
"<159201.822900;(3851.298487,9064.783009)>\n"
"<159203.125000;(-1924.542150,11609.087830)>\n"
"<159204.427100;(-5825.604783,12069.921890)>\n"
"<159205.729200;(-1600.976854,16263.997290)>\n"
"<159207.031200;(-3599.867111,12784.867080)>\n"
"<159208.333300;(-2938.354155,16039.149890)>\n"
"<159209.635400;(-7267.016397,20478.321400)>\n"
"<159210.937500;(-8427.080759,23473.785590)>\n"
"<159212.239600;(-10474.948520,22788.628440)>\n"
"<159213.541700;(-4489.906265,36117.666090)>\n"
"<159214.843800;(-12436.337760,49901.294540)>\n"
"<159216.145800;(-13427.643390,79766.286270)>\n"
"<159217.447900;(-6343.080666,233755.228000)>\n"
"<159218.750000;(186155.668300,-40556.199420)>\n"
"<159220.052100;(64189.621570,-91295.687310)>\n"
"<159221.354200;(32424.211960,-52622.907170)>\n"
"<159222.656200;(18946.522490,-37732.999750)>\n"
"<159223.958300;(12784.366660,-34534.137270)>\n"
"<159225.260400;(9098.126127,-27882.109590)>\n"
"<159226.562500;(4195.754231,-22873.668290)>\n"
"<159227.864600;(9319.097090,-16410.661240)>\n"
"<159229.166700;(4467.122137,-18129.474850)>\n"
"<159230.468800;(-24.479607,-17886.409120)>\n"
"<159231.770800;(4279.244923,-9310.987306)>\n"
"<159233.072900;(1920.153196,-15702.715960)>\n"
"<159234.375000;(2877.375034,-8318.654343)>\n"
"<159235.677100;(3457.597124,-14376.066460)>\n"
"<159236.979200;(4012.857036,-8963.765447)>\n"
"<159238.281200;(3778.415246,-9591.893603)>\n"
"<159239.583300;(3701.717212,-10664.411330)>\n"
"<159240.885400;(1151.368415,-9719.520455)>\n"
"<159242.187500;(2966.087089,-8103.541129)>\n"
"<159243.489600;(1436.212500,-7982.315732)>\n"
"<159244.791700;(2343.765434,-7666.413792)>\n"
"<159246.093800;(1488.237202,-6059.628145)>\n"
"<159247.395800;(1704.206576,-8349.027693)>\n"
"<159248.697900;(-85.107272,-12149.848750)>\n"
"<159250.000000;(1632.378781,-2673.930787)>\n"
"<159251.302100;(416.391576,-9485.246062)>\n"
"<159252.604200;(-4854.707157,-5884.444406)>\n"
"<159253.906200;(1962.092267,-7319.054784)>\n"
"<159255.208300;(2611.355820,-5796.919636)>\n"
"<159256.510400;(629.767142,-3323.924640)>\n"
"<159257.812500;(4347.692973,-3310.141103)>\n"
"<159259.114600;(3732.282400,-2696.092226)>\n"
"<159260.416700;(1470.871277,-7447.247763)>\n"
"<159261.718800;(430.955976,-11183.078150)>\n"
"<159263.020800;(-1177.646709,-6366.481012)>\n"
"<159264.322900;(1662.812113,-5041.883845)>\n"
"<159265.625000;(-2056.862302,-4255.986240)>\n"
"<159266.927100;(3222.592947,-3993.875189)>\n"
"<159268.229200;(343.662135,-5592.187310)>\n"
"<159269.531200;(1665.777689,-6885.102869)>\n"
"<159270.833300;(-1076.962602,-3906.347238)>\n"
"<159272.135400;(1180.640529,-6193.647436)>\n"
"<159273.437500;(2714.383691,-6273.368245)>\n"
"<159274.739600;(316.460424,-3462.245398)>\n"
"<159276.041700;(1485.881866,-5327.106641)>\n"
"<159277.343800;(1971.431973,-5872.258807)>\n"
"<159278.645800;(2047.312724,-3882.807649)>\n"
"<159279.947900;(193.293208,-8648.575640)>\n"
"<159281.250000;(442.595552,-8246.945573)>\n"
"<159282.552100;(-740.978824,-4126.048160)>\n"
"<159283.854200;(6216.864780,-6265.622693)>\n"
"<159285.156200;(-1097.916956,-7309.903843)>\n"
"<159286.458300;(-1448.970643,-6690.837424)>\n"
"<159287.760400;(3712.870417,-9411.523403)>\n"
"<159289.062500;(560.668359,-4795.552450)>\n"
"<159290.364600;(2544.618706,-12069.870370)>\n"
"<159291.666700;(3228.511729,-5598.378573)>\n"
"<159292.968800;(8115.521285,-3562.990038)>\n"
"<159294.270800;(2427.692111,-8242.402241)>\n"
"<159295.572900;(-423.122160,-8657.554595)>\n"
"<159296.875000;(1421.960140,-9889.042938)>\n"
"<159298.177100;(1321.828343,-3798.104906)>\n"
"<159299.479200;(-1376.640023,-9441.653413)>\n"
"<159300.781200;(-5289.218497,-15331.860700)>\n"
"<159302.083300;(-2331.869584,-11567.711800)>\n"
"<159303.385400;(-1056.435526,-13510.613120)>\n"
"<159304.687500;(-1731.216734,-12417.323890)>\n"
"<159305.989600;(-1115.927554,-12630.150290)>\n"
"<159307.291700;(-2184.059829,-11215.706020)>\n"
"<159308.593800;(2547.786122,-12107.242040)>\n"
"<159309.895800;(3388.769320,-14377.311590)>\n"
"<159311.197900;(532.782648,-11016.397210)>\n"
"<159312.500000;(-3306.963338,-15289.013070)>\n"
"<159313.802100;(2957.774203,-17201.439700)>\n"
"<159315.104200;(1323.364878,-17794.044510)>\n"
"<159316.406200;(2415.941356,-16071.043030)>\n"
"<159317.708300;(5632.335146,-21132.168520)>\n"
"<159319.010400;(-805.629233,-17789.569740)>\n"
"<159320.312500;(4050.437556,-22366.137430)>\n"
"<159321.614600;(-2050.155004,-29216.775300)>\n"
"<159322.916700;(2646.775097,-25968.076930)>\n"
"<159324.218800;(-2594.470687,-29517.088160)>\n"
"<159325.520800;(162.084295,-34808.531580)>\n"
"<159326.822900;(1066.760777,-36977.019940)>\n"
"<159328.125000;(2438.146470,-45765.562070)>\n"
"<159329.427100;(-4959.946379,-50662.135900)>\n"
"<159330.729200;(-4482.799904,-61652.462400)>\n"
"<159332.031200;(-8066.221272,-79942.851830)>\n"
"<159333.333300;(-10594.081740,-119636.552900)>\n"
"<159334.635400;(-25691.005050,-200410.834800)>\n"
"<159335.937500;(-213658.594500,-659934.363200)>\n"
"<159337.239600;(-195277.448400,381806.735600)>\n"
"<159338.541700;(-3607.814104,174096.698700)>\n"
"<159339.843800;(-20174.582830,107351.229200)>\n"
"<159341.145800;(-6489.370161,89465.967770)>\n"
"<159342.447900;(-10065.636760,79291.198420)>\n"
"<159343.750000;(-3053.407326,60874.219410)>\n"
"<159345.052100;(-568.638097,51714.699570)>\n"
"<159346.354200;(-954.716555,44697.791940)>\n"
"<159347.656200;(2457.422718,40989.867110)>\n"
"<159348.958300;(-1137.727536,36115.555170)>\n"
"<159350.260400;(777.406151,28617.133270)>\n"
"<159351.562500;(590.494564,30001.331610)>\n"
"<159352.864600;(175.131267,27711.513630)>\n"
"<159354.166700;(-2963.681502,24936.186580)>\n"
"<159355.468800;(1870.842411,26613.483300)>\n"
"<159356.770800;(3266.462896,26342.258940)>\n"
"<159358.072900;(2869.948307,23894.122540)>\n"
"<159359.375000;(4622.374623,18137.151440)>\n"
"<159360.677100;(1027.487194,19740.217960)>\n"
"<159361.979200;(-2276.143617,22751.449920)>\n"
"<159363.281200;(2568.704705,20532.513670)>\n"
"<159364.583300;(-1651.158674,20017.495250)>\n"
"<159365.885400;(4164.543009,17838.274640)>\n"
"<159367.187500;(-1679.470525,14917.731740)>\n"
"<159368.489600;(-2000.857508,19807.544810)>\n"
"<159369.791700;(-51.237545,21050.681960)>\n"
"<159371.093800;(-473.687647,19895.121750)>\n"
"<159372.395800;(2666.925339,20566.692750)>\n"
"<159373.697900;(-2243.690458,18252.294130)>\n"
"<159375.000000;(1946.285694,20794.426280)>\n"
"<159376.302100;(2510.830953,17605.611180)>\n"
"<159377.604200;(2140.181099,13032.226930)>\n"
"<159378.906200;(-485.580520,17249.702250)>\n"
"<159380.208300;(258.969393,16760.700020)>\n"
"<159381.510400;(-739.481390,16072.127040)>\n"
"<159382.812500;(-1277.497733,12950.309490)>\n"
"<159384.114600;(3716.176611,15534.955680)>\n"
"<159385.416700;(1245.826083,24235.335490)>\n"
"<159386.718800;(1173.111379,9968.588994)>\n"
"<159388.020800;(2353.787670,15302.046560)>\n"
"<159389.322900;(3051.853397,15779.747670)>\n"
"<159390.625000;(-86.058751,13718.586820)>\n"
"<159391.927100;(-316.311728,15412.776160)>\n"
"<159393.229200;(2753.906724,14500.974560)>\n"
"<159394.531200;(-762.264559,13490.965480)>\n"
"<159395.833300;(1038.288211,12146.380050)>\n"
"<159397.135400;(2089.210506,9333.127557)>\n"
"<159398.437500;(2069.171408,18204.429240)>\n"
"<159399.739600;(870.096511,14824.452060)>\n"
"<159401.041700;(272.972680,16110.248280)>\n"
"<159402.343800;(-2183.150454,16170.548980)>\n"
"<159403.645800;(3815.840070,17776.030460)>\n"
"<159404.947900;(-66.503788,9233.706607)>\n"
"<159406.250000;(-2706.892541,20304.237840)>\n"
"<159407.552100;(1148.909600,13902.286780)>\n"
"<159408.854200;(-1044.981140,15580.827210)>\n"
"<159410.156200;(1557.583388,15674.443000)>\n"
"<159411.458300;(1420.642527,18389.776050)>\n"
"<159412.760400;(-1094.786294,19843.799370)>\n"
"<159414.062500;(4896.668391,13128.510720)>\n"
"<159415.364600;(108.289618,17463.498590)>\n"
"<159416.666700;(3186.277183,19436.678440)>\n"
"<159417.968800;(1081.737916,21716.285130)>\n"
"<159419.270800;(1328.018494,20008.046950)>\n"
"<159420.572900;(3325.989555,19880.576640)>\n"
"<159421.875000;(-2644.088666,19243.843650)>\n"
"<159423.177100;(922.144370,21196.913040)>\n"
"<159424.479200;(2723.078015,22766.318380)>\n"
"<159425.781200;(1446.660903,20234.297580)>\n"
"<159427.083300;(1371.925129,27403.440390)>\n"
"<159428.385400;(3808.706272,22703.076670)>\n"
"<159429.687500;(-1428.961239,25113.191770)>\n"
"<159430.989600;(7822.295405,27516.223450)>\n"
"<159432.291700;(4996.267312,28721.847580)>\n"
"<159433.593800;(1761.480415,35031.878640)>\n"
"<159434.895800;(1261.978898,31675.732630)>\n"
"<159436.197900;(1145.721734,34949.097560)>\n"
"<159437.500000;(3586.332328,36847.600870)>\n"
"<159438.802100;(1564.219364,37959.416530)>\n"
"<159440.104200;(158.173057,41454.351340)>\n"
"<159441.406200;(7524.639829,42235.338990)>\n"
"<159442.708300;(4877.101315,44697.124220)>\n"
"<159444.010400;(4080.603141,50558.420710)>\n"
"<159445.312500;(6577.789977,58423.297650)>\n"
"<159446.614600;(12831.995710,62206.404670)>\n"
"<159447.916700;(12432.574750,78692.367570)>\n"
"<159449.218800;(14863.217740,97002.269610)>\n"
"<159450.520800;(20799.473080,118598.677800)>\n"
"<159451.822900;(22593.311980,165638.891700)>\n"
"<159453.125000;(47599.335840,277486.399800)>\n"
"<159454.427100;(286144.990400,833086.497200)>\n"
"<159455.729200;(185071.679600,-646557.315700)>\n"
"<159457.031200;(-17704.581440,-233633.298900)>\n"
"<159458.333300;(12582.540060,-142740.249800)>\n"
"<159459.635400;(-4281.026921,-119490.160700)>\n"
"<159460.937500;(-2407.375413,-104118.820900)>\n"
"<159462.239600;(-6020.466709,-71343.604500)>\n"
"<159463.541700;(-6861.637568,-64726.618340)>\n"
"<159464.843800;(4448.264865,-50486.194870)>\n"
"<159466.145800;(-2683.225884,-43254.466920)>\n"
"<159467.447900;(-1409.582306,-46362.112560)>\n"
"<159468.750000;(-901.917142,-39197.029140)>\n"
"<159470.052100;(-726.541158,-34237.362550)>\n"
"<159471.354200;(352.485137,-32437.557050)>\n"
"<159472.656200;(-2127.182747,-33974.198590)>\n"
"<159473.958300;(-3242.789607,-27050.131790)>\n"
"<159475.260400;(-1547.455150,-23083.704950)>\n"
"<159476.562500;(-935.286804,-20857.628780)>\n"
"<159477.864600;(-612.779078,-22032.472190)>\n"
"<159479.166700;(452.453592,-23621.175920)>\n"
"<159480.468800;(-1525.529117,-17904.755700)>\n"
"<159481.770800;(-3100.586634,-19514.288390)>\n"
"<159483.072900;(1008.758808,-15846.074870)>\n"
"<159484.375000;(-127.895811,-14624.515230)>\n"
"<159485.677100;(165.146018,-16758.957650)>\n"
"<159486.979200;(-700.841593,-14797.912350)>\n"
"<159488.281200;(511.814166,-12086.065760)>\n"
"<159489.583300;(-234.976704,-7792.639622)>\n"
"<159490.885400;(232.878319,-17402.849940)>\n"
"<159492.187500;(-907.310367,-14336.829840)>\n"
"<159493.489600;(-56.307938,-11496.904200)>\n"
"<159494.791700;(-4488.884838,-13671.545780)>\n"
"<159496.093800;(-1537.873247,-13450.963810)>\n"
"<159497.395800;(-1269.353491,-9392.217590)>\n"
"<159498.697900;(-3329.717995,-8884.638460)>\n"
"<159500.000000;(-2548.554362,-9054.318285)>\n"
"<159501.302100;(356.446580,-6484.250542)>\n"
"<159502.604200;(-2093.093433,-7514.297621)>\n"
"<159503.906200;(76.349843,-10190.160150)>\n"
"<159505.208300;(368.091387,-7901.348925)>\n"
"<159506.510400;(1136.846862,-8966.137390)>\n"
"<159507.812500;(-3421.439131,-11906.911110)>\n"
"<159509.114600;(4180.383572,-10307.527550)>\n"
"<159510.416700;(1098.526119,-7472.453313)>\n"
"<159511.718800;(-369.327262,-8346.637434)>\n"
"<159513.020800;(1233.861802,-6290.960060)>\n"
"<159514.322900;(-2639.342820,-6260.011947)>\n"
"<159515.625000;(3864.767793,-6636.383515)>\n"
"<159516.927100;(-3769.148438,-6986.464212)>\n"
"<159518.229200;(-635.477924,-8819.456939)>\n"
"<159519.531200;(-1044.541484,-7989.777441)>\n"
"<159520.833300;(-1079.298437,-8769.949667)>\n"
"<159522.135400;(-215.466848,-4330.371898)>\n"
"<159523.437500;(-961.581268,-6154.600524)>\n"
"<159524.739600;(-3940.764238,-10223.271770)>\n"
"<159526.041700;(-376.770403,-6940.595355)>\n"
"<159527.343800;(-2650.722101,-3603.928142)>\n"
"<159528.645800;(-399.944733,-5303.995691)>\n"
"<159529.947900;(1449.245652,-5796.593595)>\n"
"<159531.250000;(-891.474849,-3515.267543)>\n"
"<159532.552100;(2034.532694,-5561.745413)>\n"
"<159533.854200;(-327.464439,-1401.321585)>\n"
"<159535.156200;(-2604.135031,-8559.828372)>\n"
"<159536.458300;(-854.079618,-2473.551958)>\n"
"<159537.760400;(877.477740,-2005.068660)>\n"
"<159539.062500;(447.877941,-4758.213608)>\n"
"<159540.364600;(3182.238834,-4033.452087)>\n"
"<159541.666700;(125.690950,-6004.211682)>\n"
"<159542.968800;(472.321287,-3782.142445)>\n"
"<159544.270800;(-2322.356411,-4523.148313)>\n"
"<159545.572900;(-1544.541889,-4125.527520)>\n"
"<159546.875000;(2744.024998,-124.498868)>\n"
"<159548.177100;(1214.952943,-4915.178682)>\n"
"<159549.479200;(-1851.299452,-3969.540991)>\n"
"<159550.781200;(1929.802295,-6993.515114)>\n"
"<159552.083300;(-2383.743053,-4257.875278)>\n"
"<159553.385400;(-1565.992999,-2133.806117)>\n"
"<159554.687500;(335.881485,-1297.322869)>\n"
"<159555.989600;(309.204915,-4467.843686)>\n"
"<159557.291700;(838.688853,-3988.710243)>\n"
"<159558.593800;(2048.608531,-1501.838855)>\n"
"<159559.895800;(-2828.295503,222.822319)>\n"
"<159561.197900;(-704.390913,-2799.147518)>\n"
"<159562.500000;(-3114.714576,-4921.409029)>\n"
"<159563.802100;(2186.784077,-1939.786003)>\n"
"<159565.104200;(-2875.736581,-1628.718419)>\n"
"<159566.406200;(-1778.128652,-4624.060459)>\n"
"<159567.708300;(799.193453,-3489.320834)>\n"
; // sampleFrequencyData_ 

