#!/usr/bin/make -f
# * Makefile to create MediathekView's upstream source tarball
# *
# * Copyright 2014-2017 Markus Koschany <apo@debian.org>
# * This program is free software: you can redistribute it and/or modify
# * it under the terms of the GNU General Public License as published by
# * the Free Software Foundation, either version 3 of the License, or
# * any later version.
# *
# * This program is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# * GNU General Public License for more details.
# *
# * You should have received a copy of the GNU General Public License
# * along with this program. If not, see <http://www.gnu.org/licenses/>.
# */
PKG      := mediathekview
PKG2     := msearch
VER      := 13.1.2
UURL     := https://github.com/xaverW/MediathekView.git
COMMIT   := 5bb2c5b321fecfa9b046b5893851fd8916226606

.PHONY: make-orig-source
make-orig-source: $(PKG)_$(VER).tar.xz
	@

$(PKG)_$(VER).tar.xz:
	@echo "# Cloning upstream git repository..."
	[ -d $(PKG)-$(VER) ] || git clone $(UURL) $(PKG)-$(VER)
	cd $(PKG)-$(VER) \
	&& git checkout -b debiansource $(COMMIT) \
	&& echo "# Setting times..." \
	&& for F in $$(git ls-tree -r --name-only HEAD); \
	do touch --no-dereference -d "$$(git log -1 --format="%ai" -- $$F)" "$$F"; done \
	&& echo "# Cleaning-up..." \
	&& mv -v \
		res/bin/flv.sh . \
	&& $(RM) -r -v \
		src/main/java/org/jdesktop \
		gradle/ \
		libs/ \
		res/ \
		scripte/ \
		gradlew* \
		sonar-project.properties \
		.git/
	@echo "# Packing..."
	find -L "$(PKG)-$(VER)" -xdev -type f -print | sort \
	| XZ_OPT="-6v" tar -caf "$(PKG)_$(VER).tar.xz" -T- --owner=root --group=root --mode=a+rX
