/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File FileSelection.h
// Baudouin Raoult - ECMWF Nov 98

#ifndef FileSelection_H
#define FileSelection_H

#include <string>
using std::string;

#include "UIFileSelection.h"
#include "Dialog.h"

class FileSelection : public Dialog<FileSelection,UIFileSelection_c> {
public:

// -- Exceptions
	// None

// -- Contructors

	FileSelection();

// -- Destructor

	~FileSelection(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static bool ask(const char* title, 
		const char* file   = 0,
		const char* filter = 0,
		const char* dir    = 0);

	static const string& file();

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	FileSelection(const FileSelection&);
	FileSelection& operator=(const FileSelection&);


	string file_;

// -- Methods

	void set(const char*,const char*);

	bool choose(const char*,const char*,
		const char*,const char*);


// -- Overridden methods

	virtual void okCB( Widget, XtPointer ) ;

// -- Class members


// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const FileSelection& p)
	//	{ p.print(s); return s; }

};

inline void destroy(FileSelection**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(FileSelection);
//#endif

#endif
