/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File EditorFactory.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef HelpFactory_H
#define HelpFactory_H

#include <string>
using std::string;

#include "mars.h"
#include <Xm/Xm.h>

class RequestPanelHelp;
class RequestPanel;
class Parameter;

class HelpFactory {
public:

// -- Exceptions
	// None

// -- Contructors

	HelpFactory(const string& name);

// -- Destructor

	virtual ~HelpFactory(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	virtual RequestPanelHelp* make(Widget w, RequestPanel& owner, const Parameter& def) = 0;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static RequestPanelHelp* create(Widget parent, RequestPanel& owner, const Parameter& info);

protected:

// -- Members
	// None

// -- Methods
	
	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed
						
	HelpFactory(const HelpFactory&);
	HelpFactory& operator=(const HelpFactory&);

// -- Members
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends


};

template<class T>
class HelpMaker : public HelpFactory {
	RequestPanelHelp* make(Widget w, RequestPanel& owner, const Parameter& def) { return new T(w, owner, def); }
public:
	HelpMaker(const string& name) : HelpFactory(name) {}
};


#endif
