// Copyright (c) 2010-2023, Lawrence Livermore National Security, LLC. Produced
// at the Lawrence Livermore National Laboratory. All Rights reserved. See files
// LICENSE and NOTICE for details. LLNL-CODE-806117.
//
// This file is part of the MFEM library. For more information and source code
// availability visit https://mfem.org.
//
// MFEM is free software; you can redistribute it and/or modify it under the
// terms of the BSD-3 license. We welcome feedback and contributions, see file
// CONTRIBUTING.md for details.

#ifndef MFEM_PERFORMANCE_HPP
#define MFEM_PERFORMANCE_HPP

#include "mfem.hpp"
#include "general/tassign.hpp"
#include "linalg/tlayout.hpp"
#include "linalg/tmatrix.hpp"
#include "linalg/ttensor.hpp"
#include "mesh/tmesh.hpp"
#include "fem/tintrules.hpp"
#include "fem/tfe.hpp"
#include "fem/tfespace.hpp"
#include "fem/tcoefficient.hpp"
#include "fem/teltrans.hpp"
#include "fem/tevaluator.hpp"
#include "fem/tbilininteg.hpp"
#include "fem/tbilinearform.hpp"

#endif
