/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.framework.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import sharpen.core.framework.resources.WorkspaceUtilities;

public class SimpleProject {
    protected final IProject _project;

    public SimpleProject(String name) throws CoreException {
        this(name, null);
    }

    public SimpleProject(String name, IProgressMonitor monitor) throws CoreException {
        this(WorkspaceUtilities.getProject(name), monitor);
    }

    public SimpleProject(IProject project, IProgressMonitor monitor) throws CoreException {
        this._project = project;
        WorkspaceUtilities.initializeProject(this._project, monitor);
    }

    public String getName() {
        return this._project.getName();
    }

    public IFolder createFolder(String name) throws CoreException {
        return this.createFolder(name, null);
    }

    public IFolder createFolder(String name, IProgressMonitor monitor) throws CoreException {
        IFolder folder = this.getFolder(name);
        folder.create(false, true, monitor);
        return folder;
    }

    public IFolder getFolder(String name) {
        return this._project.getFolder(name);
    }

    public IProject getProject() {
        return this._project;
    }

    public void dispose() {
        try {
            this._project.delete(true, true, null);
        }
        catch (CoreException x) {
            x.printStackTrace();
        }
    }

    public void addReferencedProject(IProject reference, IProgressMonitor monitor) throws CoreException {
        if (reference == null) {
            throw new IllegalArgumentException("reference");
        }
        WorkspaceUtilities.addProjectReference(this._project, reference, monitor);
    }

    public IFile getFile(String path) {
        return this._project.getFile(path);
    }
}

