/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;

public class IndentedWriter {
    private static final int MAX_COLUMNS = 80;
    String _lineSeparator = System.getProperty("line.separator");
    String _indentString = "\t";
    int _indentLevel = 0;
    private int _column;
    private Writer _delegate;
    private String _prefix;

    public IndentedWriter(Writer writer) {
        this._delegate = writer;
    }

    public void indent() {
        ++this._indentLevel;
    }

    public void outdent() {
        --this._indentLevel;
    }

    public void writeIndented(String s) {
        this.writeIndentation();
        this.write(s);
    }

    public void writeIndentedLine(String s) {
        this.writeIndentation();
        this.writeLine(s);
    }

    public void write(String s) {
        if (this._column > 80) {
            this.writeLine();
            this.writeIndented(this._indentString);
        }
        this.writeBlock(s);
    }

    public void writeBlock(String s) {
        this.uncheckedWrite(s);
        this._column += s.length();
    }

    public void writeLine() {
        this.writeLine("");
    }

    public void writeLine(String s) {
        try {
            this._delegate.write(s);
            this._delegate.write(this._lineSeparator);
            this._column = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void uncheckedWrite(String s) {
        try {
            this._delegate.write(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeIndentation() {
        int i = 0;
        while (i < this._indentLevel) {
            this.uncheckedWrite(this._indentString);
            ++i;
        }
        if (this._prefix != null) {
            this.uncheckedWrite(this._prefix);
        }
    }

    public Writer delegate() {
        return this._delegate;
    }

    public void writeLines(String lines) {
        BufferedReader lineReader = new BufferedReader(new StringReader(lines));
        try {
            String line;
            while ((line = lineReader.readLine()) != null) {
                if (line.trim().length() > 0) {
                    this.writeIndentedLine(line);
                    continue;
                }
                this.writeLine();
            }
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public void linePrefix(String prefix) {
        this._prefix = prefix;
    }
}

