/* moonshot-keyring-store.c generated by valac 0.24.0, the Vala compiler
 * generated from moonshot-keyring-store.vala, do not modify */

/*
 * Copyright (c) 2011-2014, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gnome-keyring.h>
#include <stdio.h>


#define TYPE_IIDENTITY_CARD_STORE (iidentity_card_store_get_type ())
#define IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStore))
#define IS_IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IIDENTITY_CARD_STORE))
#define IIDENTITY_CARD_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStoreIface))

typedef struct _IIdentityCardStore IIdentityCardStore;
typedef struct _IIdentityCardStoreIface IIdentityCardStoreIface;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define IIDENTITY_CARD_STORE_TYPE_STORE_TYPE (iidentity_card_store_store_type_get_type ())

#define TYPE_KEYRING_STORE (keyring_store_get_type ())
#define KEYRING_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYRING_STORE, KeyringStore))
#define KEYRING_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYRING_STORE, KeyringStoreClass))
#define IS_KEYRING_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYRING_STORE))
#define IS_KEYRING_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYRING_STORE))
#define KEYRING_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYRING_STORE, KeyringStoreClass))

typedef struct _KeyringStore KeyringStore;
typedef struct _KeyringStoreClass KeyringStoreClass;
typedef struct _KeyringStorePrivate KeyringStorePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__gnome_keyring_found_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gnome_keyring_found_free0_ (var), NULL)))
#define _gnome_keyring_attribute_list_free0(var) ((var == NULL) ? NULL : (var = (gnome_keyring_attribute_list_free (var), NULL)))

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;

typedef enum  {
	IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE,
	IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING
} IIdentityCardStoreStoreType;

struct _IIdentityCardStoreIface {
	GTypeInterface parent_iface;
	void (*add_card) (IIdentityCardStore* self, IdCard* card);
	gboolean (*remove_card) (IIdentityCardStore* self, IdCard* card);
	IdCard* (*update_card) (IIdentityCardStore* self, IdCard* card);
	IIdentityCardStoreStoreType (*get_store_type) (IIdentityCardStore* self);
	GeeLinkedList* (*get_card_list) (IIdentityCardStore* self);
};

struct _KeyringStore {
	GObject parent_instance;
	KeyringStorePrivate * priv;
};

struct _KeyringStoreClass {
	GObjectClass parent_class;
};

struct _KeyringStorePrivate {
	GeeLinkedList* id_card_list;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};


static gpointer keyring_store_parent_class = NULL;
static IIdentityCardStoreIface* keyring_store_iidentity_card_store_parent_iface = NULL;

GType id_card_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_store_type_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_get_type (void) G_GNUC_CONST;
GType keyring_store_get_type (void) G_GNUC_CONST;
#define KEYRING_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KEYRING_STORE, KeyringStorePrivate))
enum  {
	KEYRING_STORE_DUMMY_PROPERTY
};
#define KEYRING_STORE_keyring_store_attribute "Moonshot"
#define KEYRING_STORE_keyring_store_version "1.0"
#define KEYRING_STORE_item_type GNOME_KEYRING_ITEM_GENERIC_SECRET
static void keyring_store_real_add_card (IIdentityCardStore* base, IdCard* card);
void keyring_store_store_id_cards (KeyringStore* self);
static IdCard* keyring_store_real_update_card (IIdentityCardStore* base, IdCard* card);
const gchar* id_card_get_display_name (IdCard* self);
static gboolean keyring_store_real_remove_card (IIdentityCardStore* base, IdCard* card);
static IIdentityCardStoreStoreType keyring_store_real_get_store_type (IIdentityCardStore* base);
static GeeLinkedList* keyring_store_real_get_card_list (IIdentityCardStore* base);
static void keyring_store_clear_keyring (KeyringStore* self);
static void _gnome_keyring_found_free0_ (gpointer var);
static void _g_list_free__gnome_keyring_found_free0_ (GList* self);
static void keyring_store_load_id_cards (KeyringStore* self);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
void id_card_set_issuer (IdCard* self, const gchar* value);
void id_card_set_username (IdCard* self, const gchar* value);
void id_card_set_display_name (IdCard* self, const gchar* value);
void id_card_set_services (IdCard* self, gchar** value, int value_length1);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
void trust_anchor_set_ca_cert (TrustAnchor* self, const gchar* value);
void trust_anchor_set_server_cert (TrustAnchor* self, const gchar* value);
void trust_anchor_set_subject (TrustAnchor* self, const gchar* value);
void trust_anchor_set_subject_alt (TrustAnchor* self, const gchar* value);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
void id_card_set_rules (IdCard* self, Rule* value, int value_length1);
static void _vala_Rule_array_free (Rule* array, gint array_length);
void id_card_set_store_password (IdCard* self, gboolean value);
gboolean id_card_get_store_password (IdCard* self);
void id_card_set_password (IdCard* self, const gchar* value);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
gchar** id_card_get_services (IdCard* self, int* result_length1);
const gchar* id_card_get_issuer (IdCard* self);
const gchar* id_card_get_username (IdCard* self);
const gchar* trust_anchor_get_ca_cert (TrustAnchor* self);
const gchar* trust_anchor_get_server_cert (TrustAnchor* self);
const gchar* trust_anchor_get_subject (TrustAnchor* self);
const gchar* trust_anchor_get_subject_alt (TrustAnchor* self);
const gchar* id_card_get_password (IdCard* self);
KeyringStore* keyring_store_new (void);
KeyringStore* keyring_store_construct (GType object_type);
static void keyring_store_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void keyring_store_real_add_card (IIdentityCardStore* base, IdCard* card) {
	KeyringStore * self;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_if_fail (card != NULL);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = card;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_store_id_cards (self);
#line 207 "moonshot-keyring-store.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 214 "moonshot-keyring-store.c"
}


static IdCard* keyring_store_real_update_card (IIdentityCardStore* base, IdCard* card) {
	KeyringStore * self;
	IdCard* result = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_val_if_fail (card != NULL, NULL);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = card;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = self->priv->id_card_list;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp3_ = card;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp3_);
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_store_id_cards (self);
#line 243 "moonshot-keyring-store.c"
	{
		GeeLinkedList* _idcard_list = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		GeeLinkedList* _tmp5_ = NULL;
		gint _idcard_size = 0;
		GeeLinkedList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _idcard_index = 0;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp4_ = self->priv->id_card_list;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_idcard_list = _tmp5_;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp6_ = _idcard_list;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp8_ = _tmp7_;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_idcard_size = _tmp8_;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_idcard_index = -1;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		while (TRUE) {
#line 271 "moonshot-keyring-store.c"
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			IdCard* idcard = NULL;
			GeeLinkedList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			IdCard* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			IdCard* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp9_ = _idcard_index;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_idcard_index = _tmp9_ + 1;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp10_ = _idcard_index;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp11_ = _idcard_size;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				break;
#line 297 "moonshot-keyring-store.c"
			}
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp12_ = _idcard_list;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp13_ = _idcard_index;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			idcard = (IdCard*) _tmp14_;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp15_ = idcard;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp16_ = id_card_get_display_name (_tmp15_);
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp17_ = _tmp16_;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp18_ = card;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp19_ = id_card_get_display_name (_tmp18_);
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp20_ = _tmp19_;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (g_strcmp0 (_tmp17_, _tmp20_) == 0) {
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				result = idcard;
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_object_unref0 (_idcard_list);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				return result;
#line 327 "moonshot-keyring-store.c"
			}
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_object_unref0 (idcard);
#line 331 "moonshot-keyring-store.c"
		}
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_g_object_unref0 (_idcard_list);
#line 335 "moonshot-keyring-store.c"
	}
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = NULL;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 341 "moonshot-keyring-store.c"
}


static gboolean keyring_store_real_remove_card (IIdentityCardStore* base, IdCard* card) {
	KeyringStore * self;
	gboolean result = FALSE;
	gboolean retval = FALSE;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_val_if_fail (card != NULL, FALSE);
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = card;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	retval = _tmp2_;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp3_ = retval;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	if (_tmp3_) {
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		keyring_store_store_id_cards (self);
#line 371 "moonshot-keyring-store.c"
	}
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = retval;
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 377 "moonshot-keyring-store.c"
}


static IIdentityCardStoreStoreType keyring_store_real_get_store_type (IIdentityCardStore* base) {
	KeyringStore * self;
	IIdentityCardStoreStoreType result = 0;
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 390 "moonshot-keyring-store.c"
}


static GeeLinkedList* keyring_store_real_get_card_list (IIdentityCardStore* base) {
	KeyringStore * self;
	GeeLinkedList* result = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = _tmp1_;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 409 "moonshot-keyring-store.c"
}


static void _gnome_keyring_found_free0_ (gpointer var) {
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	(var == NULL) ? NULL : (var = (gnome_keyring_found_free (var), NULL));
#line 416 "moonshot-keyring-store.c"
}


static void _g_list_free__gnome_keyring_found_free0_ (GList* self) {
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_list_foreach (self, (GFunc) _gnome_keyring_found_free0_, NULL);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_list_free (self);
#line 425 "moonshot-keyring-store.c"
}


static void keyring_store_clear_keyring (KeyringStore* self) {
	GnomeKeyringAttributeList* match = NULL;
	GnomeKeyringAttributeList* _tmp0_ = NULL;
	GnomeKeyringAttributeList* _tmp1_ = NULL;
	GList* items = NULL;
	GnomeKeyringAttributeList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_if_fail (self != NULL);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = gnome_keyring_attribute_list_new ();
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	match = _tmp0_;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = match;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gnome_keyring_attribute_list_append_string (_tmp1_, KEYRING_STORE_keyring_store_attribute, KEYRING_STORE_keyring_store_version);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = match;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gnome_keyring_find_items_sync (KEYRING_STORE_item_type, _tmp2_, &_tmp3_);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	__g_list_free__gnome_keyring_found_free0_0 (items);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	items = _tmp3_;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp4_ = items;
#line 457 "moonshot-keyring-store.c"
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		entry_collection = _tmp4_;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
#line 465 "moonshot-keyring-store.c"
			GnomeKeyringFound* entry = NULL;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			entry = (GnomeKeyringFound*) entry_it->data;
#line 469 "moonshot-keyring-store.c"
			{
				GnomeKeyringResult _result_ = 0;
				GnomeKeyringFound* _tmp5_ = NULL;
				guint _tmp6_ = 0U;
				GnomeKeyringResult _tmp7_ = 0;
				GnomeKeyringResult _tmp8_ = 0;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp5_ = entry;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp6_ = _tmp5_->item_id;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp7_ = gnome_keyring_item_delete_sync (NULL, (guint32) _tmp6_);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_result_ = _tmp7_;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp8_ = _result_;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp8_ != GNOME_KEYRING_RESULT_OK) {
#line 488 "moonshot-keyring-store.c"
					FILE* _tmp9_ = NULL;
					GnomeKeyringResult _tmp10_ = 0;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp9_ = stdout;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp10_ = _result_;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					fprintf (_tmp9_, "GnomeKeyring.item_delete_sync() failed. result: %d", (gint) _tmp10_);
#line 497 "moonshot-keyring-store.c"
				}
			}
		}
	}
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	__g_list_free__gnome_keyring_found_free0_0 (items);
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_gnome_keyring_attribute_list_free0 (match);
#line 506 "moonshot-keyring-store.c"
}


static void _vala_Rule_array_free (Rule* array, gint array_length) {
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	if (array != NULL) {
#line 513 "moonshot-keyring-store.c"
		int i;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rule_destroy (&array[i]);
#line 519 "moonshot-keyring-store.c"
		}
	}
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_free (array);
#line 524 "moonshot-keyring-store.c"
}


static void keyring_store_load_id_cards (KeyringStore* self) {
	GeeLinkedList* _tmp0_ = NULL;
	GnomeKeyringAttributeList* match = NULL;
	GnomeKeyringAttributeList* _tmp1_ = NULL;
	GnomeKeyringAttributeList* _tmp2_ = NULL;
	GList* items = NULL;
	GnomeKeyringAttributeList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_if_fail (self != NULL);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = gnome_keyring_attribute_list_new ();
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	match = _tmp1_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = match;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gnome_keyring_attribute_list_append_string (_tmp2_, KEYRING_STORE_keyring_store_attribute, KEYRING_STORE_keyring_store_version);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp3_ = match;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gnome_keyring_find_items_sync (KEYRING_STORE_item_type, _tmp3_, &_tmp4_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	__g_list_free__gnome_keyring_found_free0_0 (items);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	items = _tmp4_;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp5_ = items;
#line 561 "moonshot-keyring-store.c"
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		entry_collection = _tmp5_;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
#line 569 "moonshot-keyring-store.c"
			GnomeKeyringFound* entry = NULL;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			entry = (GnomeKeyringFound*) entry_it->data;
#line 573 "moonshot-keyring-store.c"
			{
				IdCard* id_card = NULL;
				IdCard* _tmp6_ = NULL;
				gint i = 0;
				gint rules_patterns_index = 0;
				gint rules_always_confirm_index = 0;
				gchar* store_password = NULL;
				gboolean _tmp74_ = FALSE;
				gint _tmp75_ = 0;
				const gchar* _tmp119_ = NULL;
				IdCard* _tmp128_ = NULL;
				gboolean _tmp129_ = FALSE;
				gboolean _tmp130_ = FALSE;
				GeeLinkedList* _tmp135_ = NULL;
				IdCard* _tmp136_ = NULL;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp6_ = id_card_new ();
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				id_card = _tmp6_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				rules_patterns_index = -1;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				rules_always_confirm_index = -1;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				store_password = NULL;
#line 599 "moonshot-keyring-store.c"
				{
					gboolean _tmp7_ = FALSE;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					i = 0;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp7_ = TRUE;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					while (TRUE) {
#line 608 "moonshot-keyring-store.c"
						gint _tmp9_ = 0;
						GnomeKeyringFound* _tmp10_ = NULL;
						GnomeKeyringAttributeList* _tmp11_ = NULL;
						guint _tmp12_ = 0U;
						GnomeKeyringAttribute attribute = {0};
						GnomeKeyringFound* _tmp13_ = NULL;
						GnomeKeyringAttributeList* _tmp14_ = NULL;
						GnomeKeyringAttribute* _tmp15_ = NULL;
						gint _tmp15__length1 = 0;
						gint _tmp16_ = 0;
						GnomeKeyringAttribute _tmp17_ = {0};
						gchar* value = NULL;
						GnomeKeyringAttribute _tmp18_ = {0};
						const gchar* _tmp19_ = NULL;
						gchar* _tmp20_ = NULL;
						GnomeKeyringAttribute _tmp21_ = {0};
						const gchar* _tmp22_ = NULL;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (!_tmp7_) {
#line 628 "moonshot-keyring-store.c"
							gint _tmp8_ = 0;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp8_ = i;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							i = _tmp8_ + 1;
#line 634 "moonshot-keyring-store.c"
						}
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp7_ = FALSE;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp9_ = i;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp10_ = entry;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp11_ = _tmp10_->attributes;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp12_ = _tmp11_->len;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (!(((guint) _tmp9_) < _tmp12_)) {
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							break;
#line 650 "moonshot-keyring-store.c"
						}
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp13_ = entry;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp14_ = _tmp13_->attributes;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp15_ = _tmp14_->data;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp15__length1 = -1;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp16_ = i;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp17_ = ((GnomeKeyringAttribute*) _tmp15_)[_tmp16_];
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						attribute = _tmp17_;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp18_ = attribute;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp19_ = _tmp18_.value.string;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp20_ = g_strdup (_tmp19_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						value = _tmp20_;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp21_ = attribute;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp22_ = _tmp21_.name;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (g_strcmp0 (_tmp22_, "Issuer") == 0) {
#line 680 "moonshot-keyring-store.c"
							IdCard* _tmp23_ = NULL;
							const gchar* _tmp24_ = NULL;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp23_ = id_card;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp24_ = value;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							id_card_set_issuer (_tmp23_, _tmp24_);
#line 689 "moonshot-keyring-store.c"
						} else {
							GnomeKeyringAttribute _tmp25_ = {0};
							const gchar* _tmp26_ = NULL;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp25_ = attribute;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp26_ = _tmp25_.name;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							if (g_strcmp0 (_tmp26_, "Username") == 0) {
#line 699 "moonshot-keyring-store.c"
								IdCard* _tmp27_ = NULL;
								const gchar* _tmp28_ = NULL;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp27_ = id_card;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp28_ = value;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								id_card_set_username (_tmp27_, _tmp28_);
#line 708 "moonshot-keyring-store.c"
							} else {
								GnomeKeyringAttribute _tmp29_ = {0};
								const gchar* _tmp30_ = NULL;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp29_ = attribute;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp30_ = _tmp29_.name;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								if (g_strcmp0 (_tmp30_, "DisplayName") == 0) {
#line 718 "moonshot-keyring-store.c"
									IdCard* _tmp31_ = NULL;
									const gchar* _tmp32_ = NULL;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp31_ = id_card;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp32_ = value;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									id_card_set_display_name (_tmp31_, _tmp32_);
#line 727 "moonshot-keyring-store.c"
								} else {
									GnomeKeyringAttribute _tmp33_ = {0};
									const gchar* _tmp34_ = NULL;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp33_ = attribute;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp34_ = _tmp33_.name;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									if (g_strcmp0 (_tmp34_, "Services") == 0) {
#line 737 "moonshot-keyring-store.c"
										IdCard* _tmp35_ = NULL;
										const gchar* _tmp36_ = NULL;
										gchar** _tmp37_ = NULL;
										gchar** _tmp38_ = NULL;
										gchar** _tmp39_ = NULL;
										gint _tmp39__length1 = 0;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp35_ = id_card;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp36_ = value;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp38_ = _tmp37_ = g_strsplit (_tmp36_, ";", 0);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp39_ = _tmp38_;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp39__length1 = _vala_array_length (_tmp37_);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										id_card_set_services (_tmp35_, _tmp39_, _vala_array_length (_tmp37_));
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
#line 758 "moonshot-keyring-store.c"
									} else {
										GnomeKeyringAttribute _tmp40_ = {0};
										const gchar* _tmp41_ = NULL;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp40_ = attribute;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp41_ = _tmp40_.name;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										if (g_strcmp0 (_tmp41_, "Rules-Pattern") == 0) {
#line 768 "moonshot-keyring-store.c"
											gint _tmp42_ = 0;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											_tmp42_ = i;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											rules_patterns_index = _tmp42_;
#line 774 "moonshot-keyring-store.c"
										} else {
											GnomeKeyringAttribute _tmp43_ = {0};
											const gchar* _tmp44_ = NULL;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											_tmp43_ = attribute;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											_tmp44_ = _tmp43_.name;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											if (g_strcmp0 (_tmp44_, "Rules-AlwaysConfirm") == 0) {
#line 784 "moonshot-keyring-store.c"
												gint _tmp45_ = 0;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												_tmp45_ = i;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												rules_always_confirm_index = _tmp45_;
#line 790 "moonshot-keyring-store.c"
											} else {
												GnomeKeyringAttribute _tmp46_ = {0};
												const gchar* _tmp47_ = NULL;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												_tmp46_ = attribute;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												_tmp47_ = _tmp46_.name;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												if (g_strcmp0 (_tmp47_, "CA-Cert") == 0) {
#line 800 "moonshot-keyring-store.c"
													IdCard* _tmp48_ = NULL;
													TrustAnchor* _tmp49_ = NULL;
													TrustAnchor* _tmp50_ = NULL;
													const gchar* _tmp51_ = NULL;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp48_ = id_card;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp49_ = id_card_get_trust_anchor (_tmp48_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp50_ = _tmp49_;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp51_ = value;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													trust_anchor_set_ca_cert (_tmp50_, _tmp51_);
#line 815 "moonshot-keyring-store.c"
												} else {
													GnomeKeyringAttribute _tmp52_ = {0};
													const gchar* _tmp53_ = NULL;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp52_ = attribute;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp53_ = _tmp52_.name;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													if (g_strcmp0 (_tmp53_, "Server-Cert") == 0) {
#line 825 "moonshot-keyring-store.c"
														IdCard* _tmp54_ = NULL;
														TrustAnchor* _tmp55_ = NULL;
														TrustAnchor* _tmp56_ = NULL;
														const gchar* _tmp57_ = NULL;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp54_ = id_card;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp55_ = id_card_get_trust_anchor (_tmp54_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp56_ = _tmp55_;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp57_ = value;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														trust_anchor_set_server_cert (_tmp56_, _tmp57_);
#line 840 "moonshot-keyring-store.c"
													} else {
														GnomeKeyringAttribute _tmp58_ = {0};
														const gchar* _tmp59_ = NULL;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp58_ = attribute;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp59_ = _tmp58_.name;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														if (g_strcmp0 (_tmp59_, "Subject") == 0) {
#line 850 "moonshot-keyring-store.c"
															IdCard* _tmp60_ = NULL;
															TrustAnchor* _tmp61_ = NULL;
															TrustAnchor* _tmp62_ = NULL;
															const gchar* _tmp63_ = NULL;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp60_ = id_card;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp61_ = id_card_get_trust_anchor (_tmp60_);
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp62_ = _tmp61_;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp63_ = value;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															trust_anchor_set_subject (_tmp62_, _tmp63_);
#line 865 "moonshot-keyring-store.c"
														} else {
															GnomeKeyringAttribute _tmp64_ = {0};
															const gchar* _tmp65_ = NULL;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp64_ = attribute;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp65_ = _tmp64_.name;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															if (g_strcmp0 (_tmp65_, "Subject-Alt") == 0) {
#line 875 "moonshot-keyring-store.c"
																IdCard* _tmp66_ = NULL;
																TrustAnchor* _tmp67_ = NULL;
																TrustAnchor* _tmp68_ = NULL;
																const gchar* _tmp69_ = NULL;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp66_ = id_card;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp67_ = id_card_get_trust_anchor (_tmp66_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp68_ = _tmp67_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp69_ = value;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																trust_anchor_set_subject_alt (_tmp68_, _tmp69_);
#line 890 "moonshot-keyring-store.c"
															} else {
																GnomeKeyringAttribute _tmp70_ = {0};
																const gchar* _tmp71_ = NULL;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp70_ = attribute;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp71_ = _tmp70_.name;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																if (g_strcmp0 (_tmp71_, "StorePassword") == 0) {
#line 900 "moonshot-keyring-store.c"
																	const gchar* _tmp72_ = NULL;
																	gchar* _tmp73_ = NULL;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	_tmp72_ = value;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	_tmp73_ = g_strdup (_tmp72_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	_g_free0 (store_password);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	store_password = _tmp73_;
#line 911 "moonshot-keyring-store.c"
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_g_free0 (value);
#line 925 "moonshot-keyring-store.c"
					}
				}
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp75_ = rules_always_confirm_index;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp75_ != (-1)) {
#line 932 "moonshot-keyring-store.c"
					gint _tmp76_ = 0;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp76_ = rules_patterns_index;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp74_ = _tmp76_ != (-1);
#line 938 "moonshot-keyring-store.c"
				} else {
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp74_ = FALSE;
#line 942 "moonshot-keyring-store.c"
				}
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp74_) {
#line 946 "moonshot-keyring-store.c"
					gchar* rules_patterns_all = NULL;
					GnomeKeyringFound* _tmp77_ = NULL;
					GnomeKeyringAttributeList* _tmp78_ = NULL;
					GnomeKeyringAttribute* _tmp79_ = NULL;
					gint _tmp79__length1 = 0;
					gint _tmp80_ = 0;
					GnomeKeyringAttribute _tmp81_ = {0};
					const gchar* _tmp82_ = NULL;
					gchar* _tmp83_ = NULL;
					gchar* rules_always_confirm_all = NULL;
					GnomeKeyringFound* _tmp84_ = NULL;
					GnomeKeyringAttributeList* _tmp85_ = NULL;
					GnomeKeyringAttribute* _tmp86_ = NULL;
					gint _tmp86__length1 = 0;
					gint _tmp87_ = 0;
					GnomeKeyringAttribute _tmp88_ = {0};
					const gchar* _tmp89_ = NULL;
					gchar* _tmp90_ = NULL;
					gchar** rules_always_confirm = NULL;
					const gchar* _tmp91_ = NULL;
					gchar** _tmp92_ = NULL;
					gchar** _tmp93_ = NULL;
					gint rules_always_confirm_length1 = 0;
					gint _rules_always_confirm_size_ = 0;
					gchar** rules_patterns = NULL;
					const gchar* _tmp94_ = NULL;
					gchar** _tmp95_ = NULL;
					gchar** _tmp96_ = NULL;
					gint rules_patterns_length1 = 0;
					gint _rules_patterns_size_ = 0;
					gchar** _tmp97_ = NULL;
					gint _tmp97__length1 = 0;
					gchar** _tmp98_ = NULL;
					gint _tmp98__length1 = 0;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp77_ = entry;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp78_ = _tmp77_->attributes;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp79_ = _tmp78_->data;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp79__length1 = -1;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp80_ = rules_patterns_index;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp81_ = ((GnomeKeyringAttribute*) _tmp79_)[_tmp80_];
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp82_ = _tmp81_.value.string;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp83_ = g_strdup (_tmp82_);
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_patterns_all = _tmp83_;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp84_ = entry;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp85_ = _tmp84_->attributes;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp86_ = _tmp85_->data;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp86__length1 = -1;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp87_ = rules_always_confirm_index;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp88_ = ((GnomeKeyringAttribute*) _tmp86_)[_tmp87_];
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp89_ = _tmp88_.value.string;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp90_ = g_strdup (_tmp89_);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_always_confirm_all = _tmp90_;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp91_ = rules_always_confirm_all;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp93_ = _tmp92_ = g_strsplit (_tmp91_, ";", 0);
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_always_confirm = _tmp93_;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_always_confirm_length1 = _vala_array_length (_tmp92_);
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_rules_always_confirm_size_ = rules_always_confirm_length1;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp94_ = rules_patterns_all;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp96_ = _tmp95_ = g_strsplit (_tmp94_, ";", 0);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_patterns = _tmp96_;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_patterns_length1 = _vala_array_length (_tmp95_);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_rules_patterns_size_ = rules_patterns_length1;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp97_ = rules_patterns;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp97__length1 = rules_patterns_length1;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp98_ = rules_always_confirm;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp98__length1 = rules_always_confirm_length1;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					if (_tmp97__length1 == _tmp98__length1) {
#line 1047 "moonshot-keyring-store.c"
						Rule* rules = NULL;
						gchar** _tmp99_ = NULL;
						gint _tmp99__length1 = 0;
						Rule* _tmp100_ = NULL;
						gint rules_length1 = 0;
						gint _rules_size_ = 0;
						IdCard* _tmp117_ = NULL;
						Rule* _tmp118_ = NULL;
						gint _tmp118__length1 = 0;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp99_ = rules_patterns;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp99__length1 = rules_patterns_length1;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp100_ = g_new0 (Rule, _tmp99__length1);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						rules = _tmp100_;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						rules_length1 = _tmp99__length1;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_rules_size_ = rules_length1;
#line 1069 "moonshot-keyring-store.c"
						{
							gint j = 0;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							j = 0;
#line 1074 "moonshot-keyring-store.c"
							{
								gboolean _tmp101_ = FALSE;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp101_ = TRUE;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								while (TRUE) {
#line 1081 "moonshot-keyring-store.c"
									gint _tmp103_ = 0;
									gchar** _tmp104_ = NULL;
									gint _tmp104__length1 = 0;
									Rule* _tmp105_ = NULL;
									gint _tmp105__length1 = 0;
									gint _tmp106_ = 0;
									gchar** _tmp107_ = NULL;
									gint _tmp107__length1 = 0;
									gint _tmp108_ = 0;
									const gchar* _tmp109_ = NULL;
									gchar* _tmp110_ = NULL;
									Rule* _tmp111_ = NULL;
									gint _tmp111__length1 = 0;
									gint _tmp112_ = 0;
									gchar** _tmp113_ = NULL;
									gint _tmp113__length1 = 0;
									gint _tmp114_ = 0;
									const gchar* _tmp115_ = NULL;
									gchar* _tmp116_ = NULL;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									if (!_tmp101_) {
#line 1103 "moonshot-keyring-store.c"
										gint _tmp102_ = 0;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp102_ = j;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										j = _tmp102_ + 1;
#line 1109 "moonshot-keyring-store.c"
									}
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp101_ = FALSE;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp103_ = j;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp104_ = rules_patterns;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp104__length1 = rules_patterns_length1;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									if (!(_tmp103_ < _tmp104__length1)) {
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										break;
#line 1123 "moonshot-keyring-store.c"
									}
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp105_ = rules;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp105__length1 = rules_length1;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp106_ = j;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp107_ = rules_patterns;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp107__length1 = rules_patterns_length1;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp108_ = j;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp109_ = _tmp107_[_tmp108_];
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp110_ = g_strdup (_tmp109_);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_g_free0 (_tmp105_[_tmp106_].pattern);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp105_[_tmp106_].pattern = _tmp110_;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp111_ = rules;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp111__length1 = rules_length1;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp112_ = j;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp113_ = rules_always_confirm;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp113__length1 = rules_always_confirm_length1;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp114_ = j;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp115_ = _tmp113_[_tmp114_];
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp116_ = g_strdup (_tmp115_);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_g_free0 (_tmp111_[_tmp112_].always_confirm);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp111_[_tmp112_].always_confirm = _tmp116_;
#line 1165 "moonshot-keyring-store.c"
								}
							}
						}
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp117_ = id_card;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp118_ = rules;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp118__length1 = rules_length1;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						id_card_set_rules (_tmp117_, _tmp118_, _tmp118__length1);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						rules = (_vala_Rule_array_free (rules, rules_length1), NULL);
#line 1179 "moonshot-keyring-store.c"
					}
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_always_confirm = (_vala_array_free (rules_always_confirm, rules_always_confirm_length1, (GDestroyNotify) g_free), NULL);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_g_free0 (rules_always_confirm_all);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_g_free0 (rules_patterns_all);
#line 1189 "moonshot-keyring-store.c"
				}
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp119_ = store_password;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp119_ != NULL) {
#line 1195 "moonshot-keyring-store.c"
					IdCard* _tmp120_ = NULL;
					const gchar* _tmp121_ = NULL;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp120_ = id_card;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp121_ = store_password;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					id_card_set_store_password (_tmp120_, g_strcmp0 (_tmp121_, "yes") == 0);
#line 1204 "moonshot-keyring-store.c"
				} else {
					gboolean _tmp122_ = FALSE;
					GnomeKeyringFound* _tmp123_ = NULL;
					const gchar* _tmp124_ = NULL;
					IdCard* _tmp127_ = NULL;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp123_ = entry;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp124_ = _tmp123_->secret;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					if (_tmp124_ != NULL) {
#line 1216 "moonshot-keyring-store.c"
						GnomeKeyringFound* _tmp125_ = NULL;
						const gchar* _tmp126_ = NULL;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp125_ = entry;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp126_ = _tmp125_->secret;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp122_ = g_strcmp0 (_tmp126_, "") != 0;
#line 1225 "moonshot-keyring-store.c"
					} else {
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp122_ = FALSE;
#line 1229 "moonshot-keyring-store.c"
					}
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp127_ = id_card;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					id_card_set_store_password (_tmp127_, _tmp122_);
#line 1235 "moonshot-keyring-store.c"
				}
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp128_ = id_card;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp129_ = id_card_get_store_password (_tmp128_);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp130_ = _tmp129_;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp130_) {
#line 1245 "moonshot-keyring-store.c"
					IdCard* _tmp131_ = NULL;
					GnomeKeyringFound* _tmp132_ = NULL;
					const gchar* _tmp133_ = NULL;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp131_ = id_card;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp132_ = entry;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp133_ = _tmp132_->secret;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					id_card_set_password (_tmp131_, _tmp133_);
#line 1257 "moonshot-keyring-store.c"
				} else {
					IdCard* _tmp134_ = NULL;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp134_ = id_card;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					id_card_set_password (_tmp134_, NULL);
#line 1264 "moonshot-keyring-store.c"
				}
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp135_ = self->priv->id_card_list;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp136_ = id_card;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp135_, _tmp136_);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_free0 (store_password);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_object_unref0 (id_card);
#line 1276 "moonshot-keyring-store.c"
			}
		}
	}
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	__g_list_free__gnome_keyring_found_free0_0 (items);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_gnome_keyring_attribute_list_free0 (match);
#line 1284 "moonshot-keyring-store.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 964 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 964 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 965 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		separator = "";
#line 1301 "moonshot-keyring-store.c"
	}
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 1311 "moonshot-keyring-store.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 1321 "moonshot-keyring-store.c"
	}
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1327 "moonshot-keyring-store.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == (-1)) {
#line 1338 "moonshot-keyring-store.c"
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 1350 "moonshot-keyring-store.c"
		} else {
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 1354 "moonshot-keyring-store.c"
		}
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 1358 "moonshot-keyring-store.c"
	}
#line 967 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1362 "moonshot-keyring-store.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 969 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 1385 "moonshot-keyring-store.c"
		{
			gboolean _tmp9_ = FALSE;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			i = 0;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1394 "moonshot-keyring-store.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 1407 "moonshot-keyring-store.c"
					gint _tmp10_ = 0;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 1413 "moonshot-keyring-store.c"
				}
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != (-1)) {
#line 1423 "moonshot-keyring-store.c"
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 1435 "moonshot-keyring-store.c"
				} else {
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 1439 "moonshot-keyring-store.c"
				}
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 1445 "moonshot-keyring-store.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == (-1)) {
#line 1456 "moonshot-keyring-store.c"
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 1471 "moonshot-keyring-store.c"
					} else {
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 1475 "moonshot-keyring-store.c"
					}
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 1479 "moonshot-keyring-store.c"
				}
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 970 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					break;
#line 1485 "moonshot-keyring-store.c"
				}
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 1497 "moonshot-keyring-store.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 1518 "moonshot-keyring-store.c"
				} else {
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 1522 "moonshot-keyring-store.c"
				}
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 971 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 1528 "moonshot-keyring-store.c"
			}
		}
#line 973 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 973 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 1535 "moonshot-keyring-store.c"
			gchar* _tmp32_ = NULL;
#line 974 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 974 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 974 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			return result;
#line 1543 "moonshot-keyring-store.c"
		}
#line 976 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 976 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 976 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 977 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 977 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 977 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 977 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 977 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 977 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 979 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 979 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 979 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 980 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 980 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 980 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 980 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 980 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 980 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 1581 "moonshot-keyring-store.c"
		{
			gboolean _tmp46_ = FALSE;
#line 981 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			i = 1;
#line 981 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 981 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1590 "moonshot-keyring-store.c"
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
#line 981 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 1606 "moonshot-keyring-store.c"
					gint _tmp47_ = 0;
#line 981 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 981 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 1612 "moonshot-keyring-store.c"
				}
#line 981 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 981 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 981 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 981 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 981 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 981 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					break;
#line 1626 "moonshot-keyring-store.c"
				}
#line 982 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 982 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 982 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 982 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 1646 "moonshot-keyring-store.c"
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 1661 "moonshot-keyring-store.c"
				} else {
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 1665 "moonshot-keyring-store.c"
				}
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 983 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 1673 "moonshot-keyring-store.c"
			}
		}
#line 986 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 986 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		res = NULL;
#line 986 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 986 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 1684 "moonshot-keyring-store.c"
	} else {
		gchar* _tmp63_ = NULL;
#line 988 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 988 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 988 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 1693 "moonshot-keyring-store.c"
	}
}


void keyring_store_store_id_cards (KeyringStore* self) {
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_if_fail (self != NULL);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_clear_keyring (self);
#line 1703 "moonshot-keyring-store.c"
	{
		GeeLinkedList* _id_card_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _id_card_index = 0;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp0_ = self->priv->id_card_list;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_id_card_list = _tmp1_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp2_ = _id_card_list;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp4_ = _tmp3_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_id_card_size = _tmp4_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_id_card_index = -1;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		while (TRUE) {
#line 1731 "moonshot-keyring-store.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gchar** rules_patterns = NULL;
			IdCard* _tmp11_ = NULL;
			Rule* _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			Rule* _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			gchar** _tmp14_ = NULL;
			gint rules_patterns_length1 = 0;
			gint _rules_patterns_size_ = 0;
			gchar** rules_always_conf = NULL;
			IdCard* _tmp15_ = NULL;
			Rule* _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			Rule* _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			gchar** _tmp18_ = NULL;
			gint rules_always_conf_length1 = 0;
			gint _rules_always_conf_size_ = 0;
			gchar* patterns = NULL;
			gchar** _tmp45_ = NULL;
			gint _tmp45__length1 = 0;
			gchar* _tmp46_ = NULL;
			gchar* always_conf = NULL;
			gchar** _tmp47_ = NULL;
			gint _tmp47__length1 = 0;
			gchar* _tmp48_ = NULL;
			gchar* services = NULL;
			IdCard* _tmp49_ = NULL;
			gchar** _tmp50_ = NULL;
			gint _tmp50__length1 = 0;
			gchar** _tmp51_ = NULL;
			gint _tmp51__length1 = 0;
			gchar* _tmp52_ = NULL;
			GnomeKeyringAttributeList* attributes = NULL;
			GnomeKeyringAttributeList* _tmp53_ = NULL;
			guint32 item_id = 0U;
			GnomeKeyringAttributeList* _tmp54_ = NULL;
			GnomeKeyringAttributeList* _tmp55_ = NULL;
			IdCard* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			GnomeKeyringAttributeList* _tmp59_ = NULL;
			IdCard* _tmp60_ = NULL;
			const gchar* _tmp61_ = NULL;
			const gchar* _tmp62_ = NULL;
			GnomeKeyringAttributeList* _tmp63_ = NULL;
			IdCard* _tmp64_ = NULL;
			const gchar* _tmp65_ = NULL;
			const gchar* _tmp66_ = NULL;
			GnomeKeyringAttributeList* _tmp67_ = NULL;
			const gchar* _tmp68_ = NULL;
			GnomeKeyringAttributeList* _tmp69_ = NULL;
			const gchar* _tmp70_ = NULL;
			GnomeKeyringAttributeList* _tmp71_ = NULL;
			const gchar* _tmp72_ = NULL;
			GnomeKeyringAttributeList* _tmp73_ = NULL;
			IdCard* _tmp74_ = NULL;
			TrustAnchor* _tmp75_ = NULL;
			TrustAnchor* _tmp76_ = NULL;
			const gchar* _tmp77_ = NULL;
			const gchar* _tmp78_ = NULL;
			GnomeKeyringAttributeList* _tmp79_ = NULL;
			IdCard* _tmp80_ = NULL;
			TrustAnchor* _tmp81_ = NULL;
			TrustAnchor* _tmp82_ = NULL;
			const gchar* _tmp83_ = NULL;
			const gchar* _tmp84_ = NULL;
			GnomeKeyringAttributeList* _tmp85_ = NULL;
			IdCard* _tmp86_ = NULL;
			TrustAnchor* _tmp87_ = NULL;
			TrustAnchor* _tmp88_ = NULL;
			const gchar* _tmp89_ = NULL;
			const gchar* _tmp90_ = NULL;
			GnomeKeyringAttributeList* _tmp91_ = NULL;
			IdCard* _tmp92_ = NULL;
			TrustAnchor* _tmp93_ = NULL;
			TrustAnchor* _tmp94_ = NULL;
			const gchar* _tmp95_ = NULL;
			const gchar* _tmp96_ = NULL;
			const gchar* _tmp97_ = NULL;
			IdCard* _tmp98_ = NULL;
			gboolean _tmp99_ = FALSE;
			gboolean _tmp100_ = FALSE;
			GnomeKeyringAttributeList* _tmp101_ = NULL;
			const gchar* _tmp102_ = NULL;
			IdCard* _tmp103_ = NULL;
			gboolean _tmp104_ = FALSE;
			gboolean _tmp105_ = FALSE;
			GnomeKeyringResult _result_ = 0;
			IdCard* _tmp109_ = NULL;
			const gchar* _tmp110_ = NULL;
			const gchar* _tmp111_ = NULL;
			GnomeKeyringAttributeList* _tmp112_ = NULL;
			guint32 _tmp113_ = 0U;
			GnomeKeyringResult _tmp114_ = 0;
			GnomeKeyringResult _tmp115_ = 0;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp5_ = _id_card_index;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_id_card_index = _tmp5_ + 1;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp6_ = _id_card_index;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp7_ = _id_card_size;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				break;
#line 1847 "moonshot-keyring-store.c"
			}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp8_ = _id_card_list;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp9_ = _id_card_index;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			id_card = (IdCard*) _tmp10_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp11_ = id_card;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp12_ = id_card_get_rules (_tmp11_, &_tmp12__length1);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp13_ = _tmp12_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp13__length1 = _tmp12__length1;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp14_ = g_new0 (gchar*, _tmp13__length1 + 1);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_patterns = _tmp14_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_patterns_length1 = _tmp13__length1;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_rules_patterns_size_ = rules_patterns_length1;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp15_ = id_card;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp16_ = id_card_get_rules (_tmp15_, &_tmp16__length1);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp17_ = _tmp16_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp17__length1 = _tmp16__length1;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp18_ = g_new0 (gchar*, _tmp17__length1 + 1);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_always_conf = _tmp18_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_always_conf_length1 = _tmp17__length1;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_rules_always_conf_size_ = rules_always_conf_length1;
#line 1889 "moonshot-keyring-store.c"
			{
				gint i = 0;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				i = 0;
#line 1894 "moonshot-keyring-store.c"
				{
					gboolean _tmp19_ = FALSE;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp19_ = TRUE;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					while (TRUE) {
#line 1901 "moonshot-keyring-store.c"
						gint _tmp21_ = 0;
						IdCard* _tmp22_ = NULL;
						Rule* _tmp23_ = NULL;
						gint _tmp23__length1 = 0;
						Rule* _tmp24_ = NULL;
						gint _tmp24__length1 = 0;
						gchar** _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
						gint _tmp26_ = 0;
						IdCard* _tmp27_ = NULL;
						Rule* _tmp28_ = NULL;
						gint _tmp28__length1 = 0;
						Rule* _tmp29_ = NULL;
						gint _tmp29__length1 = 0;
						gint _tmp30_ = 0;
						Rule _tmp31_ = {0};
						const gchar* _tmp32_ = NULL;
						gchar* _tmp33_ = NULL;
						gchar* _tmp34_ = NULL;
						gchar** _tmp35_ = NULL;
						gint _tmp35__length1 = 0;
						gint _tmp36_ = 0;
						IdCard* _tmp37_ = NULL;
						Rule* _tmp38_ = NULL;
						gint _tmp38__length1 = 0;
						Rule* _tmp39_ = NULL;
						gint _tmp39__length1 = 0;
						gint _tmp40_ = 0;
						Rule _tmp41_ = {0};
						const gchar* _tmp42_ = NULL;
						gchar* _tmp43_ = NULL;
						gchar* _tmp44_ = NULL;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (!_tmp19_) {
#line 1936 "moonshot-keyring-store.c"
							gint _tmp20_ = 0;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp20_ = i;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							i = _tmp20_ + 1;
#line 1942 "moonshot-keyring-store.c"
						}
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp19_ = FALSE;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp21_ = i;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp22_ = id_card;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp23_ = id_card_get_rules (_tmp22_, &_tmp23__length1);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp24_ = _tmp23_;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp24__length1 = _tmp23__length1;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (!(_tmp21_ < _tmp24__length1)) {
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							break;
#line 1960 "moonshot-keyring-store.c"
						}
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp25_ = rules_patterns;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp25__length1 = rules_patterns_length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp26_ = i;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp27_ = id_card;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp28_ = id_card_get_rules (_tmp27_, &_tmp28__length1);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp29_ = _tmp28_;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp29__length1 = _tmp28__length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp30_ = i;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp31_ = _tmp29_[_tmp30_];
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp32_ = _tmp31_.pattern;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp33_ = g_strdup (_tmp32_);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_g_free0 (_tmp25_[_tmp26_]);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp25_[_tmp26_] = _tmp33_;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp34_ = _tmp25_[_tmp26_];
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp35_ = rules_always_conf;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp35__length1 = rules_always_conf_length1;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp36_ = i;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp37_ = id_card;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp38_ = id_card_get_rules (_tmp37_, &_tmp38__length1);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp39_ = _tmp38_;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp39__length1 = _tmp38__length1;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp40_ = i;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp41_ = _tmp39_[_tmp40_];
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp42_ = _tmp41_.always_confirm;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp43_ = g_strdup (_tmp42_);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_g_free0 (_tmp35_[_tmp36_]);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp35_[_tmp36_] = _tmp43_;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp44_ = _tmp35_[_tmp36_];
#line 2018 "moonshot-keyring-store.c"
					}
				}
			}
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp45_ = rules_patterns;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp45__length1 = rules_patterns_length1;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp46_ = _vala_g_strjoinv (";", _tmp45_, _tmp45__length1);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			patterns = _tmp46_;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp47_ = rules_always_conf;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp47__length1 = rules_always_conf_length1;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp48_ = _vala_g_strjoinv (";", _tmp47_, _tmp47__length1);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			always_conf = _tmp48_;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp49_ = id_card;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp50_ = id_card_get_services (_tmp49_, &_tmp50__length1);
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp51_ = _tmp50_;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp51__length1 = _tmp50__length1;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp52_ = _vala_g_strjoinv (";", _tmp51_, _tmp51__length1);
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			services = _tmp52_;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp53_ = gnome_keyring_attribute_list_new ();
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			attributes = _tmp53_;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp54_ = attributes;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp54_, KEYRING_STORE_keyring_store_attribute, KEYRING_STORE_keyring_store_version);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp55_ = attributes;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp56_ = id_card;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp57_ = id_card_get_issuer (_tmp56_);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp58_ = _tmp57_;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp55_, "Issuer", _tmp58_);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp59_ = attributes;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp60_ = id_card;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp61_ = id_card_get_username (_tmp60_);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp62_ = _tmp61_;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp59_, "Username", _tmp62_);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp63_ = attributes;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp64_ = id_card;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp65_ = id_card_get_display_name (_tmp64_);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp66_ = _tmp65_;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp63_, "DisplayName", _tmp66_);
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp67_ = attributes;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp68_ = services;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp67_, "Services", _tmp68_);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp69_ = attributes;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp70_ = patterns;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp69_, "Rules-Pattern", _tmp70_);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp71_ = attributes;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp72_ = always_conf;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp71_, "Rules-AlwaysConfirm", _tmp72_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp73_ = attributes;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp74_ = id_card;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp75_ = id_card_get_trust_anchor (_tmp74_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp76_ = _tmp75_;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp77_ = trust_anchor_get_ca_cert (_tmp76_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp78_ = _tmp77_;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp73_, "CA-Cert", _tmp78_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp79_ = attributes;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp80_ = id_card;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp81_ = id_card_get_trust_anchor (_tmp80_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp82_ = _tmp81_;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp83_ = trust_anchor_get_server_cert (_tmp82_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp84_ = _tmp83_;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp79_, "Server-Cert", _tmp84_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp85_ = attributes;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp86_ = id_card;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp87_ = id_card_get_trust_anchor (_tmp86_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp88_ = _tmp87_;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp89_ = trust_anchor_get_subject (_tmp88_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp90_ = _tmp89_;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp85_, "Subject", _tmp90_);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp91_ = attributes;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp92_ = id_card;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp93_ = id_card_get_trust_anchor (_tmp92_);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp94_ = _tmp93_;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp95_ = trust_anchor_get_subject_alt (_tmp94_);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp96_ = _tmp95_;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp91_, "Subject-Alt", _tmp96_);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp98_ = id_card;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp99_ = id_card_get_store_password (_tmp98_);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp100_ = _tmp99_;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (_tmp100_) {
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp97_ = "yes";
#line 2172 "moonshot-keyring-store.c"
			} else {
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp97_ = "no";
#line 2176 "moonshot-keyring-store.c"
			}
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp101_ = attributes;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp101_, "StorePassword", _tmp97_);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp103_ = id_card;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp104_ = id_card_get_store_password (_tmp103_);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp105_ = _tmp104_;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (_tmp105_) {
#line 2190 "moonshot-keyring-store.c"
				IdCard* _tmp106_ = NULL;
				const gchar* _tmp107_ = NULL;
				const gchar* _tmp108_ = NULL;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp106_ = id_card;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp107_ = id_card_get_password (_tmp106_);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp108_ = _tmp107_;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp102_ = _tmp108_;
#line 2202 "moonshot-keyring-store.c"
			} else {
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp102_ = "";
#line 2206 "moonshot-keyring-store.c"
			}
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp109_ = id_card;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp110_ = id_card_get_display_name (_tmp109_);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp111_ = _tmp110_;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp112_ = attributes;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp114_ = gnome_keyring_item_create_sync (NULL, KEYRING_STORE_item_type, _tmp111_, _tmp112_, _tmp102_, TRUE, &_tmp113_);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			item_id = _tmp113_;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_result_ = _tmp114_;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp115_ = _result_;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (_tmp115_ != GNOME_KEYRING_RESULT_OK) {
#line 2226 "moonshot-keyring-store.c"
				FILE* _tmp116_ = NULL;
				GnomeKeyringResult _tmp117_ = 0;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp116_ = stdout;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp117_ = _result_;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				fprintf (_tmp116_, "GnomeKeyring.item_create_sync() failed. result: %d", (gint) _tmp117_);
#line 2235 "moonshot-keyring-store.c"
			}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_gnome_keyring_attribute_list_free0 (attributes);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_free0 (services);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_free0 (always_conf);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_free0 (patterns);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_always_conf = (_vala_array_free (rules_always_conf, rules_always_conf_length1, (GDestroyNotify) g_free), NULL);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_object_unref0 (id_card);
#line 2251 "moonshot-keyring-store.c"
		}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_g_object_unref0 (_id_card_list);
#line 2255 "moonshot-keyring-store.c"
	}
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_load_id_cards (self);
#line 2259 "moonshot-keyring-store.c"
}


KeyringStore* keyring_store_construct (GType object_type) {
	KeyringStore * self = NULL;
	GeeLinkedList* _tmp0_ = NULL;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) g_object_new (object_type, NULL);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = gee_linked_list_new (TYPE_ID_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_g_object_unref0 (self->priv->id_card_list);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self->priv->id_card_list = _tmp0_;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_load_id_cards (self);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return self;
#line 2278 "moonshot-keyring-store.c"
}


KeyringStore* keyring_store_new (void) {
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return keyring_store_construct (TYPE_KEYRING_STORE);
#line 2285 "moonshot-keyring-store.c"
}


static void keyring_store_class_init (KeyringStoreClass * klass) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_type_class_add_private (klass, sizeof (KeyringStorePrivate));
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	G_OBJECT_CLASS (klass)->finalize = keyring_store_finalize;
#line 2296 "moonshot-keyring-store.c"
}


static void keyring_store_iidentity_card_store_interface_init (IIdentityCardStoreIface * iface) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_iidentity_card_store_parent_iface = g_type_interface_peek_parent (iface);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->add_card = (void (*)(IIdentityCardStore*, IdCard*)) keyring_store_real_add_card;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->update_card = (IdCard* (*)(IIdentityCardStore*, IdCard*)) keyring_store_real_update_card;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->remove_card = (gboolean (*)(IIdentityCardStore*, IdCard*)) keyring_store_real_remove_card;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->get_store_type = (IIdentityCardStoreStoreType (*)(IIdentityCardStore*)) keyring_store_real_get_store_type;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->get_card_list = (GeeLinkedList* (*)(IIdentityCardStore*)) keyring_store_real_get_card_list;
#line 2313 "moonshot-keyring-store.c"
}


static void keyring_store_instance_init (KeyringStore * self) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self->priv = KEYRING_STORE_GET_PRIVATE (self);
#line 2320 "moonshot-keyring-store.c"
}


static void keyring_store_finalize (GObject* obj) {
	KeyringStore * self;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEYRING_STORE, KeyringStore);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_g_object_unref0 (self->priv->id_card_list);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	G_OBJECT_CLASS (keyring_store_parent_class)->finalize (obj);
#line 2332 "moonshot-keyring-store.c"
}


GType keyring_store_get_type (void) {
	static volatile gsize keyring_store_type_id__volatile = 0;
	if (g_once_init_enter (&keyring_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KeyringStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyring_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyringStore), 0, (GInstanceInitFunc) keyring_store_instance_init, NULL };
		static const GInterfaceInfo iidentity_card_store_info = { (GInterfaceInitFunc) keyring_store_iidentity_card_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType keyring_store_type_id;
		keyring_store_type_id = g_type_register_static (G_TYPE_OBJECT, "KeyringStore", &g_define_type_info, 0);
		g_type_add_interface_static (keyring_store_type_id, TYPE_IIDENTITY_CARD_STORE, &iidentity_card_store_info);
		g_once_init_leave (&keyring_store_type_id__volatile, keyring_store_type_id);
	}
	return keyring_store_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



