//
//  testsetseedcommand.cpp
//  Mothur
//
//  Created by Sarah Westcott on 3/24/15.
//  Copyright (c) 2015 Schloss Lab. All rights reserved.
//

#include "catch.hpp"
#include "setseedcommand.h"


TEST_CASE("Testing set.seed command") {
    string optionString = "seed=12345";
    Command* setseed = new SetSeedCommand(optionString);
    
    SECTION("Testing random seed") {
        INFO("Using seed=12345") // Only appears on a FAIL
        
        setseed->execute();
        
        int randValue = rand()%100 + 1;
        
        CHECK(randValue == 25);
    }
    
    delete setseed;
}


