# Hints for creating your own bigint GEM

This example gem, mruby-YOUR-bigint, is available under the Creative Commons Zero License (CC0).

This file is placed for the purpose of describing hints for creating a `mruby-bigint` compatible GEM to realize multiple integers.

The file structure in this example is as follows:

```
+- mruby-YOUR-bigint/   <-  Make this directory public if necessary.
    |                       Change the name of copied directory.
    |
    +- TODO-HINT.md     <-  This file is currently viewing by you.
    |                       Remove this from copied directory.
    |
    +- core/
    |   |
    |   +- bigint.c     <-  Body of the implementation.
    |
    +- mrbgem.rake      <-  GEM name is "mruby-bigint".
                            May be depended on by other GEMs.
```

Implementors of own bigints should copy below this directory to another directory and do the following:

- Rewrite `spec.author`, `spec.license`, `spec.homepage` and `spec.summary` in `<gem-dir>/mrbgem.rake` file to those of your own implementors.
- Implement the respective functions in `<gem-dir>/core/bigint.c`.
  - Define and use an object structure for `MRB_TT_BIGINT` type-tag.
    It is recommended to use `mrb_static_assert_object_size()` to ensure that the size of the object structure is within 6 words.
- Delete this file from the destination of the copy.

If you wish to use it as an alternative to the `mruby-bigint` provided by mruby, please leave the GEM name in `<gem-dir>/mrbgem.rake` as it is.
This is an important factor when it is depended from other GEMs with `spec.add_dependency 'mruby-bigint'`.

The name of the top directory of GEM can be changed arbitrarily.
The name of the git repository can also be changed arbitrarily.

Note that there is no need for an initialization function as there is in normal GEM.
If you need it, create a file `<gem-dir>/src/bigint.c` for example, and implement the `mrb_mruby_bigint_gem_init()` function.
