#nec_structure_currents.py

#header generated by SWIG

import _PyNEC

def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "this"):
        if isinstance(value, class_type):
            self.__dict__[name] = value.this
            if hasattr(value,"thisown"): self.__dict__["thisown"] = value.thisown
            del value.thisown
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name) or (name == "thisown"):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types

#end of the header generated by SWIG



import exceptions

#some utility functions

def _get_iptflg(arg0):
	"""
	Returns the flag which controls the printing of the currents.
	"""
    	return _PyNEC.nec_structure_currents_get_iptflg(arg0)


def _get_iptflq(arg0):
	"""
	Returns the flag which controls the printing of charge densities.
	"""
    	return _PyNEC.nec_structure_currents_get_iptflq(arg0)

	
def _get_n(arg0):
	"""
	Returns the number the wire segments in the geometry.
	"""
    	return _PyNEC.nec_structure_currents_get_n(arg0)

    
def _get_m(arg0):
	"""
	Returns the number of patches in the geometry.
	"""
    	return _PyNEC.nec_structure_currents_get_m(arg0)    



#class "nec_structure_currents"

class nec_structure_currents(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, nec_structure_currents, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, nec_structure_currents, name)
    def __init__(self): raise RuntimeError, "No constructor defined"
    def __repr__(self):
        return "<%s.%s; proxy of C++ nec_structure_currents instance at %s>" % (self.__class__.__module__, self.__class__.__name__, self.this,)
	    
    def get_frequency(*args):
    	"""
	Returns the frequency in Herz.
	"""
    	return _PyNEC.nec_structure_currents_get_frequency(*args)
    
    
    def get_current_output_format(*args):
    	"""
	Returns the output format used for the printing of currents, provided it has been requested.
	"""
    	_iptflg = _get_iptflg(*args)
	if _iptflg != -1:
		if _iptflg == -2 or _iptflg == 0 :
			return 'Standard output format'
		elif _iptflg == 1 or _iptflg == 2 :
			return 'Format designed for a receiving pattern'
		else :
			error_msg = "Unknown output format."
			raise exceptions.Warning(error_msg)
	
    
    def get_current_segment_number(*args) :
    	"""
	Returns the array of segment numbers for the printing of currrents.
	"""
    	if _get_n(*args) != 0 :
		_iptflg = _get_iptflg(*args)
		if _iptflg != -1 :
			return _PyNEC.nec_structure_currents_get_current_segment_number(*args)
		else :
			error_msg = "The printing of currents has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_current_segment_tag(*args):
    	"""
	Returns the array of segment tag numbers for the printing of currents, provided the standard output format has been requested.
	"""
	if _get_n(*args) != 0 :
		_iptflg = _get_iptflg(*args)
		if _iptflg != -1 :
			if _iptflg == -2 or _iptflg == 0 :
				return _PyNEC.nec_structure_currents_get_current_segment_tag(*args)
			else :
				error_msg = "Wrong ouptut format."
				raise exceptions.Warning(error_msg) 
		else :
			error_msg = "The printing of currents has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_current_segment_center_x(*args):
    	"""
	Returns the array of x-coordinate of segment centers in meters for the printing of currents, provided the standard output format has been requested.
	"""
	if _get_n(*args) != 0 :
		_iptflg = _get_iptflg(*args)
		if _iptflg != -1 :
			if _iptflg == -2 or _iptflg == 0 :
				return _PyNEC.nec_structure_currents_get_current_segment_center_x(*args)
			else :
				error_msg = "Wrong ouptut format."
				raise exceptions.Warning(error_msg) 
		else :
			error_msg = "The printing of currents has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_current_segment_center_y(*args):
    	"""
	Returns the array of y-coordinate of segment centers in meters for the printing of currents, provided the standard output format has been requested.
	"""
	if _get_n(*args) != 0 :
		_iptflg = _get_iptflg(*args)
		if _iptflg != -1 :
			if _iptflg == -2 or _iptflg == 0 :
				return _PyNEC.nec_structure_currents_get_current_segment_center_y(*args)
			else :
				error_msg = "Wrong ouptut format."
				raise exceptions.Warning(error_msg)
		else :
			error_msg = "The printing of currents has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_current_segment_center_z(*args):
    	"""
	Returns the array of z-coordinate of segment centers in meters for the printing of currents, provided the standard output format has been requested.
	"""
	if _get_n(*args) != 0 :
		_iptflg = _get_iptflg(*args)
		if _iptflg != -1 :
			if _iptflg == -2 or _iptflg == 0 :
				return _PyNEC.nec_structure_currents_get_current_segment_center_z(*args)
			else :
				error_msg = "Wrong ouptut format."
				raise exceptions.Warning(error_msg)
		else :
			error_msg = "The printing of currents has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_current_segment_length(*args):
    	"""
	Returns the array of segment lengths in meters for the printing of currents, provided the standard output format has been requested.
	"""
    	if _get_n(*args) != 0 :
		_iptflg = _get_iptflg(*args)
		if _iptflg != -1 :
			if _iptflg == -2 or _iptflg == 0 :
				return _PyNEC.nec_structure_currents_get_current_segment_length(*args)
			else :
				error_msg = "Wrong ouptut format."
				raise exceptions.Warning(error_msg)
		else :
			error_msg = "The printing of currents has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)	
	
	
    def get_current_theta(*args):
    	"""
	Returns the array of theta angles in degrees for the printing of currents, provided the format designed for a receiving pattern has been requested.
	"""
    	if _get_n(*args) != 0 :
		_iptflg = _get_iptflg(*args)
		if _iptflg != -1 :
			if _iptflg == 1 or _iptflg == 2 :
				return _PyNEC.nec_structure_currents_get_current_theta(*args)
			else : 
				error_msg = "Wrong ouptut format."
				raise exceptions.Warning(error_msg)	
		else :
			error_msg = "The printing of currents has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_current_phi(*args):
    	"""
	Returns the array of phi angles in degrees for the printing of currents, provided the format designed for a receiving pattern has been requested.
	"""
    	if _get_n(*args) != 0 :
		_iptflg = _get_iptflg(*args)
		if _iptflg != -1 :
			if _iptflg == 1 or _iptflg == 2 :
				return _PyNEC.nec_structure_currents_get_current_phi(*args)
			else : 
				error_msg = "Wrong ouptut format."
				raise exceptions.Warning(error_msg)
		else :
			error_msg = "The printing of currents has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_current(*args):
    	"""
	Returns the array of complex currents in Ampere.
	"""
    	if _get_n(*args) != 0 :
		_iptflg = _get_iptflg(*args)
		if _iptflg != -1 :
			return _PyNEC.nec_structure_currents_get_current(*args)
		else :
			error_msg = "The printing of currents has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)


	
    def get_q_density_segment_number(*args):
    	"""
	Returns the array of segment numbers for the printing of charge densities.
	"""
    	if _get_n(*args) != 0 :
		if _get_iptflq(*args) != -1 :
			return _PyNEC.nec_structure_currents_get_q_density_segment_number(*args)
		else :
			error_msg = "The printing of charge densities has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_q_density_segment_tag(*args):
    	"""
	Returns the array of segment tag numbers for the printing of charge densities.
	"""
    	if _get_n(*args) != 0 :
		if _get_iptflq(*args) != -1 :
			return _PyNEC.nec_structure_currents_get_q_density_segment_tag(*args)
		else :
			error_msg = "The printing of charge densities has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_q_density_segment_center_x(*args):
    	"""
	Returns the array of x-coordinate of segment centers in meters for the printing of charge densities.
	"""
    	if _get_n(*args) != 0 :
		if _get_iptflq(*args) != -1 :
			return _PyNEC.nec_structure_currents_get_q_density_segment_center_x(*args)
		else :
			error_msg = "The printing of charge densities has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_q_density_segment_center_y(*args):
    	"""
	Returns the array of y-coordinate of segment centers in meters for the printing of charge densities.
	"""
	if _get_n(*args) != 0 :
		if _get_iptflq(*args) != -1 :
			return _PyNEC.nec_structure_currents_get_q_density_segment_center_y(*args)
		else :
			error_msg = "The printing of charge densities has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_q_density_segment_center_z(*args):
    	"""
	Returns the array of z-coordinate of segment centers in meters for the printing of charge densities.
	"""
	if _get_n(*args) != 0 :
		if _get_iptflq(*args) != -1 :
			return _PyNEC.nec_structure_currents_get_q_density_segment_center_z(*args)
		else :
			error_msg = "The printing of charge densities has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_q_density_segment_length(*args):
    	"""
	Returns the array of segment lengths in meters for the printing of charge densities.
	"""
	if _get_n(*args) != 0 :
		if _get_iptflq(*args) != -1 :
			return _PyNEC.nec_structure_currents_get_q_density_segment_length(*args)
		else :
			error_msg = "The printing of charge densities has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
    
    
    def get_q_density(*args):
    	"""
	Returns the array of complex charge densities in Coulomb/meter.
	"""
    	if _get_n(*args) != 0 :
		if _get_iptflq(*args) != -1 :
			return _PyNEC.nec_structure_currents_get_q_density(*args)
		else :
			error_msg = "The printing of charge densities has not been requested."
			raise exceptions.Warning(error_msg);
	else :
		error_msg = "There are no wires in the structure."
		raise exceptions.Warning(error_msg)
	
    
    
    def get_patch_number(*args):
    	"""
	Returns the array of patch numbers.
	"""
    	if _get_m(*args) != 0 :
		return _PyNEC.nec_structure_currents_get_patch_number(*args)
	else :
		error_msg = "There are no patches in the structure."
		raise exceptions.Warning(error_msg)
	
	
    def get_patch_center_x(*args):
    	"""
	Returns the array of x-coordinate of patch centers.
	"""
    	if _get_m(*args) != 0 :
		return _PyNEC.nec_structure_currents_get_patch_center_x(*args)
	else :
		error_msg = "There are no patches in the structure."
		raise exceptions.Warning(error_msg)
		
		
    def get_patch_center_y(*args):
    	"""
	Returns the array of y-coordinate of patch centers.
	"""
	if _get_m(*args) != 0 :
		return _PyNEC.nec_structure_currents_get_patch_center_y(*args)
	else :
		error_msg = "There are no patches in the structure."
		raise exceptions.Warning(error_msg)
		
		
    def get_patch_center_z(*args):
    	"""
	Returns the array of z-coordinate of patch centers.
	"""
	if _get_m(*args) != 0 :
		return _PyNEC.nec_structure_currents_get_patch_center_z(*args)
	else :
		error_msg = "There are no patches in the structure."
		raise exceptions.Warning(error_msg)
		
		
    def get_patch_tangent_vector1(*args):
    	"""
	Returns the array of complex tangent vector 1 of the patches.
	"""
    	if _get_m(*args) != 0 :
		return _PyNEC.nec_structure_currents_get_patch_tangent_vector1(*args)
	else :
		error_msg = "There are no patches in the structure."
		raise exceptions.Warning(error_msg)
	
		
    def get_patch_tangent_vector2(*args):
    	"""
	Returns the array of complex tangent vector 2 of the patches.
	"""
    	if _get_m(*args) != 0 :
		return _PyNEC.nec_structure_currents_get_patch_tangent_vector2(*args)
	else :
		error_msg = "There are no patches in the structure."
		raise exceptions.Warning(error_msg)
	
		
    def get_patch_e_x(*args):
    	"""
	Returns the complex x-component of the electric field E.
	"""
    	if _get_m(*args) != 0 :
		return _PyNEC.nec_structure_currents_get_patch_e_x(*args)
	else :
		error_msg = "There are no patches in the structure."
		raise exceptions.Warning(error_msg)
	
		
    def get_patch_e_y(*args):
    	"""
	Returns the complex y-component of the electric field E.
	"""
    	if _get_m(*args) != 0 :
		return _PyNEC.nec_structure_currents_get_patch_e_y(*args)
	else :
		error_msg = "There are no patches in the structure."
		raise exceptions.Warning(error_msg)
	
		
    def get_patch_e_z(*args):
    	"""
	Returns the complex z-component of the electric field E.
	"""
    	if _get_m(*args) != 0 :
		return _PyNEC.nec_structure_currents_get_patch_e_z(*args)
	else :
		error_msg = "There are no patches in the structure."
		raise exceptions.Warning(error_msg)
		
		

class nec_structure_currentsPtr(nec_structure_currents):
    def __init__(self, this):
        _swig_setattr(self, nec_structure_currents, 'this', this)
        if not hasattr(self,"thisown"): _swig_setattr(self, nec_structure_currents, 'thisown', 0)
        _swig_setattr(self, nec_structure_currents,self.__class__,nec_structure_currents)
_PyNEC.nec_structure_currents_swigregister(nec_structure_currentsPtr)
