/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

var randu = require( '@stdlib/random/base/randu' );
var incrpcorr2 = require( './../lib' );

var accumulator;
var r2;
var x;
var y;
var i;

// Initialize an accumulator:
accumulator = incrpcorr2();

// For each simulated datum, update the squared sample Pearson correlation coefficient...
console.log( '\nx\ty\tr^2\n' );
for ( i = 0; i < 100; i++ ) {
	x = randu() * 100.0;
	y = randu() * 100.0;
	r2 = accumulator( x, y );
	console.log( '%d\t%d\t%d', x.toFixed( 4 ), y.toFixed( 4 ), r2.toFixed( 4 ) );
}
console.log( '\nFinal r^2: %d\n', accumulator() );
