/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.security.jaas;

import java.net.PasswordAuthentication;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class JAASUtils {
    public static PasswordAuthentication subjectToDSICredentials(Subject subject) throws LoginException {
        Object ret = null;
        Set<?> creds = null;
        try {
            creds = subject.getPrivateCredentials(Class.forName("java.net.PasswordAuthentication"));
        }
        catch (ClassNotFoundException cnf) {
            throw new LoginException("No credentials: " + cnf.getMessage());
        }
        Iterator<?> it = creds.iterator();
        if (!it.hasNext()) {
            throw new LoginException("No credentials");
        }
        return (PasswordAuthentication)it.next();
    }

    public static void initLoginConfig(Class forcl) throws SecurityException {
        try {
            ClassLoader cl = null;
            if (forcl == null) {
                cl = Thread.currentThread().getContextClassLoader();
                System.setProperty("java.security.auth.login.config", ClassLoader.getSystemResource("jaas.config").toString());
            } else {
                cl = forcl.getClassLoader();
                System.setProperty("java.security.auth.login.config", cl.getResource("jaas.config").toString());
            }
            System.setProperty("java.security.auth.debug", "false");
        }
        catch (NullPointerException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

