#!/bin/bash

################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_DHCPProtocolEndpoint.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_DHCPProtocolEndpoint provider module";
Name = "DHCP_OpenDRIM_DHCPProtocolEndpointModule";
Location = "cmpiDHCP_OpenDRIM_DHCPProtocolEndpointProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_DHCPProtocolEndpoint provider";
Name = "DHCP_OpenDRIM_DHCPProtocolEndpointProvider";
ProviderModuleName = "DHCP_OpenDRIM_DHCPProtocolEndpointModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_DHCPProtocolEndpoint provider capabilities";
ProviderModuleName = "DHCP_OpenDRIM_DHCPProtocolEndpointModule";
ProviderName = "DHCP_OpenDRIM_DHCPProtocolEndpointProvider";
ClassName = "OpenDRIM_DHCPProtocolEndpoint";
ProviderType = {2, 5};
Namespaces = {"$1"};
SupportedProperties = {"InstanceID", "Caption", "ElementName", "InstallDate", "StatusDescriptions", "Status", "HealthState", "CommunicationStatus", "DetailedStatus", "OperatingStatus", "PrimaryStatus", "OtherEnabledState", "RequestedState", "EnabledDefault", "AvailableRequestedStates", "TransitioningToState", "SystemCreationClassName", "SystemName", "CreationClassName", "Name", "Description", "OperationalStatus", "EnabledState", "TimeOfLastStateChange", "NameFormat", "ProtocolType", "ProtocolIFType", "OtherTypeDescription", "ClientState", "RenewalTime", "RebindingTime", "LeaseTime", "LeaseObtained", "LeaseExpires", "OptionsReceived"};
SupportedMethods = {"RequestStateChange"};
CapabilityID = "DHCP_OpenDRIM_DHCPProtocolEndpoint";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_DHCPProtocolEndpoint.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_DHCPProtocolEndpoint]   
   provider: DHCP_OpenDRIM_DHCPProtocolEndpointProvider
   location: cmpiDHCP_OpenDRIM_DHCPProtocolEndpointProvider
   type: instance method
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_DHCPProtocolEndpoint.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_DHCPProtocolEndpoint-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_DHCPProtocolEndpoint.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
