/*
 * Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * <code>BackEnd</code> is an abstract base class for a back-end of compiling
 * Olson's zoneinfo database and generating Java zoneinfo database.
 *
 * @since 1.4
 */
abstract class BackEnd {

    /**
     * Receives each zone's TimeZone information which was created by
     * {@link Zoneinfo#parse} in class <code>Zoneinfo</code>,
     * and processes it.
     *
     * @param tz Timezone object for each zone
     * @return 0 if no error occurred, otherwise 1.
     */
    abstract int processZoneinfo(Timezone tz);

    /**
     * Receives whole information which is generated by JavaZic's front-end
     * in the form of Mapping object and generates all Java zone information
     * files.
     *
     * @param m Mappings object which is generated by
     *          {@link Main#compile() Main.compile()}.
     * @return 0 if no error occurred, otherwise 1.
     */
    abstract int generateSrc(Mappings m);

    /**
     * Decides which backend class should be used and returns its instance.
     * @return an instance of backend class
     */
    static BackEnd getBackEnd() {
        if (Zoneinfo.isYearForTimeZoneDataSpecified) {
            return new Simple();
        } else if (Main.outputDoc) {
            return new GenDoc();
        } else {
            return new Gen();
        }
    }
}
