************************************************************************
* This file is part of OpenMolcas.                                     *
*                                                                      *
* OpenMolcas is free software; you can redistribute it and/or modify   *
* it under the terms of the GNU Lesser General Public License, v. 2.1. *
* OpenMolcas is distributed in the hope that it will be useful, but it *
* is provided "as is" and without any express or implied warranties.   *
* For more details see the full text of the license in the file        *
* LICENSE or in <http://www.gnu.org/licenses/>.                        *
*                                                                      *
* Copyright (C) 2001, Roland Lindh                                     *
*               2001, Laura Gagliardi                                  *
************************************************************************
      Subroutine Lebedev(rPt, wPt,  nPt, nDeg,  lMax   )
************************************************************************
*                                                                      *
* Object: Numerical Gauss integrations over the unit sphere by a rule  *
* with octahedral symmetry.                                            *
*                                                                      *
*                                                                      *
* Called from:                                                         *
*                                                                      *
* Calling    : QEnter                                                  *
*              GetMem                                                  *
*              QExit                                                   *
*                                                                      *
*      Author:Roland Lindh, Department of Chemical Physics, University *
*             of Lund, SWEDEN.                                         *
*             Laura Gagliardi, Dipartimento di Chimica G. Ciamician,   *
*             University of Bologna, ITALY. November 2001              *
*             This has been readapted from the original routine by     *
*             Bernard Delley, Paul Scherrer Institut, Switzerland      *
*             Journal of Computational Chemistry 1996, 17, 1152--1155  *
************************************************************************
      Implicit Real*8 (a-h,o-z)
#include "nq_info.fh"
#include "real.fh"
#include "debug.fh"
#include "WrkSpc.fh"
*
      Integer nscheme5(8),   nscheme7(8), nscheme11(8), nscheme17(8),
     &        nscheme23(8), nscheme29(8), nscheme35(8), nscheme41(8),
     &        nscheme47(8), nscheme53(8), nscheme59(8)
*
      Real*8  rPt(3,nDeg),       wPt(nDeg)
      Real*8  pa5(2), pa7(3), pa11(5), pa17(10), pa23(16), pa35(33),
     &        pa29(24), pa41(44), pa47(56), pa53(70), pa59(85)
*
      data    nscheme5,pa5 /  5,   1,   1,   0,   0,   0,   0,   14,
     &        6.6666666666666667D-02,  7.5000000000000000D-02 /
*
      data    nscheme7,pa7 /  7,   1,   1,   1,   0,   0,   0,   26,
     &        4.7619047619047619D-02,  3.2142857142857143D-02,
     &        3.8095238095238095D-02  /
*
      data    nscheme11,pa11 / 11,   1,   1,   1,   1,   0,   0,  50,
     &  1.2698412698412698D-02,  2.1093750000000000D-02,
     &  2.2574955908289242D-02,  3.0151134457776362D-01,
     &  2.0173335537918871D-02 /
*
      data    nscheme17,pa17 / 17,   1,   1,   0,   3,   1,   0,  110,
     &  3.8282704949371616D-03,  9.7937375124875125D-03,
     &  1.8511563534473617D-01,  8.2117372831911110D-03,
     &  3.9568947305594191D-01,  9.5954713360709628D-03,
     &  6.9042104838229218D-01,  9.9428148911781033D-03,
     &  4.7836902881215020D-01,  9.6949963616630283D-03  /
*
      data    nscheme23,pa23 / 23,   1,   1,   1,   4,   1,   1,  194,
     &  1.7823404472446112D-03,  5.5733831788487380D-03,
     &  5.7169059499771019D-03,  4.4469331787174373D-01,
     &  5.5187714672736137D-03,  2.8924656275754386D-01,
     &  5.1582377118053831D-03,  6.7129734426952263D-01,
     &  5.6087040825879968D-03,  1.2993354476500669D-01,
     &  4.1067770281693941D-03,  3.4577021976112827D-01,
     &  5.0518460646148085D-03,  1.5904171053835295D-01,
     &  5.2511857244364202D-01,  5.5302489162330937D-03  /
*
      data    nscheme29,pa29 /  29,   1,   1,   0,   6,   2,   2,  302,
     &  8.5459117251281481D-04,  3.5991192850255715D-03,
     &  7.0117664160895449D-01,  3.6500458076772554D-03,
     &  6.5663294102196118D-01,  3.6048226014198817D-03,
     &  4.7290541325810046D-01,  3.5767296617433671D-03,
     &  3.5156403455701051D-01,  3.4497884243058833D-03,
     &  2.2196452362941784D-01,  3.1089531224136753D-03,
     &  9.6183085226147838D-02,  2.3521014136891644D-03,
     &  5.7189558918789607D-01,  3.6008209322164603D-03,
     &  2.6441528870606625D-01,  2.9823449631718039D-03,
     &  2.5100347517704651D-01,  5.4486773725807738D-01,
     &  3.5715405542733871D-03,  1.2335485325833274D-01,
     &  4.1277240831685310D-01,  3.3923122050061702D-03  /
      data    nscheme35,pa35 /   35,   1,   1,   1,   7,   2,   4,  434,
     &  5.2658979682244362D-04,  2.5123174189273072D-03,
     &  2.5482199720026072D-03,  6.9093463075091106D-01,
     &  2.5304038011863550D-03,  6.4566647074242561D-01,
     &  2.5132671745975644D-03,  4.9143426377847465D-01,
     &  2.5017251684029361D-03,  3.9272597633680022D-01,
     &  2.4453734373129800D-03,  2.8612890103076384D-01,
     &  2.3026947822274158D-03,  1.7748360546091578D-01,
     &  2.0142790209185282D-03,  7.5680843671780184D-02,
     &  1.4624956215946138D-03,  2.1027252285730696D-01,
     &  1.9109512821795323D-03,  4.7159869115131592D-01,
     &  2.4174423756389808D-03,  9.9217696364292373D-02,
     &  3.3443631453434549D-01,  2.2366077604378487D-03,
     &  2.0548236964030437D-01,  4.5023303825826254D-01,
     &  2.4169300443247753D-03,  3.1042840351665415D-01,
     &  5.5501523610768072D-01,  2.4966440545530860D-03,
     &  1.0680182607580483D-01,  5.9051570489252711D-01,
     &  2.5122368545634951D-03  /
#ifdef _OLDDATA_
      data    nscheme41,pa41 /   41,   1,   1,   0,   8,   4,   6,  590,
     &  1.0090057533787580D-04,  1.8514016873890461D-03,
     &  7.0404760433146996D-01,  1.8686219518306975D-03,
     &  6.8084561988024238D-01,  1.8648696345606001D-03,
     &  6.3723669159418917D-01,  1.8497643975168892D-03,
     &  5.0447558060926046D-01,  1.8450277740822388D-03,
     &  4.2175447334398773D-01,  1.8164174988262214D-03,
     &  3.3201962086729379D-01,  1.7449464690023229D-03,
     &  2.3917494336556047D-01,  1.6278016126848035D-03,
     &  1.4024070738935403D-01,  1.5576827519901693D-03,
     &  9.1616343286052397D-02,  1.2680968886048433D-03,
     &  2.0326292518419433D-01,  1.1183965414769017D-03,
     &  3.9364042372978295D-01,  1.7287035120530033D-03,
     &  6.1262355812929648D-01,  1.8551905629473527D-03,
     &  8.9598759118937909D-02,  2.8114771623428322D-01,
     &  1.4697353123693616D-03,  1.7327600238498666D-01,
     &  3.8175470908581117D-01,  1.6819651914742022D-03,
     &  2.6422260656245780D-01,  4.7452376478986998D-01,
     &  1.7876372876796954D-03,  3.5189965873835832D-01,
     &  5.6127905075920534D-01,  1.8400735685528423D-03,
     &  8.8867910181862953D-02,  5.0324791996964975D-01,
     &  1.8072536817113700D-03,  1.8154345643517542D-01,
     &  5.9768324320748616D-01,  1.8527289739424312D-03  /
#else
c alternate solution 950704 BD
      data nscheme41,pa41 /   41,   1,   1,   0,   9,   3,   6,   590,
     &  3.0951212953061873D-04,  1.8523796985974890D-03,
     &  6.0950341155071959D-02,  9.7643311650510500D-04,
     &  1.4590364491577632D-01,  1.3847372348516919D-03,
     &  2.3847367014218874D-01,  1.6172106472544112D-03,
     &  3.3179207364721231D-01,  1.7495646572811541D-03,
     &  4.2157617840109665D-01,  1.8184717781627688D-03,
     &  5.0444197078003583D-01,  1.8467159561512418D-03,
     &  6.3725469392587524D-01,  1.8520288282962131D-03,
     &  6.8077440664552429D-01,  1.8588125854383170D-03,
     &  7.0409549382274691D-01,  1.8717906392777438D-03,
     &  1.7247820099077235D-01,  1.3003216858860477D-03,
     &  3.9647553481998576D-01,  1.7051539963958640D-03,
     &  6.1168434420098755D-01,  1.8571611967740780D-03,
     &  8.2130215819325114D-02,  2.7786731905862443D-01,
     &  1.5552136033968085D-03,  8.9992058420748749D-02,
     &  5.0335642710751172D-01,  1.8022391280085255D-03,
     &  1.8166408403602095D-01,  5.9841264978853796D-01,
     &  1.8498305604436602D-03,  1.7207952256568781D-01,
     &  3.7910354076955633D-01,  1.7139045071067087D-03,
     &  2.6347166559379496D-01,  4.7423928425519802D-01,
     &  1.8026589343774512D-03,  3.5182809277335190D-01,
     &  5.6102638086220602D-01,  1.8428664729052856D-03  /
#endif
#ifdef _OLDDATA_
      data    nscheme47,pa47 /   47,   1,   1,   1,   9,   4,   9,  770,
     &  1.1685335608691628D-03,  1.4121215930643264D-03,
     &  1.4468645950992776D-03,  1.1441365123336336D-01,
     &  1.0478418864629224D-03,  1.9944675708548970D-01,
     &  1.2392547584848484D-03,  2.8401278368259530D-01,
     &  1.3259295792415379D-03,  3.6646411416548296D-01,
     &  1.3756097758625958D-03,  4.4356118052513995D-01,
     &  1.3999348863558624D-03,  5.1435709575333968D-01,
     &  1.4096221218822673D-03,  6.3052081196671812D-01,
     &  1.4108746499638577D-03,  6.7164784337293865D-01,
     &  1.4134887639034478D-03,  6.9812332010174177D-01,
     &  1.4366946685816802D-03,  1.2047667931264991D-01,
     &  1.0901543574180667D-03,  3.0940302315480606D-01,
     &  1.8691378448038514D-04,  3.4884276430183016D-01,
     &  1.1284267652336505D-03,  5.3224214285417946D-01,
     &  1.3844558026568455D-03,  6.6161599334370030D-02,
     &  2.3249923409267532D-01,  1.1853923885095502D-03,
     &  1.4568618765136356D-01,  3.2477344409682044D-01,
     &  1.2949021664637693D-03,  2.2832839132127622D-01,
     &  4.1056989039349425D-01,  1.3525857420363760D-03,
     &  3.0714431901543855D-01,  4.9213658085114203D-01,
     &  1.3925025908786082D-03,  3.8271180625074657D-01,
     &  5.6548849812588755D-01,  1.4073257894372725D-03,
     &  7.9707151879391904D-02,  4.3713473693946563D-01,
     &  1.3128954307755017D-03,  1.5892620239864833D-01,
     &  5.2320749473197761D-01,  1.3784632898490457D-03,
     &  2.3667220253873893D-01,  6.0283033994386521D-01,
     &  1.4125450609821936D-03,  7.9823288260308803D-02,
     &  6.2037164721742807D-01,  1.4289835314095131D-03  /
#else
c alternate solution 950705 BD
      data nscheme47,pa47 /   47,   1,   1,   1,  10,   3,   9,   770,
     &  2.1929420881811841D-04,  1.4219403443358774D-03,
     &  1.4364336173190798D-03,  5.0872044105023605D-02,
     &  6.7981235110505020D-04,  1.2281987901788307D-01,
     &  9.9131842352949122D-04,  2.0268908144087861D-01,
     &  1.1802078332389488D-03,  2.8477451564642939D-01,
     &  1.2965996020809207D-03,  3.6567190789780265D-01,
     &  1.3658714274283164D-03,  4.4282648867134686D-01,
     &  1.4029886047753253D-03,  5.1406196272497354D-01,
     &  1.4186455635956094D-03,  6.3064012191668026D-01,
     &  1.4213767418516618D-03,  6.7168833320226119D-01,
     &  1.4239964754909616D-03,  6.9797926853368807D-01,
     &  1.4315540421785668D-03,  1.4468656741953093D-01,
     &  9.2544014998653679D-04,  3.3902634754112157D-01,
     &  1.2502399950535093D-03,  5.3358046512635063D-01,
     &  1.3943658433292301D-03,  6.9440243933494130D-02,
     &  2.3551878942423264D-01,  1.1270890946717488D-03,
     &  2.2690041095294599D-01,  4.1021824740457302D-01,
     &  1.3457537609106701D-03,  8.0255746077753389D-02,
     &  6.2143024174816046D-01,  1.4249572833167828D-03,
     &  1.4679995278965720D-01,  3.2452843457173944D-01,
     &  1.2615233412377500D-03,  1.5715077698247271D-01,
     &  5.2244821896966297D-01,  1.3925471060526959D-03,
     &  2.3657029931572456D-01,  6.0175466340895581D-01,
     &  1.4187616778776564D-03,  7.7148158667657320D-02,
     &  4.3465755161411628D-01,  1.3383666844795541D-03,
     &  3.0629366662107302D-01,  4.9088265890376162D-01,
     &  1.3937008626761314D-03,  3.8224773795247870D-01,
     &  5.6487681490995005D-01,  1.4159147574669320D-03  /
#endif
      data    nscheme53,pa53 /   53,   1,   1,   0,  12,   4,  12,  974,
     &  1.4382941905274311D-04,  1.1257722882870041D-03,
     &  4.2929635453413471D-02,  4.9480293419492410D-04,
     &  1.0514268540864042D-01,  7.3579901091254705D-04,
     &  1.7500248676230874D-01,  8.8891327713043843D-04,
     &  2.4776533796502568D-01,  9.8883478389214349D-04,
     &  3.2065671239559574D-01,  1.0532996817094706D-03,
     &  3.9165207498499835D-01,  1.0927788070145785D-03,
     &  4.5908258741876237D-01,  1.1143893940632272D-03,
     &  5.2145638884158605D-01,  1.1237247880515553D-03,
     &  6.2531702446541989D-01,  1.1252393252438136D-03,
     &  6.6379267445231699D-01,  1.1261532718159050D-03,
     &  6.9104103984983007D-01,  1.1302869311238408D-03,
     &  7.0529070074577603D-01,  1.1349865343639549D-03,
     &  1.2366867626579899D-01,  6.8233679271099310D-04,
     &  2.9407771144683870D-01,  9.4541581604470958D-04,
     &  4.6977538492076491D-01,  1.0744299753856791D-03,
     &  6.3345632411395669D-01,  1.1293000865691317D-03,
     &  5.9740486141813418D-02,  2.0291287527775228D-01,
     &  8.4368845009019544D-04,  1.3757604084736365D-01,
     &  4.6026219424840539D-01,  1.0752557204488846D-03,
     &  3.3910165263362857D-01,  5.0306739996620357D-01,
     &  1.1085772368644620D-03,  1.2716751914398195D-01,
     &  2.8176064224421343D-01,  9.5664753237833573D-04,
     &  2.6931207404135125D-01,  4.3315612917201574D-01,
     &  1.0806632507173907D-03,  1.4197864526019183D-01,
     &  6.2561673585808142D-01,  1.1267971311962946D-03,
     &  6.7092846007382550D-02,  3.7983952168591567D-01,
     &  1.0225687153580612D-03,  7.0577381832561723D-02,
     &  5.5175054214235205D-01,  1.1089602677131075D-03,
     &  2.7838884778821546D-01,  6.0296191561591869D-01,
     &  1.1227906534357658D-03,  1.9795789389174069D-01,
     &  3.5896063295890958D-01,  1.0324018471174598D-03,
     &  2.0873070611032740D-01,  5.3486664381354765D-01,
     &  1.1072493822838539D-03,  4.0551221378728359D-01,
     &  5.6749975460743735D-01,  1.1217800485199721D-03  /
      data  nscheme59 /   59,   1,   1,   1,  13,   4,  16, 1202/
      data  (pa59(i),i=1,20) /
     &  1.1051892332675715D-04,  9.1331597864435614D-04,
     &  9.2052327380907415D-04,  3.7126364496570891D-02,
     &  3.6904218980178990D-04,  9.1400604122622234D-02,
     &  5.6039909286806603D-04,  1.5310778524699062D-01,
     &  6.8652976292826086D-04,  2.1809288916606116D-01,
     &  7.7203385511456304D-04,  2.8398745322001746D-01,
     &  8.3015459588947951D-04,  3.4911776009637644D-01,
     &  8.6866925501796284D-04,  4.1214314614443092D-01,
     &  8.9270762858468901D-04,  4.7189936271491266D-01,
     &  9.0608202385682188D-04,  5.2731454528423366D-01/
      data  (pa59(i),i=21,40) /
     &  9.1197772549408672D-04,  6.2094753324440192D-01,
     &  9.1287201386041811D-04,  6.5697227118572905D-01,
     &  9.1307149356917351D-04,  6.8417883090701434D-01,
     &  9.1528737845541164D-04,  7.0126043301236308D-01,
     &  9.1874362743216541D-04,  1.0723822154781661D-01,
     &  5.1769773129656942D-04,  2.5820689594969680D-01,
     &  7.3311436821014169D-04,  4.1727529553067168D-01,
     &  8.4632328363799285D-04,  5.7003669117925033D-01,
     &  9.0311226942539918D-04,  5.2106394770112841D-02,
     &  1.7717740226153253D-01,  6.4857784531632566D-04/
      data  (pa59(i),i=41,60) /
     &  1.1156409571564867D-01,  2.4757164634262876D-01,
     &  7.4350309109823692D-04,  1.7465516775786261D-01,
     &  3.1736152466119767D-01,  8.1017314974680177D-04,
     &  2.3902784793817240D-01,  3.8542911506692237D-01,
     &  8.5562992573118124D-04,  3.0294669735289819D-01,
     &  4.5074225931570644D-01,  8.8502823412654443D-04,
     &  3.6498322605976536D-01,  5.1235184864198708D-01,
     &  9.0226929384269151D-04,  4.2386447815223403D-01,
     &  5.6937024984684411D-01,  9.1057602589701256D-04,
     &  5.9058888532355084D-02,  3.3546162890664885D-01/
      data  (pa59(i),i=61,80) /
     &  7.9985278918390537D-04,  1.2172350510959870D-01,
     &  4.0902684270853572D-01,  8.4833895745943309D-04,
     &  1.8575051945473351D-01,  4.7853206759224352D-01,
     &  8.8110481824257202D-04,  2.4941121623622365D-01,
     &  5.4343035696939004D-01,  9.0100916771050857D-04,
     &  3.1122759471496082D-01,  6.0311616930963100D-01,
     &  9.1078135794827047D-04,  6.2662506241541695D-02,
     &  4.9322211848512846D-01,  8.8032086797382601D-04,
     &  1.2677748006842827D-01,  5.6321230207620997D-01,
     &  9.0213422990406534D-04,  1.9060182227792370D-01/
      data  (pa59(i),i=81,85) /
     &  6.2698055090243917D-01,  9.1315780031894351D-04,
     &  6.4245492242205886D-02,  6.3942796347491023D-01,
     &  9.1580161746934653D-04  /
*
      If (nDeg .le. 0) Then
        Write (6,*) 'Lebedev: nDeg<=0'
        Call Abend()
      End If
clg   Write (6,*) 'lMax =', lMax
*
      If(lMax .le. 5) then
         nPt = nscheme5(8)
         If(nPt .gt.nDeg) then
            nPt = -nPt
         Else
            call AnMesh(   nscheme5,  pa5,   rPt,   wPt)
         Endif
*
      Else If(lMax .le.  7) then
         nPt = nscheme7(8)
         If(nPt .gt.nDeg) then
            nPt = -nPt
         Else
            call AnMesh(   nscheme7,  pa7,   rPt,   wPt)
         Endif
*
      Else If(lMax .le. 11) then
         nPt = nscheme11(8)
         If(nPt .gt.nDeg) then
            nPt = -nPt
         Else
            call AnMesh(   nscheme11,  pa11,   rPt,   wPt)
         Endif
*
      Else If(lMax .le. 17) then
         nPt = nscheme17(8)
         If(nPt .gt.nDeg) then
            nPt = -nPt
         Else
            call AnMesh(   nscheme17,  pa17,   rPt,   wPt)
         Endif
*
      Else If(lMax .le. 23) then
         nPt = nscheme23(8)
clg         write (*,*)  'nPt', nPt
         If(nPt .gt.nDeg) then
            nPt = -nPt
         Else
clg            write (*,*) 'Call AnMesh', nscheme23
            call AnMesh(   nscheme23,  pa23,   rPt,   wPt)
         Endif
*
      Else If(lMax .le. 29) then
         nPt = nscheme29(8)
         If(nPt .gt.nDeg) then
            nPt = -nPt
         Else
            call AnMesh(   nscheme29,  pa29,   rPt,   wPt)
         Endif
*
      Else If(Lmax .le. 35) then
         nPt = nscheme35(8)
         If(nPt .gt.nDeg) then
            nPt = -nPt
         Else
            call AnMesh(   nscheme35,  pa35,   rPt,   wPt)
         Endif
*
      Else If(lMax .le. 41) then
         nPt = nscheme41(8)
         If(nPt .gt.nDeg) then
            nPt = -nPt
         Else
            call AnMesh(   nscheme41,  pa41,   rPt,   wPt)
         Endif
*
      Else If(lMax .le. 47) then
         nPt = nscheme47(8)
         If(nPt .gt.nDeg) then
            nPt = -nPt
         Else
            call AnMesh(   nscheme47,  pa47,   rPt,   wPt)
         Endif
*
      Else If(lMax .le. 53) then
         nPt = nscheme53(8)
         If(nPt .gt.nDeg) then
            nPt = -nPt
         Else
            call AnMesh(   nscheme53,  pa53,   rPt,   wPt)
         Endif
*
      Else If(lMax .le. 59) then
         nPt = nscheme59(8)
         If(nPt .gt.nDeg) then
            nPt = -nPt
         Else
            call AnMesh(   nscheme59,  pa59,   rPt,   wPt)
         Endif
*
      Else
c        such high order is not available here
         nPt = -1
      Endif
*
clg      write (*,*) 'End of Lebedev'
      Return
*
      End
*
*
************************************************************************
      Subroutine AnMesh(  nscheme,    pa,       rPt,   wPt)
      Implicit Real*8 (a-h,o-z)
      Implicit Integer(i-n)
#include "nq_info.fh"
#include "real.fh"
#include "debug.fh"
#include "WrkSpc.fh"
      Integer nscheme(8)
      Real*8  pa(*),    rPt(3,*),    wPt(*)
************************************************************************
*                                                                      *
*
         If (Debug) Then
        Write (6,*)
        Write (6,*) ' ******** The Angular Lebedev Grid ********'
        Write (6,*)
        Write (6,*)
         End If
*
      i = 0
      ip = 0
*
*     nscheme(2) -> 6 points
*
clg      write (*,*) 'nscheme',  (nscheme(i), i=1,8)
      If(nscheme(2) .gt. 0) Then
clg          write (*,*) 'nscheme(2)', nscheme(2)
         ip = ip + 1
         Do ix=1,3
            Do iy=1,-1,-2
               i = i + 1
               wPt(i) = pa(ip)
               Do j=1,3
                  rPt(j,i) = Zero
               Enddo
               rPt(ix,i) = DBLE(iy)
clg              write (*,*) rPt(ix,i), wPt(i)
            Enddo
         Enddo
      Endif
*
*     nscheme(3) -> 8 points
*
      If(nscheme(3) .gt. 0) Then   !
         c = One/sqrt(Three)
         ip = ip + 1
         Do ix=1,-1,-2
            Do iy=1,-1,-2
               Do iz=1,-1,-2
                  i = i + 1
                  wPt(i) = pa(ip)
                  rPt(1,i) = DBLE(ix)*c
                  rPt(2,i) = DBLE(iy)*c
                  rPt(3,i) = DBLE(iz)*c
               Enddo
            Enddo
         Enddo
      Endif
*
*      nscheme(4) -> 12 points
*
      If(nscheme(4) .gt. 0) Then
         c = One/sqrt(Two)
         ip = ip + 1
         Do ix=1,-1,-2
            Do iy=1,-1,-2
               Do iz=1,3
                  i = i + 1
                  wPt(i) = pa(ip)
                  rPt(iz,i) = DBLE(ix)*c
                  j = mod(iz,3) + 1
                  rPt(j,i) = DBLE(iy)*c
                  j = 6 - iz - j
                  rPt(j,i) = Zero
               Enddo
            Enddo
         Enddo
      endif
*
*     24a points
*
      n1 = nscheme(5)
      Do jj=1,n1
         ip = ip + 1
         uu = pa(ip)
         vv = sqrt(One - Two*uu*uu)
         ip = ip + 1
         Do ix=1,-1,-2
            Do iy=1,-1,-2
               Do iz=1,-1,-2
                  Do j=1,3
                     i = i + 1
                     wPt(i) = pa(ip)
                     Do j1=1,3
                        rPt(j1,i) = uu
                     Enddo
                     rPt(j,i) = vv
                     rPt(1,i) = rPt(1,i)*DBLE(ix)
                     rPt(2,i) = rPt(2,i)*DBLE(iy)
                     rPt(3,i) = rPt(3,i)*DBLE(iz)
                  Enddo
               Enddo
            Enddo
         Enddo
      Enddo
*
*     24b points
*
      n1 = nscheme(6)
      Do jj=1,n1
         ip = ip + 1
         pp = pa(ip)
         qq = sqrt(One - pp*pp)
         ip = ip + 1
         Do ix=1,-1,-2
            Do iy=1,-1,-2
               Do ii=0,1
                  Do j=1,3
                     i = i + 1
                     wPt(i) = pa(ip)
                     j1 = mod(j+ii,3)+1
                     rPt(j1,i) = pp*DBLE(ix)
                     j1 = mod(j+1-ii,3) + 1
                     rPt(j1,i) = qq*DBLE(iy)
                     rPt(j,i) = zero
                  Enddo
               Enddo
            Enddo
         Enddo
      Enddo
*
*     48 points
*
      n1 = nscheme(7)
clg      write (*,*) 'i, n1 =', i, n1
      Do jj=1,n1
         ip = ip + 1
         rr = pa(ip)
         ip = ip + 1
         ss = pa(ip)
         tt = sqrt(One - rr*rr - ss*ss)
         ip = ip + 1
         Do ix=1,-1,-2
            Do iy=1,-1,-2
               Do iz=1,-1,-2
                  Do j=1,3
                     Do ii=0,1
                        i = i + 1
                        wPt(i) = pa(ip)
                        rPt(j,i) = rr*DBLE(ix)
                        j1 = mod(j+ii,3) + 1
                        rPt(j1,i) = ss*DBLE(iy)
                        j1 = mod(j+1-ii,3) + 1
                        rPt(j1,i) = tt*DBLE(iz)
clg                        write (*,*) rPt(j1,i), wPt(i),j1,i
                     Enddo
clg      write (*,*) 'Enddo1', i
                  Enddo
clg      write (*,*) 'Enddo2', i
               Enddo
clg      write (*,*) 'Enddo3', i
            Enddo
clg      write (*,*) 'Enddo4', i
         Enddo
clg      write (*,*) 'Enddo5', i
      Enddo
clg                        write (*,*) 'enddo', n1
*                                                                      *
************************************************************************
*                                                                      *
*
clg       write (*,*) 'End of AnMesh'
      Return
      End
