# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 787-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55167);
 script_cve_id("CVE-2005-1855", "CVE-2005-1856");
 script_version ("$");
 script_tag(name:"cvss_base", value:"2.1");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 787-1 (backup manager)";
 script_name(name);

 desc = "The remote host is missing an update to backup manager
announced via advisory DSA 787-1.

Two bugs have been found in backup-manager, a command-line driven
backup utility.  The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2005-1855
Jeroen Vermeulen discovered that backup files are created with
default permissions making them world readable, even though they
may contain sensitive information.

CVE-2005-1856
Sven Joachim discovered that the optional CD-burning feature of
backup-manager uses a hardcoded filename in a world-writable
directory for logging.  This can be subject to a symlink attack.

The old stable distribution (woody) does not provide the
backup-manager package.

For the stable distribution (sarge) these problems have been fixed in
version 0.5.7-1sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 0.5.8-2.

We recommend that you upgrade your backup-manager package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20787-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 787-1 (backup manager)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"backup-manager", ver:"0.5.7-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
