###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_itunes_pls_file_bof_vuln_oct09.nasl 5062 2009-10-01 20:13:12Z oct $
#
# Apple iTunes '.pls' Files Buffer Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801105);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-2817");
  script_bugtraq_id(36478);
  script_name("Apple iTunes '.pls' Files Buffer Overflow Vulnerability");
  desc = "
  Overview: This host has Apple iTunes installed, which is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  The flaw exists in the handling of specially crafted '.pls' files. It fails
  to bounds-check user-supplied data before copying it into an insufficiently
  sized buffer.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary code within
  the context of the affected application, failed exploit attempts will result in
  a denial of service condition.

  Impact Level: Application

  Affected Software/OS:
  Apple iTunes version prior to 9.0.1 on Windows.

  Fix: Upgrade to Apple iTunes Version 9.0.1
  http://www.apple.com/itunes/download

  References:
  http://support.apple.com/kb/HT3884
  http://lists.apple.com/archives/security-announce/2009/Sep/msg00006.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Apple iTunes");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_apple_itunes_detection_win_900123.nasl");
  script_require_keys("iTunes/Win/Ver");
  exit(0);
}


include("version_func.inc");

itunesVer = get_kb_item("iTunes/Win/Ver");
if(!itunesVer){
  exit(0);
}

# Check for iTunes version prior to 9.0.1 (9.0.1.8)
if(version_is_less(version:itunesVer, test_version:"9.0.1.8")){
  security_hole(0);
}
