###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for perl FEDORA-2008-11736
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860966);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-11736");
  script_cve_id("CVE-2007-4829");
  script_name( "Fedora Update for perl FEDORA-2008-11736");
  desc = "

  Vulnerability Insight:
  Perl is a high-level programming language with roots in C, sed, awk
  and shell scripting.  Perl is good at handling processes and files,
  and is especially good at handling text.  Perl's hallmarks are
  practicality and efficiency.  While it is used to do a lot of
  different things, Perl's most common applications are system
  administration utilities and web programming.  A large proportion of
  the CGI scripts on the web are written in Perl.  You need the perl
  package installed on your system so that your system can handle Perl
  scripts.
  
  Install this package if you want to program in Perl or enable your
  system to handle Perl scripts.


  Affected Software/OS:
  perl on Fedora 10

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-December/msg01410.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of perl");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC10")
{

  if(isrpmvuln(pkg:"perl", rpm:"perl~5.10.0~52.fc10", rls:"FC10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}