###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_realplayer_ivr_mult_vuln.nasl 996 2009-02-10 10:45:02Z feb $
#
# RealPlayer IVR Multiple Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800509);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0375", "CVE-2009-0376");
  script_bugtraq_id(33652);
  script_name("RealPlayer IVR Multiple Vulnerabilities");
  desc = "

  Overview: This host is running RealPlayer which is prone to IVR multiple
  vulnerabilities.

  Vulnerability Insight:
  - Memory corruption while the application processes crafted arbitrary
    'IVR' file.
  - A vulnerability that allows an attacker to write one null byte to an
    arbitrary memory address by using an overly long file name length value.

  Impact: Successful exploitation will let the attacker execute arbitrary
  codes within the context of the application and can cause heap overflow
  or cause remote code execution to the application.

  Affected Software/OS:
  RealPlayer 11.0.0.477 and prior on all Windows platforms.

  Fix: No solution or patch is available as on 18th February, 2009.Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.real.com/player

  References:
  http://en.securitylab.ru/nvd/367866.php
  http://en.securitylab.ru/nvd/367867.php
  http://www.fortiguardcenter.com/advisory/FGA-2009-04.html
  http://www.securityfocus.com/archive/1/archive/1/500722/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.9
  Risk factor: High ";

  script_description(desc);
  script_summary("Check for the version of RealPlayer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_realplayer_detect_win.nasl");
  script_require_keys("RealPlayer/Win/Ver");
  exit(0);
}


include("version_func.inc");

rpVer = get_kb_item("RealPlayer/Win/Ver");
if(rpVer == NULL){
  exit(0);
}

if(version_is_less_equal(version:rpVer, test_version:"11.0.0.477")){
  security_hole(0);
}
