//=======================================================================
// pkgset.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "gconfig.h"
#include "pkg.h"
#include "pkgset.h"
#include "util.h"

using namespace Gpaco;


PkgSet::PkgSet()
:
	mSizeInst(0)
{
	try {
		Glib::Dir dir(GConfig::logdir());
		for (Glib::Dir::iterator d = dir.begin(); d != dir.end(); ++d) {
			try {
				*this += new Pkg(*d);
			}
			catch (Paco::X& x) {
				errorDialog(NULL, x.what(), true);
			}
			catch (...) { }
		}
	}
	catch (Glib::Error& x) {
		errorDialog(NULL, x.what(), true);
	}
}


PkgSet::~PkgSet()
{
	for (iterator p = begin(); p != end(); ++p) {
		g_assert(*p != NULL);
		if (*p) {
			delete *p;
			*p = NULL;
		}
	}
}


bool PkgSet::hasPkg(std::string const& pkgName)
{
	for (iterator p = begin(); p != end(); ++p) {
		if ((*p)->name() == pkgName)
			return true;
	}
	return false;
}


PkgSet& PkgSet::operator+=(Pkg* pkg)
{
	g_assert(pkg != NULL);
	push_back(pkg);
	mSizeInst += pkg->sizeInst();
	return *this;
}


PkgSet& PkgSet::operator-=(Pkg* pkg)
{
	g_assert(pkg != NULL);
	iterator i = std::remove(begin(), end(), pkg);
	if (i != end()) {
		mSizeInst -= pkg->sizeInst();
		delete pkg;
		pkg = NULL;
		erase(i, end());
	}
	return *this;
}

