/* engine.c generated by valac 0.16.0, the Vala compiler
 * generated from engine.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define PDFPC_RENDERER_CACHE_TYPE_BASE (pdfpc_renderer_cache_base_get_type ())
#define PDFPC_RENDERER_CACHE_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_CACHE_TYPE_BASE, pdfpcRendererCacheBase))
#define PDFPC_RENDERER_CACHE_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_CACHE_TYPE_BASE, pdfpcRendererCacheBaseClass))
#define PDFPC_RENDERER_CACHE_IS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_CACHE_TYPE_BASE))
#define PDFPC_RENDERER_CACHE_IS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_CACHE_TYPE_BASE))
#define PDFPC_RENDERER_CACHE_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_CACHE_TYPE_BASE, pdfpcRendererCacheBaseClass))

typedef struct _pdfpcRendererCacheBase pdfpcRendererCacheBase;
typedef struct _pdfpcRendererCacheBaseClass pdfpcRendererCacheBaseClass;
typedef struct _pdfpcRendererCacheBasePrivate pdfpcRendererCacheBasePrivate;

#define PDFPC_METADATA_TYPE_BASE (pdfpc_metadata_base_get_type ())
#define PDFPC_METADATA_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_METADATA_TYPE_BASE, pdfpcMetadataBase))
#define PDFPC_METADATA_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_METADATA_TYPE_BASE, pdfpcMetadataBaseClass))
#define PDFPC_METADATA_IS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_METADATA_TYPE_BASE))
#define PDFPC_METADATA_IS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_METADATA_TYPE_BASE))
#define PDFPC_METADATA_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_METADATA_TYPE_BASE, pdfpcMetadataBaseClass))

typedef struct _pdfpcMetadataBase pdfpcMetadataBase;
typedef struct _pdfpcMetadataBaseClass pdfpcMetadataBaseClass;

#define PDFPC_RENDERER_CACHE_PNG_TYPE_ENGINE (pdfpc_renderer_cache_png_engine_get_type ())
#define PDFPC_RENDERER_CACHE_PNG_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_CACHE_PNG_TYPE_ENGINE, pdfpcRendererCachePNGEngine))
#define PDFPC_RENDERER_CACHE_PNG_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_CACHE_PNG_TYPE_ENGINE, pdfpcRendererCachePNGEngineClass))
#define PDFPC_RENDERER_CACHE_PNG_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_CACHE_PNG_TYPE_ENGINE))
#define PDFPC_RENDERER_CACHE_PNG_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_CACHE_PNG_TYPE_ENGINE))
#define PDFPC_RENDERER_CACHE_PNG_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_CACHE_PNG_TYPE_ENGINE, pdfpcRendererCachePNGEngineClass))

typedef struct _pdfpcRendererCachePNGEngine pdfpcRendererCachePNGEngine;
typedef struct _pdfpcRendererCachePNGEngineClass pdfpcRendererCachePNGEngineClass;
typedef struct _pdfpcRendererCachePNGEnginePrivate pdfpcRendererCachePNGEnginePrivate;

#define PDFPC_RENDERER_CACHE_PNG_TYPE_ITEM (pdfpc_renderer_cache_png_item_get_type ())
#define PDFPC_RENDERER_CACHE_PNG_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_CACHE_PNG_TYPE_ITEM, pdfpcRendererCachePNGItem))
#define PDFPC_RENDERER_CACHE_PNG_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_CACHE_PNG_TYPE_ITEM, pdfpcRendererCachePNGItemClass))
#define PDFPC_RENDERER_CACHE_PNG_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_CACHE_PNG_TYPE_ITEM))
#define PDFPC_RENDERER_CACHE_PNG_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_CACHE_PNG_TYPE_ITEM))
#define PDFPC_RENDERER_CACHE_PNG_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_CACHE_PNG_TYPE_ITEM, pdfpcRendererCachePNGItemClass))

typedef struct _pdfpcRendererCachePNGItem pdfpcRendererCachePNGItem;
typedef struct _pdfpcRendererCachePNGItemClass pdfpcRendererCachePNGItemClass;
#define _g_mutex_free0(var) ((var == NULL) ? NULL : (var = (g_mutex_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _pdfpcRendererCacheBase {
	GObject parent_instance;
	pdfpcRendererCacheBasePrivate * priv;
	pdfpcMetadataBase* metadata;
};

struct _pdfpcRendererCacheBaseClass {
	GObjectClass parent_class;
	void (*store) (pdfpcRendererCacheBase* self, guint index, GdkPixmap* pixmap);
	GdkPixmap* (*retrieve) (pdfpcRendererCacheBase* self, guint index);
};

struct _pdfpcRendererCachePNGEngine {
	pdfpcRendererCacheBase parent_instance;
	pdfpcRendererCachePNGEnginePrivate * priv;
	pdfpcRendererCachePNGItem** storage;
	gint storage_length1;
	GMutex* mutex;
};

struct _pdfpcRendererCachePNGEngineClass {
	pdfpcRendererCacheBaseClass parent_class;
};


static gpointer pdfpc_renderer_cache_png_engine_parent_class = NULL;

GType pdfpc_renderer_cache_base_get_type (void) G_GNUC_CONST;
GType pdfpc_metadata_base_get_type (void) G_GNUC_CONST;
GType pdfpc_renderer_cache_png_engine_get_type (void) G_GNUC_CONST;
GType pdfpc_renderer_cache_png_item_get_type (void) G_GNUC_CONST;
enum  {
	PDFPC_RENDERER_CACHE_PNG_ENGINE_DUMMY_PROPERTY
};
pdfpcRendererCachePNGEngine* pdfpc_renderer_cache_png_engine_new (pdfpcMetadataBase* metadata);
pdfpcRendererCachePNGEngine* pdfpc_renderer_cache_png_engine_construct (GType object_type, pdfpcMetadataBase* metadata);
pdfpcRendererCacheBase* pdfpc_renderer_cache_base_construct (GType object_type, pdfpcMetadataBase* metadata);
guint pdfpc_metadata_base_get_slide_count (pdfpcMetadataBase* self);
static void pdfpc_renderer_cache_png_engine_real_store (pdfpcRendererCacheBase* base, guint index, GdkPixmap* pixmap);
pdfpcRendererCachePNGItem* pdfpc_renderer_cache_png_item_new (guint8* data, int data_length1);
pdfpcRendererCachePNGItem* pdfpc_renderer_cache_png_item_construct (GType object_type, guint8* data, int data_length1);
static GdkPixmap* pdfpc_renderer_cache_png_engine_real_retrieve (pdfpcRendererCacheBase* base, guint index);
guint8* pdfpc_renderer_cache_png_item_get_png_data (pdfpcRendererCachePNGItem* self, int* result_length1);
static void pdfpc_renderer_cache_png_engine_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
         * Initialize the cache store
         */
pdfpcRendererCachePNGEngine* pdfpc_renderer_cache_png_engine_construct (GType object_type, pdfpcMetadataBase* metadata) {
	pdfpcRendererCachePNGEngine * self = NULL;
	pdfpcMetadataBase* _tmp0_;
	GMutex* _tmp1_;
	pdfpcMetadataBase* _tmp2_;
	guint _tmp3_ = 0U;
	pdfpcRendererCachePNGItem** _tmp4_ = NULL;
	GMutex* _tmp5_;
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = metadata;
	self = (pdfpcRendererCachePNGEngine*) pdfpc_renderer_cache_base_construct (object_type, _tmp0_);
	_tmp1_ = self->mutex;
	g_mutex_lock (_tmp1_);
	_tmp2_ = ((pdfpcRendererCacheBase*) self)->metadata;
	_tmp3_ = pdfpc_metadata_base_get_slide_count (_tmp2_);
	_tmp4_ = g_new0 (pdfpcRendererCachePNGItem*, _tmp3_ + 1);
	self->storage = (_vala_array_free (self->storage, self->storage_length1, (GDestroyNotify) g_object_unref), NULL);
	self->storage = _tmp4_;
	self->storage_length1 = _tmp3_;
	_tmp5_ = self->mutex;
	g_mutex_unlock (_tmp5_);
	return self;
}


pdfpcRendererCachePNGEngine* pdfpc_renderer_cache_png_engine_new (pdfpcMetadataBase* metadata) {
	return pdfpc_renderer_cache_png_engine_construct (PDFPC_RENDERER_CACHE_PNG_TYPE_ENGINE, metadata);
}


/**
         * Store a pixmap in the cache using the given index as identifier
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void pdfpc_renderer_cache_png_engine_real_store (pdfpcRendererCacheBase* base, guint index, GdkPixmap* pixmap) {
	pdfpcRendererCachePNGEngine * self;
	gint pixmap_width = 0;
	gint pixmap_height = 0;
	GdkPixmap* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* pixbuf;
	GdkPixmap* _tmp4_;
	guint8* buffer = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	pdfpcRendererCachePNGItem* _tmp9_;
	pdfpcRendererCachePNGItem* item;
	GMutex* _tmp10_;
	pdfpcRendererCachePNGItem** _tmp11_;
	gint _tmp11__length1;
	guint _tmp12_;
	pdfpcRendererCachePNGItem* _tmp13_;
	pdfpcRendererCachePNGItem* _tmp14_;
	GMutex* _tmp15_;
	GError * _inner_error_ = NULL;
	self = (pdfpcRendererCachePNGEngine*) base;
	g_return_if_fail (pixmap != NULL);
	_tmp0_ = pixmap;
	gdk_drawable_get_size ((GdkDrawable*) _tmp0_, &_tmp1_, &_tmp2_);
	pixmap_width = _tmp1_;
	pixmap_height = _tmp2_;
	_tmp3_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, pixmap_width, pixmap_height);
	pixbuf = _tmp3_;
	_tmp4_ = pixmap;
	gdk_pixbuf_get_from_drawable (pixbuf, (GdkDrawable*) _tmp4_, NULL, 0, 0, 0, 0, pixmap_width, pixmap_height);
	{
		guint8* _tmp5_ = NULL;
		gsize _tmp6_;
		gdk_pixbuf_save_to_buffer (pixbuf, (gchar**) (&_tmp5_), &_tmp6_, "png", &_inner_error_, "compression", "1", NULL, NULL);
		buffer = (g_free (buffer), NULL);
		buffer = _tmp5_;
		buffer_length1 = _tmp6_;
		_buffer_size_ = buffer_length1;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		guint _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = index;
		_tmp8_ = e->message;
		g_error ("engine.vala:92: Could not generate PNG cache image for slide %u: %s", _tmp7_, _tmp8_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		buffer = (g_free (buffer), NULL);
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = pdfpc_renderer_cache_png_item_new (buffer, buffer_length1);
	item = _tmp9_;
	_tmp10_ = self->mutex;
	g_mutex_lock (_tmp10_);
	_tmp11_ = self->storage;
	_tmp11__length1 = self->storage_length1;
	_tmp12_ = index;
	_tmp13_ = _g_object_ref0 (item);
	_g_object_unref0 (_tmp11_[_tmp12_]);
	_tmp11_[_tmp12_] = _tmp13_;
	_tmp14_ = _tmp11_[_tmp12_];
	_tmp15_ = self->mutex;
	g_mutex_unlock (_tmp15_);
	_g_object_unref0 (item);
	buffer = (g_free (buffer), NULL);
	_g_object_unref0 (pixbuf);
}


/**
         * Retrieve a stored pixmap from the cache.
         *
         * If no item with the given index is available null is returned
         */
static GdkPixmap* pdfpc_renderer_cache_png_engine_real_retrieve (pdfpcRendererCacheBase* base, guint index) {
	pdfpcRendererCachePNGEngine * self;
	GdkPixmap* result = NULL;
	pdfpcRendererCachePNGItem** _tmp0_;
	gint _tmp0__length1;
	guint _tmp1_;
	pdfpcRendererCachePNGItem* _tmp2_;
	pdfpcRendererCachePNGItem* _tmp3_;
	pdfpcRendererCachePNGItem* item;
	pdfpcRendererCachePNGItem* _tmp4_;
	GdkPixbufLoader* _tmp5_;
	GdkPixbufLoader* loader;
	GdkPixbufLoader* _tmp14_;
	GdkPixbuf* _tmp15_ = NULL;
	GdkPixbuf* _tmp16_;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp17_;
	gint _tmp18_ = 0;
	GdkPixbuf* _tmp19_;
	gint _tmp20_ = 0;
	GdkPixmap* _tmp21_;
	GdkPixmap* pixmap;
	GdkPixmap* _tmp22_;
	cairo_t* _tmp23_ = NULL;
	cairo_t* cr;
	cairo_t* _tmp24_;
	GdkPixbuf* _tmp25_;
	cairo_t* _tmp26_;
	GdkPixbuf* _tmp27_;
	gint _tmp28_ = 0;
	GdkPixbuf* _tmp29_;
	gint _tmp30_ = 0;
	cairo_t* _tmp31_;
	GError * _inner_error_ = NULL;
	self = (pdfpcRendererCachePNGEngine*) base;
	_tmp0_ = self->storage;
	_tmp0__length1 = self->storage_length1;
	_tmp1_ = index;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp3_ = _g_object_ref0 (_tmp2_);
	item = _tmp3_;
	_tmp4_ = item;
	if (_tmp4_ == NULL) {
		result = NULL;
		_g_object_unref0 (item);
		return result;
	}
	_tmp5_ = gdk_pixbuf_loader_new ();
	loader = _tmp5_;
	{
		GdkPixbufLoader* _tmp6_;
		pdfpcRendererCachePNGItem* _tmp7_;
		gint _tmp8_ = 0;
		guint8* _tmp9_ = NULL;
		guint8* _tmp10_;
		gint _tmp10__length1;
		GdkPixbufLoader* _tmp11_;
		_tmp6_ = loader;
		_tmp7_ = item;
		_tmp9_ = pdfpc_renderer_cache_png_item_get_png_data (_tmp7_, &_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp10__length1 = _tmp8_;
		gdk_pixbuf_loader_write (_tmp6_, _tmp10_, (gsize) _tmp8_, &_inner_error_);
		_tmp10_ = (g_free (_tmp10_), NULL);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp11_ = loader;
		gdk_pixbuf_loader_close (_tmp11_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		guint _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = index;
		_tmp13_ = e->message;
		g_error ("engine.vala:119: Could not load cached PNG image for slide %u: %s", _tmp12_, _tmp13_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (loader);
		_g_object_unref0 (item);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp14_ = loader;
	_tmp15_ = gdk_pixbuf_loader_get_pixbuf (_tmp14_);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	pixbuf = _tmp16_;
	_tmp17_ = pixbuf;
	_tmp18_ = gdk_pixbuf_get_width (_tmp17_);
	_tmp19_ = pixbuf;
	_tmp20_ = gdk_pixbuf_get_height (_tmp19_);
	_tmp21_ = gdk_pixmap_new (NULL, _tmp18_, _tmp20_, 24);
	pixmap = _tmp21_;
	_tmp22_ = pixmap;
	_tmp23_ = gdk_cairo_create ((GdkDrawable*) _tmp22_);
	cr = _tmp23_;
	_tmp24_ = cr;
	_tmp25_ = pixbuf;
	gdk_cairo_set_source_pixbuf (_tmp24_, _tmp25_, (gdouble) 0, (gdouble) 0);
	_tmp26_ = cr;
	_tmp27_ = pixbuf;
	_tmp28_ = gdk_pixbuf_get_width (_tmp27_);
	_tmp29_ = pixbuf;
	_tmp30_ = gdk_pixbuf_get_height (_tmp29_);
	cairo_rectangle (_tmp26_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp28_, (gdouble) _tmp30_);
	_tmp31_ = cr;
	cairo_fill (_tmp31_);
	result = pixmap;
	_cairo_destroy0 (cr);
	_g_object_unref0 (pixbuf);
	_g_object_unref0 (loader);
	_g_object_unref0 (item);
	return result;
}


static void pdfpc_renderer_cache_png_engine_class_init (pdfpcRendererCachePNGEngineClass * klass) {
	pdfpc_renderer_cache_png_engine_parent_class = g_type_class_peek_parent (klass);
	PDFPC_RENDERER_CACHE_BASE_CLASS (klass)->store = pdfpc_renderer_cache_png_engine_real_store;
	PDFPC_RENDERER_CACHE_BASE_CLASS (klass)->retrieve = pdfpc_renderer_cache_png_engine_real_retrieve;
	G_OBJECT_CLASS (klass)->finalize = pdfpc_renderer_cache_png_engine_finalize;
}


static void pdfpc_renderer_cache_png_engine_instance_init (pdfpcRendererCachePNGEngine * self) {
	GMutex* _tmp0_;
	self->storage = NULL;
	_tmp0_ = g_mutex_new ();
	self->mutex = _tmp0_;
}


static void pdfpc_renderer_cache_png_engine_finalize (GObject* obj) {
	pdfpcRendererCachePNGEngine * self;
	self = PDFPC_RENDERER_CACHE_PNG_ENGINE (obj);
	self->storage = (_vala_array_free (self->storage, self->storage_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_mutex_free0 (self->mutex);
	G_OBJECT_CLASS (pdfpc_renderer_cache_png_engine_parent_class)->finalize (obj);
}


/**
     * Cache store which holds all given items in memory as compressed png
     * images
     */
GType pdfpc_renderer_cache_png_engine_get_type (void) {
	static volatile gsize pdfpc_renderer_cache_png_engine_type_id__volatile = 0;
	if (g_once_init_enter (&pdfpc_renderer_cache_png_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (pdfpcRendererCachePNGEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_renderer_cache_png_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcRendererCachePNGEngine), 0, (GInstanceInitFunc) pdfpc_renderer_cache_png_engine_instance_init, NULL };
		GType pdfpc_renderer_cache_png_engine_type_id;
		pdfpc_renderer_cache_png_engine_type_id = g_type_register_static (PDFPC_RENDERER_CACHE_TYPE_BASE, "pdfpcRendererCachePNGEngine", &g_define_type_info, 0);
		g_once_init_leave (&pdfpc_renderer_cache_png_engine_type_id__volatile, pdfpc_renderer_cache_png_engine_type_id);
	}
	return pdfpc_renderer_cache_png_engine_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



