<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exslt="http://exslt.org/common"
                xmlns:str="http://exslt.org/strings"
                extension-element-prefixes="exslt str"
                version="1.0">

<!-- 
     This file contains templates for upgrading PhotoML files from
     DTD version 0.12 to version 0.13.

     Copyright © 2010 Brendt Wohlberg <photoml@wohlberg.net>

     This is free software; you can redistribute it and/or modify it 
     under the terms of version 2 of the GNU General Public License 
     at http://www.gnu.org/licenses/gpl-2.0.txt.

     This software is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
     GNU General Public License for more details.
-->

<xsl:output method="xml" indent="yes" encoding="utf-8"
	    doctype-public="-//BW//DTD PhotoML 0.13//EN"
            doctype-system="photo.dtd"/>

<!-- Default template -->
<xsl:template match="*|@*|text()|processing-instruction()|comment()">
  <xsl:copy>
    <xsl:apply-templates select="*|@*|text()|processing-instruction()|comment()"/>
  </xsl:copy>
</xsl:template>


<!-- Handle renaming of idximage to index-image -->
<xsl:template match="idximage" xmlns:xlink="http://www.w3.org/1999/xlink">
  <index-image href="{@xlink:href}"/>
</xsl:template>


<!-- Handle renaming of source to source-image -->
<xsl:template match="source">
  <source-image>
    <xsl:apply-templates select="*|@*|text()|processing-instruction()|comment()"/>
  </source-image>
</xsl:template>


<!-- Handle removal of properties/geometry -->
<xsl:template match="geometry">
  <xsl:apply-templates select="width"/>
  <xsl:apply-templates select="height | ../node()[following-sibling::geometry
                                                  and self::text()]"/>
</xsl:template>


<!-- Handle renaming of xlink:href to href -->
<xsl:template match="@xlink:href" xmlns:xlink="http://www.w3.org/1999/xlink">
  <xsl:attribute name="href">
    <xsl:value-of select="."/>
  </xsl:attribute>
</xsl:template>


<!-- Handle removal of other xlink:* attributes -->
<xsl:template match="@xlink:*" xmlns:xlink="http://www.w3.org/1999/xlink"/>


</xsl:stylesheet>
