#!/usr/bin/perl
#
# This script is (c) Julien Miotte 2008
#
use Getopt::Std;
our $opt_n;
our $opt_r;
getopts('n:r:');

print "header {\n";
print "    title = \"DansGuardian picviz analysis\";\n";
print "}\n";

print "axes {\n";
print "    timeline t [label=\"Time\",relative=\"true\"];\n"; 
print "    integer   nP [label=\"Machines\",relative=\"true\"];\n"; 
print "    integer   nR [label=\"Requests\",relative=\"true\"];\n";
print "}\n";

print "data {\n";

$TIME="";
@MACHINES;
$found=0;

while ($line = <>) {
        $line =~ s/\"//g; 
        $line =~ s/,/ /g; 
        $line =~ m/^\S* (\d+:\d+):\d+ (\w*.\w*) (\S*) http:\/\/([\w\.-]*)(\S*) /;
        
        $time=$1;
        $name=$2;
        $ipaddr=$3;
        $url=$4;
        
        $ipaddr =~ m/(\d*)\.(\d*)\.(\d*)\.(\d*)/;
        $a=$1;
        $b=$2;
        $c=$3;
        $d=$4;      
        $ipaddr = $d.".".$c.".".$b.".".$a;
         
        if ($TIME eq "") {
            $TIME=$time;
        }
        if ($time ne $TIME) {
            $#MACHINES++;
            foreach (@MACHINES) {
                if ($_->[0] ne ""){
                    print "      t=\"$TIME\",nP=\"$_->[0]\",nR=\"$_->[1]\"";
                    if ($opt_n) {
                        if($_->[1] > (2*int($opt_n))) {
                            print " [color=\"red\",penwidth=\"1.1\"]";
                        }
                        else {
                            if($_->[1] > int($opt_n)) {
                                print " [color=\"blue\"]";
                            }
                        }
                    }
                    
                    print ";\n";
                }
            }
            $TIME=$time;
            $#MACHINES=-1;
        }
        $found=0; 
        foreach (@MACHINES){
            if ($_->[0] eq $ipaddr) {
                $found=1;
                $_->[1]+=1;
                last;
            }
        }
        if ($found==0) {
            @temp=($ipaddr,0);
            $MACHINES[$#MACHINES+1]=[@temp];
        }
}
print "}\n";
