/*
 * Picviz - Parallel coordinates ploter
 * Copyright (C) 2008 Sebastien Tricaud <toady@gscore.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $Id: variable.c 374 2009-01-20 18:08:24Z toady $
 */

#include <stdio.h>
#include <picviz.h>

//PcvHeight picviz_variable_max(datatype_t vartype)
PcvHeight picviz_variable_max(PicvizImage *image, int string_algo, int vartype)
{

        switch (vartype) {
                case DATATYPE_EMPTY:
                        return EMPTY_TYPE_MAX_YVAL;
                case DATATYPE_SHORT:
                        return SHORT_TYPE_MAX_YVAL;
		case DATATYPE_PORT:
		case DATATYPE_INTEGER:
                        return INTEGER_TYPE_MAX_YVAL;
                case DATATYPE_FLOAT:
                        return FLOAT_TYPE_MAX_YVAL;
                case DATATYPE_STRING:
			if (string_algo == 0) {
				return STRING_TYPE_BASIC_MAX_YVAL;
			}
                        return STRING_TYPE_MAX_YVAL;
                case DATATYPE_TIMELINE:
                        return TIMELINE_TYPE_MAX_YVAL;
                case DATATYPE_IPV4:
                        return IPV4_TYPE_MAX_YVAL;
                case DATATYPE_CHAR:
                        return CHAR_TYPE_MAX_YVAL;
                case DATATYPE_GOLD:
                        return GOLDNUMBER_TYPE_MAX_YVAL;
                case DATATYPE_YEARS:
                        return YEARS_TYPE_MAX_YVAL;
                case DATATYPE_ENUM:
                        return image->height;
                case DATATYPE_LN:
                        return image->height;
		default:
			fprintf(stderr, "ERROR! Impossible to map variable!\n");
                        return EMPTY_TYPE_MAX_YVAL;

        }
}
