#!/bin/sh

#/*****************************************************************************
# *                                                                           *
# *   PLAST : Parallel Local Alignment Search Tool                            *
# *   Copyright (c) 2009-2015 Inria                                           *
# *                                                                           *
# *   PLAST is free software; you can redistribute it and/or modify it under  *
# *   the Affero GPL v3 License                                               *
# *                                                                           *
# *   This program is distributed in the hope that it will be useful,         *
# *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
# *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
# *   CECILL version 2 License for more details.                              *
# *****************************************************************************/

# We get the directory of the script (absolute path)
_scripts_dir=$( cd -P -- "$(dirname -- "$(command -v -- "$0")")" && pwd -P )
_result=$_scripts_dir/out.txt

echo "Start PLAST..."
echo

# We setup a PLAST command-line and run it to test the software
_cmdline="$_scripts_dir/../build/bin/plast -p plastp -i $_scripts_dir/../db/query.fa -d $_scripts_dir/../db/tursiops.fa -o $_result"

echo $_cmdline

eval $_cmdline

echo
echo " done!"
echo
echo "Read:" $_result
echo
echo

