//
// MySQLException.cpp
//
// $Id: //poco/1.3/Data/MySQL/src/Binder.cpp#4 $
//
// Library: Data/MySQL
// Package: MySQL
// Module:  Binder
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Data/MySQL/Binder.h"


namespace Poco {
namespace Data {
namespace MySQL {


Binder::Binder()
{
}
	

Binder::~Binder()
{
}


void Binder::bind(std::size_t pos, const Poco::Int8& val)
{
	realBind(pos, MYSQL_TYPE_TINY, &val, 0);
}


void Binder::bind(std::size_t pos, const Poco::UInt8& val)
{
	realBind(pos, MYSQL_TYPE_TINY, &val, 0);
}


void Binder::bind(std::size_t pos, const Poco::Int16& val)
{
	realBind(pos, MYSQL_TYPE_SHORT, &val, 0);
}


void Binder::bind(std::size_t pos, const Poco::UInt16& val)
{
	realBind(pos, MYSQL_TYPE_SHORT, &val, 0);
}


void Binder::bind(std::size_t pos, const Poco::Int32& val)
{
	realBind(pos, MYSQL_TYPE_LONG, &val, 0);
}


void Binder::bind(std::size_t pos, const Poco::UInt32& val)
{
	realBind(pos, MYSQL_TYPE_LONG, &val, 0);
}


void Binder::bind(std::size_t pos, const Poco::Int64& val)
{
	realBind(pos, MYSQL_TYPE_LONGLONG, &val, 0);
}


void Binder::bind(std::size_t pos, const Poco::UInt64& val)
{
	realBind(pos, MYSQL_TYPE_LONGLONG, &val, 0);
}


void Binder::bind(std::size_t pos, const bool& val)
{
	realBind(pos, MYSQL_TYPE_TINY, &val, 0);
}


void Binder::bind(std::size_t pos, const float& val)
{
	realBind(pos, MYSQL_TYPE_FLOAT, &val, 0);
}


void Binder::bind(std::size_t pos, const double& val)
{
	realBind(pos, MYSQL_TYPE_DOUBLE, &val, 0);
}


void Binder::bind(std::size_t pos, const char& val)
{
	realBind(pos, MYSQL_TYPE_TINY, &val, 0);
}


void Binder::bind(std::size_t pos, const std::string& val)
{
	realBind(pos, MYSQL_TYPE_STRING, val.c_str(), static_cast<int>(val.length()));
}


void Binder::bind(std::size_t pos, const Poco::Data::BLOB& val)
{
	realBind(pos, MYSQL_TYPE_STRING, val.rawContent(), static_cast<int>(val.size()));
}


size_t Binder::size() const
{
	return _bindArray.size();
}


MYSQL_BIND* Binder::getBindArray() const
{
	if (_bindArray.size() == 0)
	{
		return 0;
	}

	return const_cast<MYSQL_BIND*>(&_bindArray[0]);
}


void Binder::realBind(std::size_t pos, enum_field_types type, const void* buffer, int length)
{
	if (pos > 1024) 
	{
		throw StatementException("too many bind parameters");
	}

	if (pos >= _bindArray.size())
	{
		size_t s = _bindArray.size();
		_bindArray.resize(pos + 1);

		std::memset(&_bindArray[s], 0, sizeof(MYSQL_BIND) * (_bindArray.size() - s));
	}

	MYSQL_BIND b = {0};

	b.buffer_type   = type;
	b.buffer        = const_cast<void*>(buffer);
	b.buffer_length = length;

	_bindArray[pos] = b;
}


} } } // namespace Poco::Data::MySQL
