//
// ZipDataInfo.cpp
//
// $Id: //poco/1.3/Zip/src/ZipDataInfo.cpp#3 $
//
// Library: Zip
// Package: Zip
// Module:  ZipDataInfo
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Zip/ZipDataInfo.h"
#include <istream>
#include <cstring>


namespace Poco {
namespace Zip {


const char ZipDataInfo::HEADER[ZipCommon::HEADER_SIZE] = {'\x50', '\x4b', '\x07', '\x08'};


ZipDataInfo::ZipDataInfo():
	_rawInfo(),
	_valid(true)
{
	std::memcpy(_rawInfo, HEADER, ZipCommon::HEADER_SIZE);
	std::memset(_rawInfo+ZipCommon::HEADER_SIZE, 0, FULLHEADER_SIZE - ZipCommon::HEADER_SIZE);
	_valid = true;
}


ZipDataInfo::ZipDataInfo(std::istream& in, bool assumeHeaderRead):
	_rawInfo(),
	_valid(false)
{
	if (assumeHeaderRead)
		std::memcpy(_rawInfo, HEADER, ZipCommon::HEADER_SIZE);
	else
		in.read(_rawInfo, ZipCommon::HEADER_SIZE);
	poco_assert (std::memcmp(_rawInfo, HEADER, ZipCommon::HEADER_SIZE) == 0);
	// now copy the rest of the header
	in.read(_rawInfo+ZipCommon::HEADER_SIZE, FULLHEADER_SIZE - ZipCommon::HEADER_SIZE);
	_valid = (!in.eof() && in.good());
}


ZipDataInfo::~ZipDataInfo()
{
}


} } // namespace Poco::Zip
