# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .replica_info import ReplicaInfo


class StatelessServiceInstanceInfo(ReplicaInfo):
    """Represents a stateless service instance. This includes information about
    the identity, status, health, node name, uptime, and other details about
    the instance.

    :param replica_status: Possible values include: 'Invalid', 'InBuild',
     'Standby', 'Ready', 'Down', 'Dropped'
    :type replica_status: str
    :param health_state: Possible values include: 'Invalid', 'Ok', 'Warning',
     'Error', 'Unknown'
    :type health_state: str
    :param node_name: The name of the node.
    :type node_name: str
    :param address: The address the replica is listening on.
    :type address: str
    :param last_in_build_duration_in_seconds: The last in build duration of
     the replica in seconds.
    :type last_in_build_duration_in_seconds: str
    :param ServiceKind: Polymorphic Discriminator
    :type ServiceKind: str
    :param instance_id: Id of the stateless service instance.
    :type instance_id: str
    """ 

    _validation = {
        'ServiceKind': {'required': True},
    }

    _attribute_map = {
        'replica_status': {'key': 'ReplicaStatus', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'address': {'key': 'Address', 'type': 'str'},
        'last_in_build_duration_in_seconds': {'key': 'LastInBuildDurationInSeconds', 'type': 'str'},
        'ServiceKind': {'key': 'ServiceKind', 'type': 'str'},
        'instance_id': {'key': 'InstanceId', 'type': 'str'},
    }

    def __init__(self, replica_status=None, health_state=None, node_name=None, address=None, last_in_build_duration_in_seconds=None, instance_id=None):
        super(StatelessServiceInstanceInfo, self).__init__(replica_status=replica_status, health_state=health_state, node_name=node_name, address=address, last_in_build_duration_in_seconds=last_in_build_duration_in_seconds)
        self.instance_id = instance_id
        self.ServiceKind = 'Stateless'
