# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GraphNode(Model):
    """Specifies a node in the web service graph. The node can either be an input,
    output or asset node, so only one of the corresponding id properties is
    populated at any given time.

    :param asset_id: The id of the asset represented by this node.
    :type asset_id: str
    :param input_id: The id of the input element represented by this node.
    :type input_id: str
    :param output_id: The id of the output element represented by this node.
    :type output_id: str
    :param parameters: If applicable, parameters of the node. Global graph
     parameters map into these, with values set at runtime.
    :type parameters: dict
    """

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'input_id': {'key': 'inputId', 'type': 'str'},
        'output_id': {'key': 'outputId', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{str}'},
    }

    def __init__(self, asset_id=None, input_id=None, output_id=None, parameters=None):
        self.asset_id = asset_id
        self.input_id = input_id
        self.output_id = output_id
        self.parameters = parameters
