# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class CostThresholdStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates whether this threshold will be displayed on cost charts.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class CostType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the cost.
    """

    UNAVAILABLE = "Unavailable"
    REPORTED = "Reported"
    PROJECTED = "Projected"

class CustomImageOsType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The OS type of the custom image (i.e. Windows, Linux)
    """

    WINDOWS = "Windows"
    LINUX = "Linux"
    NONE = "None"

class EnableStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """If notifications are enabled for this schedule (i.e. Enabled, Disabled).
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class EnvironmentPermission(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The access rights to be granted to the user when provisioning an environment
    """

    READER = "Reader"
    CONTRIBUTOR = "Contributor"

class FileUploadOptions(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Options for uploading the files for the artifact. UploadFilesAndGenerateSasTokens is the
    default value.
    """

    UPLOAD_FILES_AND_GENERATE_SAS_TOKENS = "UploadFilesAndGenerateSasTokens"
    NONE = "None"

class HostCachingOptions(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Caching option for a data disk (i.e. None, ReadOnly, ReadWrite).
    """

    NONE = "None"
    READ_ONLY = "ReadOnly"
    READ_WRITE = "ReadWrite"

class HttpStatusCode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status code for the operation.
    """

    CONTINUE_ENUM = "Continue"
    SWITCHING_PROTOCOLS = "SwitchingProtocols"
    OK = "OK"
    CREATED = "Created"
    ACCEPTED = "Accepted"
    NON_AUTHORITATIVE_INFORMATION = "NonAuthoritativeInformation"
    NO_CONTENT = "NoContent"
    RESET_CONTENT = "ResetContent"
    PARTIAL_CONTENT = "PartialContent"
    MULTIPLE_CHOICES = "MultipleChoices"
    MOVED_PERMANENTLY = "MovedPermanently"
    REDIRECT = "Redirect"
    SEE_OTHER = "SeeOther"
    NOT_MODIFIED = "NotModified"
    USE_PROXY = "UseProxy"
    UNUSED = "Unused"
    TEMPORARY_REDIRECT = "TemporaryRedirect"
    BAD_REQUEST = "BadRequest"
    UNAUTHORIZED = "Unauthorized"
    PAYMENT_REQUIRED = "PaymentRequired"
    FORBIDDEN = "Forbidden"
    NOT_FOUND = "NotFound"
    METHOD_NOT_ALLOWED = "MethodNotAllowed"
    NOT_ACCEPTABLE = "NotAcceptable"
    PROXY_AUTHENTICATION_REQUIRED = "ProxyAuthenticationRequired"
    REQUEST_TIMEOUT = "RequestTimeout"
    CONFLICT = "Conflict"
    GONE = "Gone"
    LENGTH_REQUIRED = "LengthRequired"
    PRECONDITION_FAILED = "PreconditionFailed"
    REQUEST_ENTITY_TOO_LARGE = "RequestEntityTooLarge"
    REQUEST_URI_TOO_LONG = "RequestUriTooLong"
    UNSUPPORTED_MEDIA_TYPE = "UnsupportedMediaType"
    REQUESTED_RANGE_NOT_SATISFIABLE = "RequestedRangeNotSatisfiable"
    EXPECTATION_FAILED = "ExpectationFailed"
    UPGRADE_REQUIRED = "UpgradeRequired"
    INTERNAL_SERVER_ERROR = "InternalServerError"
    NOT_IMPLEMENTED = "NotImplemented"
    BAD_GATEWAY = "BadGateway"
    SERVICE_UNAVAILABLE = "ServiceUnavailable"
    GATEWAY_TIMEOUT = "GatewayTimeout"
    HTTP_VERSION_NOT_SUPPORTED = "HttpVersionNotSupported"

class LinuxOsState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
    """

    NON_DEPROVISIONED = "NonDeprovisioned"
    DEPROVISION_REQUESTED = "DeprovisionRequested"
    DEPROVISION_APPLIED = "DeprovisionApplied"

class NotificationChannelEventType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The event type for which this notification is enabled (i.e. AutoShutdown, Cost)
    """

    AUTO_SHUTDOWN = "AutoShutdown"
    COST = "Cost"

class PolicyEvaluatorType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy).
    """

    ALLOWED_VALUES_POLICY = "AllowedValuesPolicy"
    MAX_VALUE_POLICY = "MaxValuePolicy"

class PolicyFactName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc.
    """

    USER_OWNED_LAB_VM_COUNT = "UserOwnedLabVmCount"
    USER_OWNED_LAB_PREMIUM_VM_COUNT = "UserOwnedLabPremiumVmCount"
    LAB_VM_COUNT = "LabVmCount"
    LAB_PREMIUM_VM_COUNT = "LabPremiumVmCount"
    LAB_VM_SIZE = "LabVmSize"
    GALLERY_IMAGE = "GalleryImage"
    USER_OWNED_LAB_VM_COUNT_IN_SUBNET = "UserOwnedLabVmCountInSubnet"
    LAB_TARGET_COST = "LabTargetCost"
    ENVIRONMENT_TEMPLATE = "EnvironmentTemplate"
    SCHEDULE_EDIT_PERMISSION = "ScheduleEditPermission"

class PolicyStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the policy.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class PremiumDataDisk(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The setting to enable usage of premium data disks.
    When its value is 'Enabled', creation of standard or premium data disks is allowed.
    When its value is 'Disabled', only creation of standard data disks is allowed.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class ReportingCycleType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Reporting cycle type.
    """

    CALENDAR_MONTH = "CalendarMonth"
    CUSTOM = "Custom"

class SourceControlType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The artifact source's type.
    """

    VSO_GIT = "VsoGit"
    GIT_HUB = "GitHub"

class StorageType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The storage type for the disk (i.e. Standard, Premium).
    """

    STANDARD = "Standard"
    PREMIUM = "Premium"
    STANDARD_SSD = "StandardSSD"

class TargetCostStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Target cost status
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class TransportProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The transport protocol for the endpoint.
    """

    TCP = "Tcp"
    UDP = "Udp"

class UsagePermissionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)).
    """

    DEFAULT = "Default"
    DENY = "Deny"
    ALLOW = "Allow"

class VirtualMachineCreationSource(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Tells source of creation of lab virtual machine. Output property only.
    """

    FROM_CUSTOM_IMAGE = "FromCustomImage"
    FROM_GALLERY_IMAGE = "FromGalleryImage"
    FROM_SHARED_GALLERY_IMAGE = "FromSharedGalleryImage"

class WindowsOsState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
    """

    NON_SYSPREPPED = "NonSysprepped"
    SYSPREP_REQUESTED = "SysprepRequested"
    SYSPREP_APPLIED = "SysprepApplied"
