# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import TYPE_CHECKING

from azure.core import PipelineClient
from msrest import Deserializer, Serializer

from ._configuration import PurviewCatalogClientConfiguration
from .operations import CollectionOperations, DiscoveryOperations, EntityOperations, GlossaryOperations, LineageOperations, RelationshipOperations, TypesOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Dict, Optional

    from azure.core.credentials import TokenCredential
    from azure.core.rest import HttpRequest, HttpResponse

class PurviewCatalogClient(object):
    """Purview Catalog Service is a fully managed cloud service whose users can discover the data sources they need and understand the data sources they find. At the same time, Data Catalog helps organizations get more value from their existing investments. This spec defines REST API of Purview Catalog Service.

    :ivar entity: EntityOperations operations
    :vartype entity: azure.purview.catalog.operations.EntityOperations
    :ivar glossary: GlossaryOperations operations
    :vartype glossary: azure.purview.catalog.operations.GlossaryOperations
    :ivar discovery: DiscoveryOperations operations
    :vartype discovery: azure.purview.catalog.operations.DiscoveryOperations
    :ivar lineage: LineageOperations operations
    :vartype lineage: azure.purview.catalog.operations.LineageOperations
    :ivar relationship: RelationshipOperations operations
    :vartype relationship: azure.purview.catalog.operations.RelationshipOperations
    :ivar types: TypesOperations operations
    :vartype types: azure.purview.catalog.operations.TypesOperations
    :ivar collection: CollectionOperations operations
    :vartype collection: azure.purview.catalog.operations.CollectionOperations
    :param endpoint: The catalog endpoint of your Purview account. Example:
     https://{accountName}.purview.azure.com.
    :type endpoint: str
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        endpoint,  # type: str
        credential,  # type: "TokenCredential"
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        _endpoint = '{Endpoint}/catalog/api'
        self._config = PurviewCatalogClientConfiguration(endpoint, credential, **kwargs)
        self._client = PipelineClient(base_url=_endpoint, config=self._config, **kwargs)

        self._serialize = Serializer()
        self._deserialize = Deserializer()
        self._serialize.client_side_validation = False
        self.entity = EntityOperations(self._client, self._config, self._serialize, self._deserialize)
        self.glossary = GlossaryOperations(self._client, self._config, self._serialize, self._deserialize)
        self.discovery = DiscoveryOperations(self._client, self._config, self._serialize, self._deserialize)
        self.lineage = LineageOperations(self._client, self._config, self._serialize, self._deserialize)
        self.relationship = RelationshipOperations(self._client, self._config, self._serialize, self._deserialize)
        self.types = TypesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.collection = CollectionOperations(self._client, self._config, self._serialize, self._deserialize)


    def send_request(
        self,
        request,  # type: HttpRequest
        **kwargs  # type: Any
    ):
        # type: (...) -> HttpResponse
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client.send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        request_copy.url = self._client.format_url(request_copy.url, **path_format_arguments)
        return self._client.send_request(request_copy, **kwargs)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> PurviewCatalogClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
