# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar, Union

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class QuotaOperations(object):
    """QuotaOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.reservations.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def get(
        self,
        subscription_id,  # type: str
        provider_id,  # type: str
        location,  # type: str
        resource_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CurrentQuotaLimitBase"
        """Get the current quota (service limit) and usage of a resource. You can use the response from
        the GET operation to submit quota update request.

        :param subscription_id: Azure subscription ID.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID.
        :type provider_id: str
        :param location: Azure region.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CurrentQuotaLimitBase, or the result of cls(response)
        :rtype: ~azure.mgmt.reservations.models.CurrentQuotaLimitBase
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CurrentQuotaLimitBase"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-10-25"
        accept = "application/json"

        # Construct URL
        url = self.get.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'providerId': self._serialize.url("provider_id", provider_id, 'str'),
            'location': self._serialize.url("location", location, 'str'),
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('CurrentQuotaLimitBase', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}'}  # type: ignore

    def _create_or_update_initial(
        self,
        subscription_id,  # type: str
        provider_id,  # type: str
        location,  # type: str
        resource_name,  # type: str
        create_quota_request,  # type: "_models.CurrentQuotaLimitBase"
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.QuotaRequestOneResourceSubmitResponse", "_models.QuotaRequestSubmitResponse201"]
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.QuotaRequestOneResourceSubmitResponse", "_models.QuotaRequestSubmitResponse201"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-10-25"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self._create_or_update_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'providerId': self._serialize.url("provider_id", provider_id, 'str'),
            'location': self._serialize.url("location", location, 'str'),
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(create_quota_request, 'CurrentQuotaLimitBase')
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('QuotaRequestOneResourceSubmitResponse', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('QuotaRequestSubmitResponse201', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    _create_or_update_initial.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}'}  # type: ignore

    def begin_create_or_update(
        self,
        subscription_id,  # type: str
        provider_id,  # type: str
        location,  # type: str
        resource_name,  # type: str
        create_quota_request,  # type: "_models.CurrentQuotaLimitBase"
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[Union["_models.QuotaRequestOneResourceSubmitResponse", "_models.QuotaRequestSubmitResponse201"]]
        """Create or update the quota (service limits) of a resource to the requested value.
         Steps:


        #.
           Make the Get request to get the quota information for specific resource.

        #.
           To increase the quota, update the limit field in the response from Get request to new value.

        #.
           Submit the JSON to the quota request API to update the quota.
           The Create quota request may be constructed as follows. The PUT operation can be used to
        update the quota.

        :param subscription_id: Azure subscription ID.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID.
        :type provider_id: str
        :param location: Azure region.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
        :type resource_name: str
        :param create_quota_request: Quota requests payload.
        :type create_quota_request: ~azure.mgmt.reservations.models.CurrentQuotaLimitBase
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either QuotaRequestOneResourceSubmitResponse or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.reservations.models.QuotaRequestOneResourceSubmitResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.QuotaRequestOneResourceSubmitResponse", "_models.QuotaRequestSubmitResponse201"]]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._create_or_update_initial(
                subscription_id=subscription_id,
                provider_id=provider_id,
                location=location,
                resource_name=resource_name,
                create_quota_request=create_quota_request,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize('QuotaRequestOneResourceSubmitResponse', pipeline_response)

            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'providerId': self._serialize.url("provider_id", provider_id, 'str'),
            'location': self._serialize.url("location", location, 'str'),
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
        }

        if polling is True: polling_method = ARMPolling(lro_delay, lro_options={'final-state-via': 'location'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_create_or_update.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}'}  # type: ignore

    def _update_initial(
        self,
        subscription_id,  # type: str
        provider_id,  # type: str
        location,  # type: str
        resource_name,  # type: str
        create_quota_request,  # type: "_models.CurrentQuotaLimitBase"
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.QuotaRequestOneResourceSubmitResponse", "_models.QuotaRequestSubmitResponse201"]
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.QuotaRequestOneResourceSubmitResponse", "_models.QuotaRequestSubmitResponse201"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-10-25"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self._update_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'providerId': self._serialize.url("provider_id", provider_id, 'str'),
            'location': self._serialize.url("location", location, 'str'),
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(create_quota_request, 'CurrentQuotaLimitBase')
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('QuotaRequestOneResourceSubmitResponse', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('QuotaRequestSubmitResponse201', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    _update_initial.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}'}  # type: ignore

    def begin_update(
        self,
        subscription_id,  # type: str
        provider_id,  # type: str
        location,  # type: str
        resource_name,  # type: str
        create_quota_request,  # type: "_models.CurrentQuotaLimitBase"
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[Union["_models.QuotaRequestOneResourceSubmitResponse", "_models.QuotaRequestSubmitResponse201"]]
        """Update the quota (service limits) of this resource to the requested value.

          • To get the quota information for specific resource, send a GET request.

          • To increase the quota, update the limit field from the GET response to a new value.

          • To update the quota value, submit the JSON response to the quota request API to update the
        quota.
          • To update the quota. use the PATCH operation.

        :param subscription_id: Azure subscription ID.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID.
        :type provider_id: str
        :param location: Azure region.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
        :type resource_name: str
        :param create_quota_request: Payload for the quota request.
        :type create_quota_request: ~azure.mgmt.reservations.models.CurrentQuotaLimitBase
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either QuotaRequestOneResourceSubmitResponse or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.reservations.models.QuotaRequestOneResourceSubmitResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.QuotaRequestOneResourceSubmitResponse", "_models.QuotaRequestSubmitResponse201"]]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._update_initial(
                subscription_id=subscription_id,
                provider_id=provider_id,
                location=location,
                resource_name=resource_name,
                create_quota_request=create_quota_request,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize('QuotaRequestOneResourceSubmitResponse', pipeline_response)

            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'providerId': self._serialize.url("provider_id", provider_id, 'str'),
            'location': self._serialize.url("location", location, 'str'),
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
        }

        if polling is True: polling_method = ARMPolling(lro_delay, lro_options={'final-state-via': 'location'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_update.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}'}  # type: ignore

    def list(
        self,
        subscription_id,  # type: str
        provider_id,  # type: str
        location,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.QuotaLimits"]
        """Gets a list of current quotas (service limits) and usage for all resources. The response from
        the list quota operation can be leveraged to request quota updates.

        :param subscription_id: Azure subscription ID.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID.
        :type provider_id: str
        :param location: Azure region.
        :type location: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either QuotaLimits or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.reservations.models.QuotaLimits]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.QuotaLimits"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-10-25"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list.metadata['url']  # type: ignore
                path_format_arguments = {
                    'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
                    'providerId': self._serialize.url("provider_id", provider_id, 'str'),
                    'location': self._serialize.url("location", location, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('QuotaLimits', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits'}  # type: ignore
