# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AllowedEndpointRecordType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The allowed type DNS record types for this profile.
    """

    DOMAIN_NAME = "DomainName"
    I_PV4_ADDRESS = "IPv4Address"
    I_PV6_ADDRESS = "IPv6Address"
    ANY = "Any"

class EndpointMonitorStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The monitoring status of the endpoint.
    """

    CHECKING_ENDPOINT = "CheckingEndpoint"
    ONLINE = "Online"
    DEGRADED = "Degraded"
    DISABLED = "Disabled"
    INACTIVE = "Inactive"
    STOPPED = "Stopped"

class EndpointStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is
    included in the traffic routing method.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class MonitorProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health.
    """

    HTTP = "HTTP"
    HTTPS = "HTTPS"
    TCP = "TCP"

class ProfileMonitorStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The profile-level monitoring status of the Traffic Manager profile.
    """

    CHECKING_ENDPOINTS = "CheckingEndpoints"
    ONLINE = "Online"
    DEGRADED = "Degraded"
    DISABLED = "Disabled"
    INACTIVE = "Inactive"

class ProfileStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the Traffic Manager profile.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class TrafficRoutingMethod(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The traffic routing method of the Traffic Manager profile.
    """

    PERFORMANCE = "Performance"
    PRIORITY = "Priority"
    WEIGHTED = "Weighted"
    GEOGRAPHIC = "Geographic"
    MULTI_VALUE = "MultiValue"
    SUBNET = "Subnet"

class TrafficViewEnrollmentStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates whether Traffic View is 'Enabled' or 'Disabled' for the Traffic Manager profile.
    Null, indicates 'Disabled'. Enabling this feature will increase the cost of the Traffic Manage
    profile.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"
