# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.billing import BillingManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBillingManagementBillingPropertyOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BillingManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.billing_property.get(
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.billing_property.update(
            parameters={
                "id": "str",
                "name": "str",
                "properties": {
                    "accountAdminNotificationEmailAddress": "str",
                    "billingAccountAgreementType": "str",
                    "billingAccountDisplayName": "str",
                    "billingAccountId": "str",
                    "billingAccountSoldToCountry": "str",
                    "billingAccountStatus": "str",
                    "billingAccountStatusReasonCode": "str",
                    "billingAccountSubType": "str",
                    "billingAccountType": "str",
                    "billingCurrency": "str",
                    "billingProfileDisplayName": "str",
                    "billingProfileId": "str",
                    "billingProfilePaymentMethodFamily": "str",
                    "billingProfilePaymentMethodType": "str",
                    "billingProfileSpendingLimit": "str",
                    "billingProfileSpendingLimitDetails": [
                        {
                            "amount": 0.0,
                            "currency": "str",
                            "endDate": "2020-02-20 00:00:00",
                            "startDate": "2020-02-20 00:00:00",
                            "status": "str",
                            "type": "str",
                        }
                    ],
                    "billingProfileStatus": "str",
                    "billingProfileStatusReasonCode": "str",
                    "billingTenantId": "str",
                    "costCenter": "str",
                    "customerDisplayName": "str",
                    "customerId": "str",
                    "customerStatus": "str",
                    "enrollmentDetails": {
                        "departmentDisplayName": "str",
                        "departmentId": "str",
                        "enrollmentAccountDisplayName": "str",
                        "enrollmentAccountId": "str",
                        "enrollmentAccountStatus": "str",
                    },
                    "invoiceSectionDisplayName": "str",
                    "invoiceSectionId": "str",
                    "invoiceSectionStatus": "str",
                    "invoiceSectionStatusReasonCode": "str",
                    "isAccountAdmin": bool,
                    "isTransitionedBillingAccount": bool,
                    "productId": "str",
                    "productName": "str",
                    "skuDescription": "str",
                    "skuId": "str",
                    "subscriptionBillingStatus": "str",
                    "subscriptionBillingStatusDetails": [{"effectiveDate": "2020-02-20 00:00:00", "reason": "str"}],
                    "subscriptionBillingType": "str",
                    "subscriptionServiceUsageAddress": {
                        "addressLine1": "str",
                        "country": "str",
                        "addressLine2": "str",
                        "addressLine3": "str",
                        "city": "str",
                        "companyName": "str",
                        "district": "str",
                        "email": "str",
                        "firstName": "str",
                        "isValidAddress": bool,
                        "lastName": "str",
                        "middleName": "str",
                        "phoneNumber": "str",
                        "postalCode": "str",
                        "region": "str",
                    },
                    "subscriptionWorkloadType": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...
