from pathlib import Path

from ._iconfont import IconFont

FONTS = Path(__file__).parent / "fonts"


class FA6R(IconFont):
    """Font Awesome 6 Free-Regular-400."""

    __font_file__ = str(FONTS / "Font Awesome 6 Free-Regular-400.otf")

    address_book = "\uf2b9"
    address_card = "\uf2bb"
    bell = "\uf0f3"
    bell_slash = "\uf1f6"
    bookmark = "\uf02e"
    building = "\uf1ad"
    calendar = "\uf133"
    calendar_check = "\uf274"
    calendar_days = "\uf073"
    calendar_minus = "\uf272"
    calendar_plus = "\uf271"
    calendar_xmark = "\uf273"
    chart_bar = "\uf080"
    chess_bishop = "\uf43a"
    chess_king = "\uf43f"
    chess_knight = "\uf441"
    chess_pawn = "\uf443"
    chess_queen = "\uf445"
    chess_rook = "\uf447"
    circle = "\uf111"
    circle_check = "\uf058"
    circle_dot = "\uf192"
    circle_down = "\uf358"
    circle_left = "\uf359"
    circle_pause = "\uf28b"
    circle_play = "\uf144"
    circle_question = "\uf059"
    circle_right = "\uf35a"
    circle_stop = "\uf28d"
    circle_up = "\uf35b"
    circle_user = "\uf2bd"
    circle_xmark = "\uf057"
    clipboard = "\uf328"
    clock = "\uf017"
    clone = "\uf24d"
    closed_captioning = "\uf20a"
    comment = "\uf075"
    comment_dots = "\uf4ad"
    comments = "\uf086"
    compass = "\uf14e"
    copy = "\uf0c5"
    copyright = "\uf1f9"
    credit_card = "\uf09d"
    envelope = "\uf0e0"
    envelope_open = "\uf2b6"
    eye = "\uf06e"
    eye_slash = "\uf070"
    face_angry = "\uf556"
    face_dizzy = "\uf567"
    face_flushed = "\uf579"
    face_frown = "\uf119"
    face_frown_open = "\uf57a"
    face_grimace = "\uf57f"
    face_grin = "\uf580"
    face_grin_beam = "\uf582"
    face_grin_beam_sweat = "\uf583"
    face_grin_hearts = "\uf584"
    face_grin_squint = "\uf585"
    face_grin_squint_tears = "\uf586"
    face_grin_stars = "\uf587"
    face_grin_tears = "\uf588"
    face_grin_tongue = "\uf589"
    face_grin_tongue_squint = "\uf58a"
    face_grin_tongue_wink = "\uf58b"
    face_grin_wide = "\uf581"
    face_grin_wink = "\uf58c"
    face_kiss = "\uf596"
    face_kiss_beam = "\uf597"
    face_kiss_wink_heart = "\uf598"
    face_laugh = "\uf599"
    face_laugh_beam = "\uf59a"
    face_laugh_squint = "\uf59b"
    face_laugh_wink = "\uf59c"
    face_meh = "\uf11a"
    face_meh_blank = "\uf5a4"
    face_rolling_eyes = "\uf5a5"
    face_sad_cry = "\uf5b3"
    face_sad_tear = "\uf5b4"
    face_smile = "\uf118"
    face_smile_beam = "\uf5b8"
    face_smile_wink = "\uf4da"
    face_surprise = "\uf5c2"
    face_tired = "\uf5c8"
    file = "\uf15b"
    file_audio = "\uf1c7"
    file_code = "\uf1c9"
    file_excel = "\uf1c3"
    file_image = "\uf1c5"
    file_lines = "\uf15c"
    file_pdf = "\uf1c1"
    file_powerpoint = "\uf1c4"
    file_video = "\uf1c8"
    file_word = "\uf1c2"
    file_zipper = "\uf1c6"
    flag = "\uf024"
    floppy_disk = "\uf0c7"
    folder = "\uf07b"
    folder_closed = "\ue185"
    folder_open = "\uf07c"
    font_awesome = "\uf2b4"
    futbol = "\uf1e3"
    gem = "\uf3a5"
    hand = "\uf256"
    hand_back_fist = "\uf255"
    hand_lizard = "\uf258"
    hand_peace = "\uf25b"
    hand_point_down = "\uf0a7"
    hand_point_left = "\uf0a5"
    hand_point_right = "\uf0a4"
    hand_point_up = "\uf0a6"
    hand_pointer = "\uf25a"
    hand_scissors = "\uf257"
    hand_spock = "\uf259"
    handshake = "\uf2b5"
    hard_drive = "\uf0a0"
    heart = "\uf004"
    hospital = "\uf0f8"
    hourglass = "\uf254"
    hourglass_half = "\uf252"
    id_badge = "\uf2c1"
    id_card = "\uf2c2"
    image = "\uf03e"
    images = "\uf302"
    keyboard = "\uf11c"
    lemon = "\uf094"
    life_ring = "\uf1cd"
    lightbulb = "\uf0eb"
    map = "\uf279"
    message = "\uf27a"
    money_bill_1 = "\uf3d1"
    moon = "\uf186"
    newspaper = "\uf1ea"
    note_sticky = "\uf249"
    object_group = "\uf247"
    object_ungroup = "\uf248"
    paper_plane = "\uf1d8"
    paste = "\uf0ea"
    pen_to_square = "\uf044"
    rectangle_list = "\uf022"
    rectangle_xmark = "\uf410"
    registered = "\uf25d"
    share_from_square = "\uf14d"
    snowflake = "\uf2dc"
    square = "\uf0c8"
    square_caret_down = "\uf150"
    square_caret_left = "\uf191"
    square_caret_right = "\uf152"
    square_caret_up = "\uf151"
    square_check = "\uf14a"
    square_full = "\uf45c"
    square_minus = "\uf146"
    square_plus = "\uf0fe"
    star = "\uf005"
    star_half = "\uf089"
    star_half_stroke = "\uf5c0"
    sun = "\uf185"
    thumbs_down = "\uf165"
    thumbs_up = "\uf164"
    trash_can = "\uf2ed"
    user = "\uf007"
    window_maximize = "\uf2d0"
    window_minimize = "\uf2d1"
    window_restore = "\uf2d2"
