% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{methods}
\name{plotMA}
\alias{plotMA}
\alias{plotMA,DESeqDataSet-method}
\alias{plotMA,DESeqResults-method}
\title{MA-plot from base means and log fold changes}
\usage{
\S4method{plotMA}{DESeqDataSet}(object, alpha = 0.1, main = "",
  xlab = "mean of normalized counts", ylim, MLE = FALSE, ...)

\S4method{plotMA}{DESeqResults}(object, alpha, main = "",
  xlab = "mean of normalized counts", ylim, MLE = FALSE, ...)
}
\arguments{
\item{object}{a \code{DESeqResults} object produced by \code{\link{results}};
or a \code{DESeqDataSet} processed by \code{\link{DESeq}}, or the
individual functions \code{\link{nbinomWaldTest}} or \code{\link{nbinomLRT}}}

\item{alpha}{the significance level for thresholding adjusted p-values}

\item{main}{optional title for the plot}

\item{xlab}{optional defaults to "mean of normalized counts"}

\item{ylim}{optional y limits}

\item{MLE}{if \code{betaPrior=TRUE} was used,
whether to plot the MLE (unshrunken estimates), defaults to FALSE.
Requires that \code{\link{results}} was run with \code{addMLE=TRUE}.
Note that the MLE will be plotted regardless of this argument,
if DESeq() was run with \code{betaPrior=FALSE}. See \code{\link{lfcShrink}}
for examples on how to plot shrunken log2 fold changes.}

\item{...}{further arguments passed to \code{plotMA} if object
is \code{DESeqResults} or to \code{\link{results}} if object is
\code{DESeqDataSet}}
}
\description{
A simple helper function that makes a so-called "MA-plot", i.e. a
scatter plot of log2 fold changes (on the y-axis) versus the mean of
normalized counts (on the x-axis).
}
\details{
This function is essentially two lines of code: building a
\code{data.frame} and passing this to the \code{plotMA} method
for \code{data.frame} from the geneplotter package.
The code of this function can be seen with:
\code{getMethod("plotMA","DESeqDataSet")}
If users wish to modify the graphical parameters of the plot,
it is recommended to build the data.frame in the
same manner and call \code{plotMA}.
If the \code{object} contains a column \code{svalue} then these
will be used for coloring the points (with a default \code{alpha=0.005}).
}
\examples{

dds <- makeExampleDESeqDataSet()
dds <- DESeq(dds)
plotMA(dds)
res <- results(dds)
plotMA(res)

}
\author{
Michael Love
}
