% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_methods.R
\name{get_imputed_data}
\alias{get_imputed_data}
\title{Get imputed data}
\usage{
get_imputed_data(
  object,
  views = "all",
  groups = "all",
  features = "all",
  as.data.frame = FALSE
)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{views}{character vector with the view name(s), or numeric vector with the view index(es). 
Default is "all".}

\item{groups}{character vector with the group name(s), or numeric vector with the group index(es).
Default is "all".}

\item{features}{list of character vectors with the feature names or list of numeric vectors with the feature indices. 
Default is "all".}

\item{as.data.frame}{logical indicating whether to return a long-formatted data frame instead of a list of matrices. 
Default is \code{FALSE}.}
}
\value{
A list containing the imputed valued or a data.frame if as.data.frame is TRUE
}
\description{
Function to get the imputed data. It requires the previous use of the \code{\link{impute}} method.
}
\details{
Data is imputed from the generative model of MOFA.
}
\examples{
# Using an existing trained model
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)
model <- impute(model)
imputed <- get_imputed_data(model)
}
