% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\title{Do predictions using a fitted MOFA}
\usage{
predict(
  object,
  views = "all",
  groups = "all",
  factors = "all",
  add_intercept = TRUE
)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{views}{character vector with the view name(s), or numeric vector with the view index(es).
Default is "all".}

\item{groups}{character vector with the group name(s), or numeric vector with the group index(es).
Default is "all".}

\item{factors}{character vector with the factor name(s) or numeric vector with the factor index(es).
Default is "all".}

\item{add_intercept}{add feature intercepts to the prediction (default is TRUE).}
}
\value{
Returns a list with the data reconstructed by the model predictions.
}
\description{
This function uses the latent factors and the weights to do data predictions.
}
\details{
MOFA generates a denoised and condensed low-dimensional representation of the data that captures the main sources of heterogeneity of the data.
This representation can be used to reconstruct a denoised representation of the data, simply using the equation \code{Y = WX}. 
For more mathematical details read the supplementary methods of the manuscript.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Predict observations for all data modalities
predictions <- predict(model)
}
